/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.recipe;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.crafting.recipes.SpecialSingleInputRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.qther.ars_unification.ArsUnification;
import dev.qther.ars_unification.Config;
import dev.qther.ars_unification.compat.AUArsTechnicaCompat;
import dev.qther.ars_unification.setup.registry.AURecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;

public record CutRecipe(Ingredient input, List<CutOutput> outputs, boolean skipBlockPlace) implements SpecialSingleInputRecipe
{
    public CutRecipe(Ingredient input, List<CutOutput> outputs) {
        this(input, outputs, false);
    }

    public List<ItemStack> getRolledOutputs(SpellResolver resolver, SpellStats spellStats, RandomSource random) {
        ArrayList<ItemStack> finalOutputs = new ArrayList<ItemStack>();
        for (CutOutput cutRoll : this.outputs) {
            boolean doubleFromTechnica;
            boolean bl = doubleFromTechnica = (double)cutRoll.chance < 1.0 && ModList.get().isLoaded("ars_technica") && (Boolean)Config.CONFIG.ARS_TECHNICA_TRANSMUTATION_FOCUS_CUT_CHANCE_OUTPUT_DOUBLING.get() != false && AUArsTechnicaCompat.shouldDoubleOutputs(resolver);
            if (!(random.nextDouble() <= (double)cutRoll.chance)) continue;
            int num = cutRoll.maxRange > 1 ? random.nextInt(cutRoll.maxRange) + 1 : 1;
            for (int i = 0; i < num; ++i) {
                if (doubleFromTechnica) {
                    finalOutputs.add(cutRoll.stack.copyWithCount(Math.min(cutRoll.stack.getMaxStackSize(), cutRoll.stack.getCount() * 2)));
                    continue;
                }
                finalOutputs.add(cutRoll.stack.copy());
            }
        }
        return finalOutputs;
    }

    public boolean shouldSkipBlockPlace() {
        return this.skipBlockPlace;
    }

    public boolean matches(SingleRecipeInput input, @NotNull Level level) {
        return this.input.test(input.getItem(0));
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AURecipeRegistry.CUT_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)AURecipeRegistry.CUT_TYPE.get();
    }

    public record CutOutput(ItemStack stack, float chance, int maxRange) {
        public static final Codec<CutOutput> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("stack").forGetter(CutOutput::stack), (App)Codec.FLOAT.fieldOf("chance").forGetter(CutOutput::chance), (App)Codec.INT.fieldOf("maxRange").forGetter(CutOutput::maxRange)).apply((Applicative)instance, CutOutput::new));

        public CutOutput(ItemStack stack, float chance) {
            this(stack, chance, 1);
        }
    }

    public static class Serializer
    implements RecipeSerializer<CutRecipe> {
        public static final MapCodec<CutRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("input").forGetter(CutRecipe::input), (App)CutOutput.CODEC.listOf().fieldOf("output").forGetter(CutRecipe::outputs), (App)Codec.BOOL.optionalFieldOf("skip_block_place", (Object)false).forGetter(CutRecipe::shouldSkipBlockPlace)).apply((Applicative)instance, CutRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CutRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static void toNetwork(RegistryFriendlyByteBuf buf, CutRecipe recipe) {
            buf.writeInt(recipe.outputs.size());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.input);
            for (CutOutput i : recipe.outputs) {
                buf.writeFloat(i.chance);
                ItemStack.STREAM_CODEC.encode((Object)buf, (Object)i.stack);
                buf.writeInt(i.maxRange);
            }
            buf.writeBoolean(recipe.skipBlockPlace);
        }

        public static CutRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int length = buffer.readInt();
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ArrayList<CutOutput> stacks = new ArrayList<CutOutput>();
            for (int i = 0; i < length; ++i) {
                try {
                    float chance = buffer.readFloat();
                    ItemStack outStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
                    int maxRange = buffer.readInt();
                    stacks.add(new CutOutput(outStack, chance, maxRange));
                    continue;
                }
                catch (Exception e) {
                    ArsUnification.LOGGER.error("could not deserialize recipe from network", (Throwable)e);
                    break;
                }
            }
            boolean skipBlockPlace = buffer.readBoolean();
            return new CutRecipe(input, stacks, skipBlockPlace);
        }

        @NotNull
        public MapCodec<CutRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CutRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

