ServerEvents.recipes(event => {
  // Coke from coal (heated)
  event.recipes.create.mixing(
    "kubejs:coke",
    [ "minecraft:coal" ]             
  ).heated()

  // Steel Nugget (superheated + fluid input)
  event.recipes.create.mixing(
    "kubejs:steel_nugget",
    [
      "kubejs:coke",
      "northstar:rutile_concentrate",
      "minecraft:iron_nugget",
      "minecraft:flint",
      Fluid.of("createdieselgenerators:crude_oil", 250)
    ]
  ).superheated()

  // Plastic Sheet (superheated + fluid)
  event.recipes.create.mixing(
    "kubejs:plastic_sheet",
    [
      "kubejs:coke",
      "create:pulp",
      Fluid.of("createdieselgenerators:crude_oil", 250)
    ]
  ).superheated()

  // Synthetic Rubber (heated + fluid + wire)
  event.recipes.create.mixing(
    "kubejs:synthetic_rubber",
    [
      Fluid.of("createdieselgenerators:crude_oil", 250),
      "2x create:pulp",                       // two pulp items
      "createaddition:electrum_wire"
    ]
  ).heated()

  event.recipes.create.mixing(
    "minecraft:diamond",
    [
      "32x minecraft:coal",                      
      "32x minecraft:flint"
    ]
  ).superheated()
})