ServerEvents.recipes(event => {
  // Inductive Mechanism
  event.recipes.create.sequenced_assembly(
    [
      CreateItem.of('kubejs:inductive_mechanism', 0.12),
      CreateItem.of('create:copper_sheet', 0.008),
      CreateItem.of('create:electron_tube', 0.008),
      CreateItem.of('createaddition:copper_wire', 0.008),
      CreateItem.of('create:transmitter', 0.008),
      CreateItem.of('kubejs:andesite_gear', 0.008)
    ],
    'create:copper_sheet',
    [
      event.recipes.create.deploying('kubejs:incomplete_inductive_mechanism', ['kubejs:incomplete_inductive_mechanism', 'kubejs:andesite_gear']),
      event.recipes.create.deploying('kubejs:incomplete_inductive_mechanism', ['kubejs:incomplete_inductive_mechanism', 'create:transmitter']),
      event.recipes.create.deploying('kubejs:incomplete_inductive_mechanism', ['kubejs:incomplete_inductive_mechanism', 'createaddition:copper_wire']),
      event.recipes.create.deploying('kubejs:incomplete_inductive_mechanism', ['kubejs:incomplete_inductive_mechanism', 'create:electron_tube'])
    ]
  )
  .transitionalItem('kubejs:incomplete_inductive_mechanism')
  .loops(5)

  // Andesite Mechanism
  event.recipes.create.sequenced_assembly(
    [
      CreateItem.of('kubejs:andesite_mechanism', 0.12),
      CreateItem.of('kubejs:andesite_sheet', 0.008),
      CreateItem.of('kubejs:copper_gear', 0.016),
      CreateItem.of('createaddition:capacitor', 0.016)
    ],
    'kubejs:andesite_sheet',
    [
      event.recipes.create.deploying('kubejs:incomplete_andesite_mechanism', ['kubejs:incomplete_andesite_mechanism', 'createaddition:capacitor']),
      event.recipes.create.deploying('kubejs:incomplete_andesite_mechanism', ['kubejs:incomplete_andesite_mechanism', 'kubejs:copper_gear']),
      event.recipes.create.deploying('kubejs:incomplete_andesite_mechanism', ['kubejs:incomplete_andesite_mechanism', 'kubejs:copper_gear'])
    ]
  )
  .transitionalItem('kubejs:incomplete_andesite_mechanism')
  .loops(4)

  // Calculation Mechanism
  event.recipes.create.sequenced_assembly(
    [
      CreateItem.of('kubejs:calculation_mechanism', 0.12),
      CreateItem.of('kubejs:copper_gear', 0.016),
      CreateItem.of('kubejs:steel_sheet', 0.008),
      CreateItem.of('createaddition:electrum_spool', 0.016)
    ],
    'kubejs:steel_sheet',
    [
      event.recipes.create.deploying('kubejs:incomplete_calculation_mechanism', ['kubejs:incomplete_calculation_mechanism', 'createaddition:electrum_spool']),
      event.recipes.create.deploying('kubejs:incomplete_calculation_mechanism', ['kubejs:incomplete_calculation_mechanism', 'kubejs:integrated_circuit']),
      event.recipes.create.deploying('kubejs:incomplete_calculation_mechanism', ['kubejs:incomplete_calculation_mechanism', 'kubejs:copper_gear']),
      event.recipes.create.deploying('kubejs:incomplete_calculation_mechanism', ['kubejs:incomplete_calculation_mechanism', 'kubejs:copper_gear'])
    ]
  )
  .transitionalItem('kubejs:incomplete_calculation_mechanism')
  .loops(5)

  // Sealed Mechanism
  event.recipes.create.sequenced_assembly(
    [
      CreateItem.of('kubejs:sealed_mechanism', 0.12),
      CreateItem.of('kubejs:synthetic_rubber_seal', 0.008),
      CreateItem.of('createaddition:electrum_sheet', 0.008),
      CreateItem.of('createaddition:electrum_spool', 0.008),
      CreateItem.of('createaddition:electrum_wire', 0.008),
      CreateItem.of('kubejs:electrum_gear', 0.008)
    ],
    'kubejs:synthetic_rubber',
    [
      event.recipes.create.deploying('kubejs:incomplete_sealed_mechanism', ['kubejs:incomplete_sealed_mechanism', 'kubejs:synthetic_rubber_seal']),
      event.recipes.create.deploying('kubejs:incomplete_sealed_mechanism', ['kubejs:incomplete_sealed_mechanism', 'createaddition:electrum_spool']),
      event.recipes.create.deploying('kubejs:incomplete_sealed_mechanism', ['kubejs:incomplete_sealed_mechanism', 'createaddition:electrum_sheet']),
      event.recipes.create.deploying('kubejs:incomplete_sealed_mechanism', ['kubejs:incomplete_sealed_mechanism', 'createaddition:electrum_wire']),
      event.recipes.create.deploying('kubejs:incomplete_sealed_mechanism', ['kubejs:incomplete_sealed_mechanism', 'kubejs:electrum_gear'])
    ]
  )
  .transitionalItem('kubejs:incomplete_sealed_mechanism')
  .loops(5)

  // Integrated Mechanism
  event.recipes.create.sequenced_assembly(
    [
      CreateItem.of('kubejs:integrated_mechanism', 0.12),
      CreateItem.of('kubejs:polished_spectral_ruby_electron_tube', 0.008),
      CreateItem.of('kubejs:integrated_circuit', 0.016),
      CreateItem.of('kubejs:steel_gear', 0.008),
      CreateItem.of('create:brass_ingot', 0.008)
    ],
    'kubejs:lead_sheet',
    [
      event.recipes.create.deploying('kubejs:incomplete_integrated_mechanism', ['kubejs:incomplete_integrated_mechanism', 'create:brass_ingot']),
      event.recipes.create.deploying('kubejs:incomplete_integrated_mechanism', ['kubejs:incomplete_integrated_mechanism', 'kubejs:polished_spectral_ruby_electron_tube']),
      event.recipes.create.deploying('kubejs:incomplete_integrated_mechanism', ['kubejs:incomplete_integrated_mechanism', 'kubejs:integrated_circuit']),
      event.recipes.create.deploying('kubejs:incomplete_integrated_mechanism', ['kubejs:incomplete_integrated_mechanism', 'kubejs:steel_gear']),
      event.recipes.create.deploying('kubejs:incomplete_integrated_mechanism', ['kubejs:incomplete_integrated_mechanism', 'kubejs:steel_gear'])
    ]
  )
  .transitionalItem('kubejs:incomplete_integrated_mechanism')
  .loops(5)

  // Integrated Circuit
  event.recipes.create.sequenced_assembly(
    [
      CreateItem.of('kubejs:integrated_circuit', 0.12),
      CreateItem.of('kubejs:plastic_sheet', 0.008),
      CreateItem.of('createaddition:electrum_nugget', 0.008),
      CreateItem.of('createaddition:diamond_grit', 0.008),
      CreateItem.of('createaddition:electrum_wire', 0.016)
    ],
    'kubejs:plastic_sheet',
    [
      event.recipes.create.deploying('kubejs:incomplete_integrated_circuit', ['kubejs:incomplete_integrated_circuit', 'createaddition:electrum_nugget']),
      event.recipes.create.deploying('kubejs:incomplete_integrated_circuit', ['kubejs:incomplete_integrated_circuit', 'createaddition:diamond_grit']),
      event.recipes.create.deploying('kubejs:incomplete_integrated_circuit', ['kubejs:incomplete_integrated_circuit', 'createaddition:electrum_wire'])
    ]
  )
  .transitionalItem('kubejs:incomplete_integrated_circuit')
  .loops(5)

})