// kubejs/server_scripts/block_aircraft_northstar.js
// Blocks Immersive Aircraft placement in Create: Northstar dimensions (NeoForge 1.21.1)

BlockEvents.rightClicked(event => {
  // Skip off-hand
  if (event.hand !== 'main_hand') return;

  // Skip non-aircraft items
  if (!event.item.id.startsWith('immersive_aircraft:')) return;

  // Current dimension (e.g. 'create_northstar:moon')
  const dim = event.level.dimension;

  // Block in ALL Northstar dims (covers original + Redux)
  if (dim.startsWith('northstar:') || dim.startsWith('northstar:')) {
    event.cancel();  // Prevents placement
    event.player.tell(Text.red('§cAircraft cannot be placed in Northstar dimensions!'));
  }
});