MoreJS.villagerTrades(event => {
    // Remove all vanilla and modded trades for weaponsmith
    event.removeVanillaTypedTrades("minecraft:weaponsmith");
    event.removeModdedTypedTrades("minecraft:weaponsmith");

    // Level 1 Trades
    // Iron Weapons (2 sprockets for each)
    const ironWeapons = [
        "minecraft:iron_sword",
        "simplyswords:iron_cutlass",
        "simplyswords:iron_rapier",
        "simplyswords:iron_glaive",
        "simplyswords:iron_warglaive",
        "simplyswords:iron_spear",
        "simplyswords:iron_sai",
        "simplyswords:iron_katana",
        "simplyswords:iron_claymore",
        "simplyswords:iron_longsword",
        "simplyswords:iron_twinblade",
        "simplyswords:iron_greathammer",
        "simplyswords:iron_greataxe",
        "simplyswords:iron_chakram",
        "simplyswords:iron_scythe",
        "simplyswords:iron_halberd"
    ];

    ironWeapons.forEach((weapon, index) => {
        event.addTrade("minecraft:weaponsmith", 1, Item.of("numismatics:sprocket", 2), Item.of(weapon, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 16;
                offer.villagerExperience = 10;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // 1 cog for 1 ender_pearl
    event.addTrade("minecraft:weaponsmith", 1, Item.of("numismatics:cog", 1), Item.of("minecraft:ender_pearl", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 3 Trades
    // Diamond Weapons (5 cogs for diamond_sword, 3 sprockets for each simplyswords diamond weapon)
    event.addTrade("minecraft:weaponsmith", 2, Item.of("numismatics:cog", 5), Item.of("minecraft:diamond_sword", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    const diamondWeapons = [
        "simplyswords:diamond_cutlass",
        "simplyswords:diamond_rapier",
        "simplyswords:diamond_glaive",
        "simplyswords:diamond_warglaive",
        "simplyswords:diamond_spear",
        "simplyswords:diamond_sai",
        "simplyswords:diamond_katana",
        "simplyswords:diamond_claymore",
        "simplyswords:diamond_longsword",
        "simplyswords:diamond_twinblade",
        "simplyswords:diamond_greathammer",
        "simplyswords:diamond_greataxe",
        "simplyswords:diamond_chakram",
        "simplyswords:diamond_scythe",
        "simplyswords:diamond_halberd"
    ];

    diamondWeapons.forEach((weapon, index) => {
        event.addTrade("minecraft:weaponsmith", 2, Item.of("numismatics:sprocket", 3), Item.of(weapon, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 8;
                offer.villagerExperience = 80;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // 3 cogs for 1 name_tag
    event.addTrade("minecraft:weaponsmith", 2, Item.of("numismatics:cog", 3), Item.of("minecraft:name_tag", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 4 Trades
    // 1 crown for 1 trident
    event.addTrade("minecraft:weaponsmith", 3, Item.of("numismatics:crown", 1), Item.of("minecraft:trident", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Spawn Eggs
    const level4SpawnEggs = [
        { item: "minecraft:blaze_spawn_egg", cost: 4 },
        { item: "minecraft:slime_spawn_egg", cost: 3 },
        { item: "minecraft:spider_spawn_egg", cost: 3 },
        { item: "minecraft:mooshroom_spawn_egg", cost: 6 },
        { item: "minecraft:breeze_spawn_egg", cost: 6 }
    ];

    level4SpawnEggs.forEach((egg, index) => {
        event.addTrade("minecraft:weaponsmith", 3, Item.of("numismatics:cog", egg.cost), Item.of(egg.item, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 6;
                offer.villagerExperience = 150;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 5 Trades
    // 4 crowns for 1 mace
    event.addTrade("minecraft:weaponsmith", 5, Item.of("numismatics:crown", 3), Item.of("minecraft:mace", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 4;
            offer.villagerExperience = 250;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 2 crowns for 1 netherite_sword
    event.addTrade("minecraft:weaponsmith", 4, Item.of("numismatics:crown", 2), Item.of("minecraft:netherite_sword", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 4;
            offer.villagerExperience = 250;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Netherite Weapons (2 crowns for each)
    const netheriteWeapons = [
        "simplyswords:netherite_cutlass",
        "simplyswords:netherite_rapier",
        "simplyswords:netherite_glaive",
        "simplyswords:netherite_warglaive",
        "simplyswords:netherite_spear",
        "simplyswords:netherite_sai",
        "simplyswords:netherite_katana",
        "simplyswords:netherite_claymore",
        "simplyswords:netherite_longsword",
        "simplyswords:netherite_twinblade",
        "simplyswords:netherite_greathammer",
        "simplyswords:netherite_greataxe",
        "simplyswords:netherite_chakram",
        "simplyswords:netherite_scythe",
        "simplyswords:netherite_halberd"
    ];

    netheriteWeapons.forEach((weapon, index) => {
        event.addTrade("minecraft:weaponsmith", 4, Item.of("numismatics:crown", 2), Item.of(weapon, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 4;
                offer.villagerExperience = 250;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    event.addTrade("minecraft:weaponsmith", 5, Item.of("numismatics:sun", 1), Item.of("simplyswords:chompolotl", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 4;
            offer.villagerExperience = 250;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    event.addTrade("minecraft:weaponsmith", 5, Item.of("numismatics:sun", 1), Item.of("simplyswords:dormant_relic", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 4;
            offer.villagerExperience = 250;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });
});