MoreJS.villagerTrades(event => {
    // Remove all vanilla and modded trades for toolsmith
    event.removeVanillaTypedTrades("minecraft:toolsmith");
    event.removeModdedTypedTrades("minecraft:toolsmith");

    // Level 1 Trades
    // Iron Tools (2 sprockets for each)
    const ironTools = [
        "minecraft:iron_shovel",
        "minecraft:iron_pickaxe",
        "minecraft:iron_hoe",
        "minecraft:iron_axe"
    ];

    ironTools.forEach((tool, index) => {
        event.addTrade("minecraft:toolsmith", 1, Item.of("numismatics:sprocket", 2), Item.of(tool, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 16;
                offer.villagerExperience = 10;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 2 Trades
    // Golden Tools (3 sprockets for each)
    const goldenTools = [
        "minecraft:golden_shovel",
        "minecraft:golden_pickaxe",
        "minecraft:golden_hoe",
        "minecraft:golden_axe"
    ];

    goldenTools.forEach((tool, index) => {
        event.addTrade("minecraft:toolsmith", 2, Item.of("numismatics:sprocket", 3), Item.of(tool, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 12;
                offer.villagerExperience = 60;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 3 Trades
    // 1 cog for 2 lead
    event.addTrade("minecraft:toolsmith", 3, Item.of("numismatics:cog", 1), Item.of("minecraft:lead", 2))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 4 Trades
    // Diamond Tools (5 cogs for each)
    const diamondTools = [
        "minecraft:diamond_shovel",
        "minecraft:diamond_pickaxe",
        "minecraft:diamond_hoe",
        "minecraft:diamond_axe"
    ];

    diamondTools.forEach((tool, index) => {
        event.addTrade("minecraft:toolsmith", 4, Item.of("numismatics:cog", 5), Item.of(tool, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 6;
                offer.villagerExperience = 150;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 5 Trades
    // Netherite Tools (3 crowns for each)
    const netheriteTools = [
        "minecraft:netherite_shovel",
        "minecraft:netherite_pickaxe",
        "minecraft:netherite_hoe",
        "minecraft:netherite_axe"
    ];

    netheriteTools.forEach((tool, index) => {
        event.addTrade("minecraft:toolsmith", 5, Item.of("numismatics:crown", 3), Item.of(tool, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 4;
                offer.villagerExperience = 250;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });
});