MoreJS.villagerTrades(event => {
    // Remove all vanilla and modded trades for leatherworker
    event.removeVanillaTypedTrades("minecraft:leatherworker");
    event.removeModdedTypedTrades("minecraft:leatherworker");

    // Level 1 Trades
    // 2 sprockets for 4 leather
    event.addTrade("minecraft:leatherworker", 1, Item.of("numismatics:sprocket", 2), Item.of("minecraft:leather", 4))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 2 sprockets for 4 rabbit_hide
    event.addTrade("minecraft:leatherworker", 1, Item.of("numismatics:sprocket", 2), Item.of("minecraft:rabbit_hide", 4))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 bevel for 8 rotten_flesh
    event.addTrade("minecraft:leatherworker", 1, Item.of("numismatics:bevel", 1), Item.of("minecraft:rotten_flesh", 8))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 2 Trades
    // 3 sprockets for 1 leather_horse_armor
    event.addTrade("minecraft:leatherworker", 2, Item.of("numismatics:sprocket", 3), Item.of("minecraft:leather_horse_armor", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 cog for 1 saddle
    event.addTrade("minecraft:leatherworker", 2, Item.of("numismatics:cog", 1), Item.of("minecraft:saddle", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 2 sprockets for 8 coal
    event.addTrade("minecraft:leatherworker", 2, Item.of("numismatics:sprocket", 2), Item.of("minecraft:coal", 8))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 3 Trades
    // 2 cogs for 1 golden_horse_armor
    event.addTrade("minecraft:leatherworker", 3, Item.of("numismatics:cog", 2), Item.of("minecraft:golden_horse_armor", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 4 Trades
    // 3 cogs for 1 iron_horse_armor
    event.addTrade("minecraft:leatherworker", 4, Item.of("numismatics:cog", 3), Item.of("minecraft:iron_horse_armor", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 5 Trades
    // 5 cogs for 1 diamond_horse_armor
    event.addTrade("minecraft:leatherworker", 5, Item.of("numismatics:cog", 5), Item.of("minecraft:diamond_horse_armor", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 4;
            offer.villagerExperience = 250;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Spawn Eggs (6 cogs for 1 of each spawn egg)
    const spawnEggs = [
        "minecraft:rabbit_spawn_egg",
        "minecraft:horse_spawn_egg",
        "minecraft:donkey_spawn_egg",
        "minecraft:cow_spawn_egg"
    ];

    spawnEggs.forEach((egg, index) => {
        event.addTrade("minecraft:leatherworker", 5, Item.of("numismatics:cog", 6), Item.of(egg, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 4;
                offer.villagerExperience = 250;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });
});