MoreJS.villagerTrades(event => {
    // Remove all vanilla and modded trades for fletcher
    event.removeVanillaTypedTrades("minecraft:fletcher");
    event.removeModdedTypedTrades("minecraft:fletcher");

    // Level 1, UTID: fletcher_1 - 1 bevel for 4 string
    event.addTrade("minecraft:fletcher", 1, Item.of("numismatics:bevel", 1), Item.of("minecraft:string", 4))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 1, UTID: fletcher_2 - 1 bevel for 4 feather
    event.addTrade("minecraft:fletcher", 1, Item.of("numismatics:bevel", 1), Item.of("minecraft:feather", 4))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 2, UTID: fletcher_3 - 1 bevel for 4 arrow
    event.addTrade("minecraft:fletcher", 2, Item.of("numismatics:bevel", 1), Item.of("minecraft:arrow", 4))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 2, UTID: fletcher_4 - 1 sprocket for 1 bow
    event.addTrade("minecraft:fletcher", 2, Item.of("numismatics:sprocket", 1), Item.of("minecraft:bow", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    event.addTrade("minecraft:fletcher", 3, Item.of("numismatics:sprocket", 1), Item.of("supplementaries:slingshot", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 3, UTID: fletcher_5 - 2 sprockets for 1 crossbow
    event.addTrade("minecraft:fletcher", 4, Item.of("numismatics:sprocket", 2), Item.of("minecraft:crossbow", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 4, UTID: fletcher_6 - 3 sprockets for 4 spectral_arrow
    event.addTrade("minecraft:fletcher", 5, Item.of("numismatics:sprocket", 3), Item.of("minecraft:spectral_arrow", 4))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });
});