MoreJS.villagerTrades(event => {
    // Remove all vanilla and modded trades for fisherman
    event.removeVanillaTypedTrades("minecraft:fisherman");
    event.removeModdedTypedTrades("minecraft:fisherman");

    // Level 1 Trades
    // 1 bevel for 1 fishing_rod
    event.addTrade("minecraft:fisherman", 1, Item.of("numismatics:bevel", 1), Item.of("minecraft:fishing_rod", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 bevel for 4 kelp
    event.addTrade("minecraft:fisherman", 1, Item.of("numismatics:bevel", 1), Item.of("minecraft:kelp", 4))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 bevel for 4 seagrass
    event.addTrade("minecraft:fisherman", 1, Item.of("numismatics:bevel", 1), Item.of("minecraft:seagrass", 4))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 2 Trades
    // 1 sprocket for 2 cod
    event.addTrade("minecraft:fisherman", 2, Item.of("numismatics:sprocket", 1), Item.of("minecraft:cod", 2))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 sprocket for 2 salmon
    event.addTrade("minecraft:fisherman", 2, Item.of("numismatics:sprocket", 1), Item.of("minecraft:salmon", 2))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 sprocket for 2 tropical_fish
    event.addTrade("minecraft:fisherman", 2, Item.of("numismatics:sprocket", 1), Item.of("minecraft:tropical_fish", 2))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 2 sprockets for 3 ink_sac
    event.addTrade("minecraft:fisherman", 2, Item.of("numismatics:sprocket", 2), Item.of("minecraft:ink_sac", 3))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });


    // Level 3 Trades
    // 1 cog for 3 glow_ink_sac
    event.addTrade("minecraft:fisherman", 3, Item.of("numismatics:cog", 1), Item.of("minecraft:glow_ink_sac", 3))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });


    // Level 4 Trades
    // 3 sprockets for 1 guardian
    event.addTrade("minecraft:fisherman", 4, Item.of("numismatics:sprocket", 3), Item.of("oceansdelight:guardian", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 3 sprockets for 4 tentacles
    event.addTrade("minecraft:fisherman", 4, Item.of("numismatics:sprocket", 3), Item.of("oceansdelight:tentacles", 4))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 5 Trades
    // 2 cogs for 1 elder_guardian_slab
    event.addTrade("minecraft:fisherman", 5, Item.of("numismatics:cog", 2), Item.of("oceansdelight:elder_guardian_slab", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 4;
            offer.villagerExperience = 250;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 3 sprockets for 8 sea_pickle
    event.addTrade("minecraft:fisherman", 5, Item.of("numismatics:sprocket", 3), Item.of("minecraft:sea_pickle", 8))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 4;
            offer.villagerExperience = 250;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 cog for 1 turtle_scute
    event.addTrade("minecraft:fisherman", 5, Item.of("numismatics:cog", 1), Item.of("minecraft:turtle_scute", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 4;
            offer.villagerExperience = 250;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Spawn Eggs (6 cogs for 1 of each spawn egg)
    const spawnEggs = [
        "minecraft:dolphin_spawn_egg",
        "minecraft:pufferfish_spawn_egg",
        "minecraft:salmon_spawn_egg",
        "minecraft:guardian_spawn_egg",
        "minecraft:glow_squid_spawn_egg",
        "minecraft:tropical_fish_spawn_egg",
        "minecraft:cod_spawn_egg",
        "minecraft:tadpole_spawn_egg",
        "minecraft:squid_spawn_egg",
        "minecraft:turtle_spawn_egg"
    ];

    spawnEggs.forEach((egg, index) => {
        event.addTrade("minecraft:fisherman", 5, Item.of("numismatics:cog", 6), Item.of(egg, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 4;
                offer.villagerExperience = 250;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });
});