MoreJS.villagerTrades(event => {
    // Remove all vanilla and modded trades for butcher
    event.removeVanillaTypedTrades("minecraft:butcher");
    event.removeModdedTypedTrades("minecraft:butcher");

    // Level 1 Trades
    // 1 bevel for 1 flint_knife
    event.addTrade("minecraft:butcher", 1, Item.of("numismatics:bevel", 1), Item.of("farmersdelight:flint_knife", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 sprocket for 1 porkchop
    event.addTrade("minecraft:butcher", 1, Item.of("numismatics:sprocket", 1), Item.of("minecraft:porkchop", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 sprocket for 1 beef
    event.addTrade("minecraft:butcher", 1, Item.of("numismatics:sprocket", 1), Item.of("minecraft:beef", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 2 Trades
    // 1 sprocket for 1 golden_knife
    event.addTrade("minecraft:butcher", 2, Item.of("numismatics:sprocket", 1), Item.of("farmersdelight:golden_knife", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 sprocket for 1 chicken
    event.addTrade("minecraft:butcher", 2, Item.of("numismatics:sprocket", 1), Item.of("minecraft:chicken", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 3 Trades
    // 1 sprocket for 1 iron_knife
    event.addTrade("minecraft:butcher", 3, Item.of("numismatics:sprocket", 2), Item.of("farmersdelight:iron_knife", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 sprocket for 1 mutton
    event.addTrade("minecraft:butcher", 3, Item.of("numismatics:sprocket", 1), Item.of("minecraft:mutton", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 4 Trades
    // 3 sprockets for 1 diamond_knife
    event.addTrade("minecraft:butcher", 4, Item.of("numismatics:cog", 4), Item.of("farmersdelight:diamond_knife", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 sprocket for 1 rabbit
    event.addTrade("minecraft:butcher", 4, Item.of("numismatics:sprocket", 1), Item.of("minecraft:rabbit", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 5 Trades
    // 1 crown for 1 netherite_knife
    event.addTrade("minecraft:butcher", 5, Item.of("numismatics:crown", 1), Item.of("farmersdelight:netherite_knife", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 4;
            offer.villagerExperience = 250;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 6 cogs for 1 pig_spawn_egg
    event.addTrade("minecraft:butcher", 5, Item.of("numismatics:cog", 6), Item.of("minecraft:pig_spawn_egg", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 4;
            offer.villagerExperience = 250;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });
});