/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.toast.types;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import de.theidler.create_mobile_packages.index.CMPToasts;
import de.theidler.create_mobile_packages.toast.types.SimpleToast;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.item.ItemStack;

public class PackageToast
extends SimpleToast {
    public final List<ItemStack> items;
    private static final AllGuiTextures NUMBERS = AllGuiTextures.NUMBERS;

    public PackageToast(UUID uuid, Component title, Component subtitle, ItemStack icon, List<ItemStack> items, int timeout) {
        super(uuid, title, subtitle, icon, timeout);
        this.items = items;
        this.height = 50;
    }

    public PackageToast(UUID uuid, Component title, Component subtitle, ItemStack icon, List<ItemStack> items) {
        this(uuid, title, subtitle, icon, items, 5000);
    }

    @Override
    protected String getTypeId() {
        return CMPToasts.PACKAGE.id;
    }

    @Override
    protected void writeData(RegistryFriendlyByteBuf buf) {
        super.writeData(buf);
        buf.writeVarInt(this.items.size());
        for (ItemStack item : this.items) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)item);
        }
    }

    public static PackageToast readFromBuffer(RegistryFriendlyByteBuf buf, UUID uuid) {
        Component title = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
        Component subtitle = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
        ItemStack icon = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
        int timeout = buf.readInt();
        int size = buf.readVarInt();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < size; ++i) {
            items.add((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf));
        }
        return new PackageToast(uuid, title, subtitle, icon, items, timeout);
    }

    @Override
    public int draw(GuiGraphics guiGraphics, int x, int y, int toastWidth) {
        int heightWithSpacing = super.draw(guiGraphics, x, y, toastWidth);
        int spacing = toastWidth / this.items.size();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack item = this.items.get(i);
            guiGraphics.renderItem(item, x + i * spacing + 4, y + 30);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            this.drawItemCount(guiGraphics, item.getCount(), x + i * spacing + 4, y + 30);
            guiGraphics.pose().popPose();
        }
        return heightWithSpacing;
    }

    private void drawItemCount(GuiGraphics graphics, int count, int itemX, int itemY) {
        if (count < 1) {
            return;
        }
        String text = String.valueOf(count);
        int x = (int)Math.floor((double)(-text.length()) * 2.5);
        for (char c : text.toCharArray()) {
            int xOffset = (c - 48) * 6;
            RenderSystem.enableBlend();
            graphics.blit(PackageToast.NUMBERS.location, itemX + 14 + x, itemY + 10, 0, (float)(NUMBERS.getStartX() + xOffset), (float)NUMBERS.getStartY(), NUMBERS.getWidth(), NUMBERS.getHeight(), 256, 256);
            x += NUMBERS.getWidth() - 1;
        }
    }
}

