/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.toast;

import de.theidler.create_mobile_packages.toast.Toast;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="create_mobile_packages")
public class ToastOverlayRenderer {
    private static final List<Toast> TOASTS = new ArrayList<Toast>();

    public static void showToast(Toast toast) {
        for (int i = 0; i < TOASTS.size(); ++i) {
            if (!TOASTS.get(i).getId().equals(toast.getId())) continue;
            TOASTS.set(i, toast);
            return;
        }
        TOASTS.add(toast);
    }

    public static void removeToast(UUID uuid) {
        TOASTS.removeIf(t -> t.getId().equals(uuid));
    }

    public static void removeAllToasts() {
        TOASTS.clear();
    }

    @SubscribeEvent
    public static void onRenderGuiPost(RenderGuiEvent.Post event) {
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Minecraft mc = Minecraft.getInstance();
        int toastWidth = 160;
        int x = mc.getWindow().getGuiScaledWidth() - toastWidth - 10;
        int y = 10;
        TOASTS.removeIf(toast -> toast.lastUpdate < System.currentTimeMillis() - (long)toast.timeout);
        for (Toast toast2 : TOASTS) {
            y += toast2.draw(guiGraphics, x, y, toastWidth);
        }
    }
}

