/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.toast;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public abstract class Toast {
    private static final Map<String, BiFunction<RegistryFriendlyByteBuf, UUID, Toast>> REGISTRY = new HashMap<String, BiFunction<RegistryFriendlyByteBuf, UUID, Toast>>();
    public static final StreamCodec<RegistryFriendlyByteBuf, Toast> STREAM_CODEC = StreamCodec.of(Toast::write, Toast::read);
    private final UUID id;
    public final long lastUpdate = System.currentTimeMillis();
    public final int timeout;
    protected int backgroundColor = -1442840576;
    protected int height = 32;

    protected Toast(UUID id, int timeout) {
        this.id = id;
        this.timeout = timeout;
    }

    public UUID getId() {
        return this.id;
    }

    public static void register(String typeId, BiFunction<RegistryFriendlyByteBuf, UUID, Toast> factory) {
        REGISTRY.put(typeId, factory);
    }

    private static Toast read(RegistryFriendlyByteBuf buf) {
        String typeId = buf.readUtf(256);
        UUID uuid = buf.readUUID();
        BiFunction<RegistryFriendlyByteBuf, UUID, Toast> factory = REGISTRY.get(typeId);
        if (factory == null) {
            throw new IllegalStateException("Unknown toast type: " + typeId);
        }
        return factory.apply(buf, uuid);
    }

    private static void write(RegistryFriendlyByteBuf buf, Toast toast) {
        buf.writeUtf(toast.getTypeId());
        buf.writeUUID(toast.getId());
        toast.writeData(buf);
    }

    protected abstract String getTypeId();

    protected abstract void writeData(RegistryFriendlyByteBuf var1);

    public int draw(GuiGraphics guiGraphics, int x, int y, int toastWidth) {
        guiGraphics.fill(x, y, x + toastWidth, y + this.height, this.backgroundColor);
        return this.height + 4;
    }
}

