/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.robo;

import com.mojang.serialization.DynamicOps;
import com.simibubi.create.content.logistics.box.PackageItem;
import de.theidler.create_mobile_packages.CMPHelper;
import de.theidler.create_mobile_packages.blocks.bee_port.BeePortBlockEntity;
import de.theidler.create_mobile_packages.blocks.bee_port.RoboRequest;
import de.theidler.create_mobile_packages.entities.robo_entity.RoboBeeBehaviorController;
import de.theidler.create_mobile_packages.entities.robo_entity.RoboEntity;
import de.theidler.create_mobile_packages.index.CMPEntities;
import de.theidler.create_mobile_packages.index.config.CMPConfigs;
import de.theidler.create_mobile_packages.robo.BeePortBlockEntityTarget;
import de.theidler.create_mobile_packages.robo.PlayerTarget;
import de.theidler.create_mobile_packages.robo.RoboManager;
import de.theidler.create_mobile_packages.robo.RoboTarget;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class VirtualRobo {
    private final UUID id;
    private final UUID logisticsNetworkId;
    private ItemStack itemStack;
    private Vec3 currentPos = Vec3.ZERO;
    private float yaw;
    private float pitch;
    private UUID entityId;
    private int speed;
    private final RoboBeeBehaviorController behaviorController;
    @Nullable
    private RoboTarget target;
    private String targetAddress;
    private Vec3 targetVelocity = Vec3.ZERO;
    private ServerLevel serverLevel;
    private float packageHeightScale;
    private RoboRequest request = null;

    public VirtualRobo(ServerLevel level, UUID id, ItemStack itemStack, BlockPos spawnPos, UUID logisticsNetworkId) {
        this.id = id;
        this.logisticsNetworkId = logisticsNetworkId;
        this.serverLevel = level;
        this.speed = (Integer)CMPConfigs.server().beeSpeed.get();
        this.itemStack = itemStack;
        this.setTargetFromItemStack(itemStack);
        this.currentPos = spawnPos.getCenter().subtract(0.0, 0.5, 0.0);
        this.behaviorController = new RoboBeeBehaviorController();
    }

    public static VirtualRobo deserializeNBT(ServerLevel level, CompoundTag roboTag) {
        UUID id = roboTag.getUUID("id");
        Vec3 pos = CMPHelper.readVec3FromTag(roboTag, "pos");
        int speed = roboTag.getInt("speed");
        UUID logisticsNetworkId = roboTag.getUUID("logisticsNetworkId");
        ItemStack itemStack = ItemStack.EMPTY;
        if (roboTag.contains("itemStack", 10)) {
            itemStack = ItemStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)roboTag.get("itemStack")).result().orElse(ItemStack.EMPTY);
        }
        VirtualRobo virtualRobo = new VirtualRobo(level, id, itemStack, BlockPos.containing((Position)pos), logisticsNetworkId);
        virtualRobo.setSpeed(speed);
        if (!virtualRobo.getItemStack().isEmpty()) {
            virtualRobo.setPackageHeightScale(1.0f);
        }
        return virtualRobo;
    }

    private int getSnapAngle(double angle) {
        return (int)Math.abs(Math.round(angle / 90.0) * 90L - 45L);
    }

    private double getAngleToTarget() {
        Vec3 targetPos = this.getTargetPosition();
        return targetPos != null ? Math.atan2(targetPos.z - this.currentPos.z, targetPos.x - this.currentPos.x()) : 0.0;
    }

    @Nullable
    public Vec3 getTargetPosition() {
        this.updateTarget();
        if (this.target == null) {
            return null;
        }
        return this.target.getTargetPos();
    }

    private void setTargetFromItemStack(ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            this.setTargetAddress(null, false);
        } else {
            this.setTargetAddress(PackageItem.getAddress((ItemStack)itemStack), false);
        }
    }

    private void updateTarget() {
        if (this.target != null && this.target.isValid()) {
            return;
        }
        this.target = PlayerTarget.fromAddress(this.serverLevel, this.targetAddress);
        if (this.target.isValid()) {
            return;
        }
        BeePortBlockEntity targetBlockEntity = CMPHelper.getClosestBeePort((Level)this.serverLevel, this.targetAddress, BlockPos.containing((Position)this.currentPos), this, this.logisticsNetworkId);
        if (targetBlockEntity != null) {
            this.target = new BeePortBlockEntityTarget(targetBlockEntity);
        }
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setTargetVelocity(Vec3 targetVelocity) {
        if (targetVelocity == null) {
            return;
        }
        this.targetVelocity = targetVelocity;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        this.itemStack = itemStack;
    }

    public void tick(ServerLevel level) {
        this.serverLevel = level;
        this.updateEntity();
        this.updateTarget();
        if (this.behaviorController != null) {
            this.behaviorController.tick(this);
        }
        this.move(this.targetVelocity);
        this.updateEta();
        BlockPos pos = BlockPos.containing((Position)this.currentPos);
        if (level.hasChunk(pos.getX() >> 4, pos.getZ() >> 4)) {
            if (this.entityId == null) {
                this.spawnAndRememberEntity();
            }
        } else if (this.entityId != null) {
            this.despawnEntity();
        }
    }

    private void updateEta() {
        if (this.request != null) {
            this.request.setEta(CMPHelper.calcETA(this.getTargetPosition(), this.getCurrentPos()));
        } else if (this.target != null) {
            this.target.setETA(CMPHelper.calcETA(this.getTargetPosition(), this.getCurrentPos()));
        }
    }

    private void move(Vec3 targetVelocity) {
        this.currentPos = this.currentPos.add(targetVelocity);
    }

    private void updateEntity() {
        Entity entity;
        if (this.entityId != null && (entity = this.serverLevel.getEntity(this.entityId)) instanceof RoboEntity) {
            RoboEntity roboEntity = (RoboEntity)entity;
            roboEntity.syncFromVirtual(this);
        } else {
            this.entityId = null;
        }
    }

    public void despawnEntity() {
        Entity entity = this.serverLevel.getEntity(this.entityId);
        if (entity != null) {
            entity.discard();
        }
        this.entityId = null;
    }

    private void spawnAndRememberEntity() {
        RoboEntity entity = new RoboEntity((EntityType<? extends Mob>)((EntityType)CMPEntities.ROBO_BEE_ENTITY.get()), (Level)this.serverLevel, this.id);
        entity.setPos(this.currentPos.x, this.currentPos.y, this.currentPos.z);
        this.serverLevel.addFreshEntity((Entity)entity);
        this.entityId = entity.getUUID();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putUUID("id", this.id);
        CMPHelper.writeVec3ToTag(tag, "pos", this.currentPos);
        tag.putInt("speed", this.speed);
        tag.putUUID("logisticsNetworkId", this.logisticsNetworkId);
        if (!this.getItemStack().isEmpty()) {
            tag.put("itemStack", this.getItemStack().save((HolderLookup.Provider)this.serverLevel.registryAccess(), (Tag)new CompoundTag()));
        }
        return tag;
    }

    private void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getSpeed() {
        return this.speed;
    }

    public Vec3 getCurrentPos() {
        return this.currentPos;
    }

    public UUID getId() {
        return this.id;
    }

    private int rotateToAngle(float targetYaw) {
        float currentYaw = this.yaw;
        float deltaYaw = targetYaw - currentYaw;
        deltaYaw = deltaYaw > 180.0f ? deltaYaw - 360.0f : (deltaYaw < -180.0f ? deltaYaw + 360.0f : deltaYaw);
        float rotationSpeed = ((Integer)CMPConfigs.server().beeRotationSpeed.get()).intValue();
        currentYaw = Math.abs(deltaYaw) > rotationSpeed ? (currentYaw += deltaYaw > 0.0f ? rotationSpeed : -rotationSpeed) : targetYaw;
        this.yaw = currentYaw;
        return (int)Math.ceil(Math.abs(deltaYaw) / rotationSpeed);
    }

    @Nullable
    public RoboTarget getTarget() {
        return this.target;
    }

    public ServerLevel getServerLevel() {
        return this.serverLevel;
    }

    public void setPos(Vec3 pos) {
        this.currentPos = pos;
    }

    public int rotateToSnap() {
        return this.rotateToAngle((float)this.getSnapAngle(this.getAngleToTarget()) + 90.0f);
    }

    @Nullable
    public BeePortBlockEntity getStartBeePortBlockEntity() {
        BlockEntity blockEntity = this.serverLevel.getBlockEntity(BlockPos.containing((Position)this.currentPos));
        if (blockEntity instanceof BeePortBlockEntity) {
            BeePortBlockEntity bpbe = (BeePortBlockEntity)blockEntity;
            return bpbe;
        }
        blockEntity = this.serverLevel.getBlockEntity(BlockPos.containing((Position)this.currentPos.subtract(0.0, 1.0, 0.0)));
        if (blockEntity instanceof BeePortBlockEntity) {
            BeePortBlockEntity bpbe = (BeePortBlockEntity)blockEntity;
            return bpbe;
        }
        blockEntity = this.serverLevel.getBlockEntity(BlockPos.containing((Position)this.currentPos.subtract(0.0, 2.0, 0.0)));
        if (blockEntity instanceof BeePortBlockEntity) {
            BeePortBlockEntity bpbe = (BeePortBlockEntity)blockEntity;
            return bpbe;
        }
        return null;
    }

    public void setRemoved(ServerLevel level) {
        RoboManager.get(level).remove(this.getId());
        if (this.request != null && this.request.getStatus() == RoboRequest.Status.IN_PROGRESS) {
            this.request.setStatus(RoboRequest.Status.PENDING);
        }
        this.despawnEntity();
    }

    public String getTargetAddress() {
        return this.targetAddress;
    }

    public void setTargetAddress(String address, boolean update) {
        this.targetAddress = address;
        if (update) {
            this.updateTarget();
        }
    }

    public float getPackageHeightScale() {
        return this.packageHeightScale;
    }

    public void setPackageHeightScale(float scale) {
        if (scale < 0.0f || scale > 1.0f) {
            return;
        }
        this.packageHeightScale = scale;
    }

    public void setTarget(@Nullable RoboTarget target) {
        this.target = target;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void invalidateTarget() {
        this.targetVelocity = Vec3.ZERO;
        this.target = null;
    }

    public RoboRequest getRequest() {
        return this.request;
    }

    public void setRequest(RoboRequest request) {
        this.request = request;
        this.request.setStatus(RoboRequest.Status.IN_PROGRESS);
        this.target = new BeePortBlockEntityTarget((BeePortBlockEntity)this.serverLevel.getBlockEntity(request.getTargetPos()));
    }
}

