/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.robo;

import de.theidler.create_mobile_packages.blocks.bee_port.BeePortBlockEntity;
import de.theidler.create_mobile_packages.blocks.bee_port.DronePortTracker;
import de.theidler.create_mobile_packages.blocks.bee_port.RoboRequest;
import de.theidler.create_mobile_packages.robo.RoboTarget;
import de.theidler.create_mobile_packages.robo.VirtualRobo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoboManager
extends SavedData {
    public Map<UUID, VirtualRobo> robos;
    public List<RoboRequest> beePortRoboRequests;

    public RoboManager() {
        this.init();
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ListTag robosList = new ListTag();
        for (VirtualRobo robo : this.robos.values()) {
            robosList.add((Object)robo.serializeNBT());
        }
        tag.put("robos", (Tag)robosList);
        return tag;
    }

    public static RoboManager load(CompoundTag tag, ServerLevel level) {
        RoboManager manager = new RoboManager();
        ListTag robosList = tag.getList("robos", 10);
        for (int i = 0; i < robosList.size(); ++i) {
            CompoundTag roboTag = robosList.getCompound(i);
            VirtualRobo robo = VirtualRobo.deserializeNBT(level, roboTag);
            manager.robos.put(robo.getId(), robo);
        }
        return manager;
    }

    public static RoboManager get(ServerLevel level) {
        return (RoboManager)level.getDataStorage().computeIfAbsent(new SavedData.Factory(RoboManager::new, (tag, provider) -> RoboManager.load(tag, level)), "create_mobile_packages_robo_manager");
    }

    @Nullable
    public VirtualRobo get(UUID roboId) {
        return this.robos.get(roboId);
    }

    public void remove(UUID roboId) {
        this.robos.remove(roboId);
        this.setDirty();
    }

    public void add(VirtualRobo robo) {
        this.robos.put(robo.getId(), robo);
        this.setDirty();
    }

    public void tick(ServerLevel level) {
        this.robos.values().forEach(robo -> robo.tick(level));
        this.getPendingRoboRequests().forEach(roboRequest -> this.tryHandlingRequest((RoboRequest)roboRequest, level));
        long now = System.currentTimeMillis();
        this.beePortRoboRequests.removeIf(r -> (r.getStatus() == RoboRequest.Status.DONE || r.getStatus() == RoboRequest.Status.CANCELLED) && now - r.getCreatedAt() > 60000L);
        this.setDirty();
    }

    private void tryHandlingRequest(RoboRequest request, ServerLevel level) {
        DronePortTracker tracker = DronePortTracker.get(level);
        ArrayList<BeePortBlockEntity> allBEs = new ArrayList<BeePortBlockEntity>(tracker.getAllByNetwork(request.getLogisticsNetworkId()));
        allBEs.removeIf(BlockEntity::isRemoved);
        allBEs.removeIf(be -> be.getBlockPos().equals((Object)request.getTargetPos()));
        allBEs.removeIf(be -> be.getRoboBeeInventory().getStackInSlot(0).getCount() <= 0);
        allBEs.stream().min(Comparator.comparingDouble(a -> a.getBlockPos().distSqr((Vec3i)request.getTargetPos()))).ifPresent(target -> target.handleRequest(request));
    }

    public UUID newRobo(ServerLevel level, ItemStack itemStack, BlockPos spawnPos, UUID logisticsNetworkId, float packageHeightScale) {
        UUID id = UUID.randomUUID();
        VirtualRobo robo = new VirtualRobo(level, id, itemStack, spawnPos, logisticsNetworkId);
        robo.setPackageHeightScale(packageHeightScale);
        this.add(robo);
        this.setDirty();
        return id;
    }

    public void newRequestRobo(ServerLevel level, BlockPos spawnPos, RoboRequest request) {
        UUID id = UUID.randomUUID();
        VirtualRobo robo = new VirtualRobo(level, id, ItemStack.EMPTY, spawnPos, request.getLogisticsNetworkId());
        robo.setRequest(request);
        this.add(robo);
        this.setDirty();
    }

    public synchronized void requestRobo(BlockPos pos, UUID logisticsNetworkId) {
        this.beePortRoboRequests.add(new RoboRequest(pos, logisticsNetworkId));
    }

    public List<RoboRequest> getRoboRequestsWithStatus(RoboRequest.Status status) {
        return this.beePortRoboRequests.stream().filter(request -> request.getStatus() == status).toList();
    }

    public List<RoboRequest> getPendingRoboRequests() {
        return this.getRoboRequestsWithStatus(RoboRequest.Status.PENDING);
    }

    public List<RoboRequest> getRoboRequests(BlockPos pos) {
        return this.beePortRoboRequests.stream().filter(request -> request.getTargetPos().equals((Object)pos)).toList();
    }

    public List<VirtualRobo> getInboundRobo(BlockPos pos) {
        ArrayList<VirtualRobo> inboundRobos = new ArrayList<VirtualRobo>();
        for (VirtualRobo robo : this.robos.values()) {
            RoboTarget target = robo.getTarget();
            if (target == null || target.getTargetPos() == null || !BlockPos.containing((Position)target.getTargetPos()).equals((Object)pos)) continue;
            inboundRobos.add(robo);
        }
        return inboundRobos;
    }

    public List<Integer> getETAs(BlockPos pos) {
        ArrayList eta = new ArrayList();
        this.getRoboRequests(pos).stream().map(RoboRequest::getEta).forEach(eta::add);
        this.getInboundRobo(pos).stream().map(robo -> {
            RoboTarget target = robo.getTarget();
            if (target != null) {
                return target.getETA();
            }
            return -1;
        }).forEach(eta::add);
        return eta.stream().filter(integer -> integer >= 0).toList();
    }

    private void init() {
        this.robos = new ConcurrentHashMap<UUID, VirtualRobo>();
        this.beePortRoboRequests = new CopyOnWriteArrayList<RoboRequest>();
    }
}

