/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.robo;

import com.simibubi.create.content.logistics.box.PackageItem;
import de.theidler.create_mobile_packages.CMPHelper;
import de.theidler.create_mobile_packages.index.CMPItems;
import de.theidler.create_mobile_packages.robo.RoboTarget;
import de.theidler.create_mobile_packages.robo.VirtualRobo;
import de.theidler.create_mobile_packages.toast.ShowToastOnClientPacket;
import de.theidler.create_mobile_packages.toast.types.PackageToast;
import java.util.ArrayList;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class PlayerTarget
implements RoboTarget {
    private final Player player;
    private int eta;

    public PlayerTarget(Player player) {
        this.player = player;
    }

    public static PlayerTarget fromAddress(ServerLevel level, String address) {
        ServerPlayer player = level.getPlayers(p -> CMPHelper.doesAddressMatchPlayer((Player)p, address)).stream().findFirst().orElse(null);
        return new PlayerTarget((Player)player);
    }

    @Override
    @Nullable
    public Vec3 getTargetPos() {
        if (this.player == null) {
            return null;
        }
        return this.player.position();
    }

    @Override
    public Player asPlayer() {
        return this.player;
    }

    @Override
    public boolean isValid() {
        return this.player != null && this.player.isAlive();
    }

    public void updateEtaToast(VirtualRobo robo) {
        ItemStack packageItem = robo.getItemStack();
        ItemStackHandler itemHandler = packageItem.isEmpty() ? new ItemStackHandler(9) : PackageItem.getContents((ItemStack)packageItem);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            items.add(itemHandler.getStackInSlot(i));
        }
        PackageToast toast = new PackageToast(robo.getId(), (Component)Component.translatable((String)"create_mobile_packages.toast.robo_bee_on_the_way"), (Component)Component.translatable((String)"create_mobile_packages.toast.eta", (Object[])new Object[]{this.getETA()}), CMPItems.ROBO_BEE.asStack(), items);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CatnipServices.NETWORK.sendToClient(serverPlayer, (CustomPacketPayload)new ShowToastOnClientPacket(toast));
        }
    }

    @Override
    public int getETA() {
        return this.eta;
    }

    @Override
    public void setETA(int eta) {
        this.eta = eta;
    }
}

