/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.robo;

import de.theidler.create_mobile_packages.blocks.bee_port.BeePortBlockEntity;
import de.theidler.create_mobile_packages.robo.RoboTarget;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class BeePortBlockEntityTarget
implements RoboTarget {
    private final BlockPos pos;
    private final ServerLevel level;
    private int eta;

    public BeePortBlockEntityTarget(BeePortBlockEntity be) {
        this.pos = be.getBlockPos();
        this.level = be.getLevel() instanceof ServerLevel ? (ServerLevel)be.getLevel() : null;
    }

    @Override
    public Vec3 getTargetPos() {
        return Vec3.atCenterOf((Vec3i)this.pos);
    }

    @Override
    public BeePortBlockEntity asBeePortBlockEntity() {
        if (this.level == null) {
            return null;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (blockEntity instanceof BeePortBlockEntity) {
            BeePortBlockEntity be = (BeePortBlockEntity)blockEntity;
            return be;
        }
        return null;
    }

    @Override
    public boolean isValid() {
        BeePortBlockEntity be = this.asBeePortBlockEntity();
        return be != null && !be.isRemoved() && !be.isFull();
    }

    @Override
    public int getETA() {
        return this.eta;
    }

    @Override
    public void setETA(int eta) {
        this.eta = eta;
    }
}

