/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.portable_stock_ticker;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.AddressEditBox;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelScreen;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.logistics.stockTicker.CraftableBigItemStack;
import com.simibubi.create.content.logistics.stockTicker.PackageOrder;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import de.theidler.create_mobile_packages.compat.Mods;
import de.theidler.create_mobile_packages.compat.jei.CMPJEI;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.ClientScreenStorage;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.HiddenCategoriesPacket;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.PortableStockTicker;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.PortableStockTickerMenu;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.SendPackage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.TextureSheetSegment;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import ru.zznty.create_factory_abstractions.api.generic.crafting.OrderProvider;
import ru.zznty.create_factory_abstractions.api.generic.crafting.RecipeRequestHelper;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKey;
import ru.zznty.create_factory_abstractions.api.generic.search.CategoriesProvider;
import ru.zznty.create_factory_abstractions.api.generic.search.GenericSearch;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.impl.GenericContentExtender;
import ru.zznty.create_factory_abstractions.generic.support.BigGenericStack;
import ru.zznty.create_factory_abstractions.generic.support.CraftableGenericStack;
import ru.zznty.create_factory_abstractions.generic.support.GenericInventorySummary;
import ru.zznty.create_factory_abstractions.generic.support.GenericOrder;

public class PortableStockTickerScreen
extends AbstractSimiContainerScreen<PortableStockTickerMenu>
implements OrderProvider,
CategoriesProvider {
    private static final AllGuiTextures HEADER = AllGuiTextures.STOCK_KEEPER_REQUEST_HEADER;
    private static final AllGuiTextures BODY = AllGuiTextures.STOCK_KEEPER_REQUEST_BODY;
    private static final AllGuiTextures FOOTER = AllGuiTextures.STOCK_KEEPER_REQUEST_FOOTER;
    public LerpedFloat itemScroll;
    final int cols = 9;
    final int rowHeight = 20;
    final int colWidth = 20;
    final Couple<Integer> noneHovered = Couple.create((Object)-1, (Object)-1);
    int itemsX;
    int itemsY;
    int orderY;
    int windowWidth;
    int windowHeight;
    public EditBox searchBox;
    public AddressEditBox addressBox;
    int emptyTicks = 0;
    int successTicks = 0;
    Inventory playerInventory;
    public List<List<BigGenericStack>> currentItemSource;
    public List<List<BigGenericStack>> displayedItems = new ArrayList<List<BigGenericStack>>();
    public List<GenericSearch.CategoryEntry> categories;
    public List<BigGenericStack> itemsToOrder = new ArrayList<BigGenericStack>();
    public List<CraftableGenericStack> recipesToOrder = new ArrayList<CraftableGenericStack>();
    private boolean scrollHandleActive;
    private GenericInventorySummary forcedEntries;
    private final Set<Integer> hiddenCategories;
    public boolean refreshSearchNextTick;
    public boolean moveToTopNextTick;

    public PortableStockTickerScreen(PortableStockTickerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.categories = new ArrayList<GenericSearch.CategoryEntry>();
        this.itemScroll = LerpedFloat.linear().startWithValue(0.0);
        menu.screenReference = this;
        this.forcedEntries = GenericInventorySummary.empty();
        this.playerInventory = playerInventory;
        this.hiddenCategories = new HashSet<Integer>(menu.portableStockTicker.hiddenCategoriesByPlayer.getOrDefault(menu.player.getUUID(), List.of()));
    }

    protected void containerTick() {
        boolean allEmpty;
        super.containerTick();
        this.addressBox.tick();
        ClientScreenStorage.tick();
        if (this.forcedEntries != null && !this.forcedEntries.isEmpty()) {
            GenericInventorySummary summary = GenericInventorySummary.empty();
            for (List<BigGenericStack> stackList : this.displayedItems) {
                for (BigGenericStack stack : stackList) {
                    summary.add(stack.get());
                }
            }
            for (GenericStack stack : this.forcedEntries.get()) {
                int limitedAmount = -stack.amount() - 1;
                int actualAmount = summary.getCountOf(stack.key());
                if (actualAmount > limitedAmount) continue;
                this.forcedEntries.erase(stack.key());
            }
        }
        this.emptyTicks = (allEmpty = this.displayedItems.isEmpty()) ? ++this.emptyTicks : 0;
        this.successTicks = this.successTicks > 0 && this.itemsToOrder.isEmpty() ? ++this.successTicks : 0;
        List<List<BigGenericStack>> clientStockSnapshot = this.convertToCategoryList(this.sortByCount(ClientScreenStorage.stacks));
        if (clientStockSnapshot != this.currentItemSource) {
            this.currentItemSource = clientStockSnapshot;
            this.refreshSearchResults(false);
        }
        if (this.refreshSearchNextTick) {
            this.refreshSearchNextTick = false;
            this.refreshSearchResults(this.moveToTopNextTick);
        }
        this.itemScroll.tickChaser();
        if (Math.abs(this.itemScroll.getValue() - this.itemScroll.getChaseTarget()) < 0.0625f) {
            this.itemScroll.setValue((double)this.itemScroll.getChaseTarget());
        }
    }

    private List<GenericStack> sortByCount(List<GenericStack> stacks) {
        stacks.sort(Comparator.comparingInt(bigStack -> -bigStack.amount()));
        return stacks;
    }

    private List<List<BigGenericStack>> convertToCategoryList(List<GenericStack> stacks) {
        ArrayList<GenericStack> stacksCopy = new ArrayList<GenericStack>(stacks);
        ArrayList<List<BigGenericStack>> output = new ArrayList<List<BigGenericStack>>();
        for (ItemStack filter : ((PortableStockTickerMenu)this.menu).portableStockTicker.categories) {
            ArrayList<BigGenericStack> inCategory = new ArrayList<BigGenericStack>();
            if (!filter.isEmpty()) {
                FilterItemStack filterItemStack = FilterItemStack.of((ItemStack)filter);
                Iterator iterator = stacksCopy.iterator();
                while (iterator.hasNext()) {
                    BigGenericStack bigStack = BigGenericStack.of((GenericStack)((GenericStack)iterator.next()));
                    if (!filterItemStack.test(this.playerInventory.player.level(), bigStack.asStack().stack)) continue;
                    inCategory.add(bigStack);
                    iterator.remove();
                }
            }
            output.add(inCategory);
        }
        ArrayList<BigGenericStack> unsorted = new ArrayList<BigGenericStack>(stacksCopy.size());
        for (GenericStack stack : stacksCopy) {
            unsorted.add(BigGenericStack.of((GenericStack)stack));
        }
        output.add(unsorted);
        return output;
    }

    private void refreshSearchResults(boolean scrollBackUp) {
        if (scrollBackUp) {
            this.itemScroll.startWithValue(0.0);
        }
        GenericSearch.SearchResult result = GenericSearch.search((CategoriesProvider)this, (String)this.searchBox.getValue(), (int)20, (int)9);
        this.categories = result.categories();
        this.displayedItems = result.displayedItems();
        this.updateCraftableAmounts();
    }

    protected void init() {
        int appropriateHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight() - 10;
        appropriateHeight -= Mth.positiveModulo((int)(appropriateHeight - HEADER.getHeight() - FOOTER.getHeight()), (int)BODY.getHeight());
        appropriateHeight = Math.min(appropriateHeight, HEADER.getHeight() + FOOTER.getHeight() + BODY.getHeight() * 17);
        this.windowWidth = 226;
        this.windowHeight = appropriateHeight;
        this.setWindowSize(226, this.windowHeight);
        super.init();
        this.clearWidgets();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.itemsX = x + (this.windowWidth - 180) / 2 + 1;
        this.itemsY = y + 33;
        this.orderY = y + this.windowHeight - 72;
        MutableComponent searchLabel = CreateLang.translateDirect((String)"gui.stock_keeper.search_items", (Object[])new Object[0]);
        this.searchBox = new EditBox((Font)new NoShadowFontWrapper(this.font), x + 71, y + 22, 100, 9, (Component)searchLabel);
        this.searchBox.setMaxLength(50);
        this.searchBox.setBordered(false);
        this.searchBox.setTextColor(4861233);
        this.addWidget((GuiEventListener)this.searchBox);
        boolean initial = this.addressBox == null;
        String previouslyUsedAddress = initial ? ((PortableStockTickerMenu)this.menu).portableStockTicker.previouslyUsedAddress : this.addressBox.getValue();
        this.addressBox = new AddressEditBox((Screen)this, (Font)new NoShadowFontWrapper(this.font), x + 27, y + this.windowHeight - 36, 92, 10, true, "@" + this.playerInventory.player.getName().getString());
        this.addressBox.setTextColor(7424576);
        this.addressBox.setValue(previouslyUsedAddress);
        this.addRenderableWidget((GuiEventListener)this.addressBox);
        ClientScreenStorage.manualUpdate();
        if (initial) {
            this.playUiSound(SoundEvents.WOOD_HIT, 0.5f, 1.5f);
            this.playUiSound(SoundEvents.BOOK_PAGE_TURN, 1.0f, 1.0f);
            this.syncJEI();
        }
    }

    private Couple<Integer> getHoveredSlot(int x, int y) {
        if (++x < this.itemsX || x >= this.itemsX + 180) {
            return this.noneHovered;
        }
        if (y >= this.orderY && y < this.orderY + 20) {
            int col = (x - this.itemsX) / 20;
            if (this.itemsToOrder.size() <= col || col < 0) {
                return this.noneHovered;
            }
            return Couple.create((Object)-1, (Object)col);
        }
        if (y >= this.orderY - 31 && y < this.orderY - 31 + 20) {
            int jeiX = this.getGuiLeft() + (this.windowWidth - 20 * this.recipesToOrder.size()) / 2 + 1;
            int col = Mth.floorDiv((int)(x - jeiX), (int)20);
            if (this.recipesToOrder.size() > col && col >= 0) {
                return Couple.create((Object)-2, (Object)col);
            }
        }
        if (y < this.getGuiTop() + 16 || y > this.getGuiTop() + this.windowHeight - 80) {
            return this.noneHovered;
        }
        if (!this.itemScroll.settled()) {
            return this.noneHovered;
        }
        int localY = y - this.itemsY;
        for (int categoryIndex = 0; categoryIndex < this.displayedItems.size(); ++categoryIndex) {
            int col;
            GenericSearch.CategoryEntry entry;
            GenericSearch.CategoryEntry categoryEntry = entry = this.categories.isEmpty() ? new GenericSearch.CategoryEntry(0, "", new MutableInt(), new MutableBoolean()) : this.categories.get(categoryIndex);
            if (entry.hidden().isTrue()) continue;
            int row = Mth.floor((float)((float)(localY - (this.categories.isEmpty() ? 4 : 20) - entry.y().intValue()) / 20.0f + this.itemScroll.getChaseTarget()));
            int slot = row * 9 + (col = (x - this.itemsX) / 20);
            if (slot < 0) {
                return this.noneHovered;
            }
            if (this.displayedItems.get(categoryIndex).size() <= slot) continue;
            return Couple.create((Object)categoryIndex, (Object)slot);
        }
        return this.noneHovered;
    }

    protected void renderBg(@NotNull GuiGraphics pGuiGraphics, float partialTicks, int mouseX, int mouseY) {
        boolean allEmpty;
        boolean justSent;
        PortableStockTicker pst;
        if (this.minecraft != null && this != this.minecraft.screen) {
            return;
        }
        PoseStack ms = pGuiGraphics.pose();
        float currentScroll = this.itemScroll.getValue(partialTicks);
        Couple<Integer> hoveredSlot = this.getHoveredSlot(mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        HEADER.render(pGuiGraphics, x - 15, y);
        y += HEADER.getHeight();
        for (int i = 0; i < (this.windowHeight - HEADER.getHeight() - FOOTER.getHeight()) / BODY.getHeight(); ++i) {
            BODY.render(pGuiGraphics, x - 15, y);
            y += BODY.getHeight();
        }
        FOOTER.render(pGuiGraphics, x - 15, y);
        y = this.getGuiTop();
        if (this.addressBox.getValue().isBlank() && !this.addressBox.isFocused()) {
            pGuiGraphics.drawString(Minecraft.getInstance().font, (Component)CreateLang.translate((String)"gui.stock_keeper.package_adress", (Object[])new Object[0]).style(ChatFormatting.ITALIC).component(), this.addressBox.getX(), this.addressBox.getY(), -3294040, false);
        }
        ms.pushPose();
        ms.translate((float)(x - 50), (float)(y + this.windowHeight - 70), -100.0f);
        ms.scale(3.5f, 3.5f, 3.5f);
        ItemStack pstStack = PortableStockTicker.find(this.playerInventory);
        PortableStockTicker portableStockTicker = pst = pstStack != null ? (PortableStockTicker)pstStack.getItem() : null;
        if (pst != null) {
            GuiGameElement.of((ItemLike)pst).render(pGuiGraphics);
        }
        ms.popPose();
        for (int index = 0; index < 9 && this.itemsToOrder.size() > index; ++index) {
            BigGenericStack entry = this.itemsToOrder.get(index);
            boolean isStackHovered = index == (Integer)hoveredSlot.getSecond() && (Integer)hoveredSlot.getFirst() == -1;
            ms.pushPose();
            ms.translate((float)(this.itemsX + index * 20), (float)this.orderY, 0.0f);
            this.renderItemEntry(pGuiGraphics, 1.0f, entry, isStackHovered, true);
            ms.popPose();
        }
        if (this.itemsToOrder.size() > 9) {
            pGuiGraphics.drawString(this.font, (Component)Component.literal((String)("[+" + (this.itemsToOrder.size() - 9) + "]")), x + this.windowWidth - 40, this.orderY + 21, 16316652);
        }
        boolean bl = justSent = this.itemsToOrder.isEmpty() && this.successTicks > 0;
        if (this.isConfirmHovered(mouseX, mouseY) && !justSent) {
            AllGuiTextures.STOCK_KEEPER_REQUEST_SEND_HOVER.render(pGuiGraphics, x + this.windowWidth - 81, y + this.windowHeight - 41);
        }
        MutableComponent headerTitle = Component.translatable((String)"item.create_mobile_packages.portable_stock_ticker.screen_title");
        pGuiGraphics.drawString(this.font, (Component)headerTitle, x + this.windowWidth / 2 - this.font.width((FormattedText)headerTitle) / 2, y + 4, 7424576, false);
        MutableComponent component = CreateLang.translate((String)"gui.stock_keeper.send", (Object[])new Object[0]).component();
        if (justSent) {
            float alpha = Mth.clamp((float)(((float)this.successTicks + partialTicks - 5.0f) / 5.0f), (float)0.0f, (float)1.0f);
            ms.pushPose();
            ms.translate(alpha * alpha * 50.0f, 0.0f, 0.0f);
            if (this.successTicks < 10) {
                pGuiGraphics.drawString(this.font, (Component)component, x + this.windowWidth - 42 - this.font.width((FormattedText)component) / 2, y + this.windowHeight - 35, new Color(0x252525).setAlpha(1.0f - alpha * alpha).getRGB(), false);
            }
            ms.popPose();
        } else {
            pGuiGraphics.drawString(this.font, (Component)component, x + this.windowWidth - 42 - this.font.width((FormattedText)component) / 2, y + this.windowHeight - 35, 0x252525, false);
        }
        if (justSent) {
            MutableComponent msg = CreateLang.translateDirect((String)"gui.stock_keeper.request_sent", (Object[])new Object[0]);
            float alpha = Mth.clamp((float)(((float)this.successTicks + partialTicks - 10.0f) / 5.0f), (float)0.0f, (float)1.0f);
            int msgX = x + this.windowWidth / 2 - (this.font.width((FormattedText)msg) + 10) / 2;
            int msgY = this.orderY + 5;
            if (alpha > 0.0f) {
                int c3 = new Color(9198923).setAlpha(alpha).getRGB();
                int w = this.font.width((FormattedText)msg) + 14;
                AllGuiTextures.STOCK_KEEPER_REQUEST_BANNER_L.render(pGuiGraphics, msgX - 8, msgY - 4);
                UIRenderHelper.drawStretched((GuiGraphics)pGuiGraphics, (int)msgX, (int)(msgY - 4), (int)w, (int)16, (int)0, (TextureSheetSegment)AllGuiTextures.STOCK_KEEPER_REQUEST_BANNER_M);
                AllGuiTextures.STOCK_KEEPER_REQUEST_BANNER_R.render(pGuiGraphics, msgX + this.font.width((FormattedText)msg) + 10, msgY - 4);
                pGuiGraphics.drawString(this.font, (Component)msg, msgX + 5, msgY, c3, false);
            }
        }
        int itemWindowX = x + 21;
        int itemWindowX2 = itemWindowX + 184;
        int itemWindowY = y + 17;
        int itemWindowY2 = y + this.windowHeight - 80;
        pGuiGraphics.enableScissor(itemWindowX - 5, itemWindowY, itemWindowX2 + 10, itemWindowY2);
        ms.pushPose();
        ms.translate(0.0f, -currentScroll * 20.0f, 0.0f);
        for (int sliceY = -2; sliceY < this.getMaxScroll() * 20 + this.windowHeight - 72; sliceY += AllGuiTextures.STOCK_KEEPER_REQUEST_BG.getHeight()) {
            if ((float)sliceY - currentScroll * 20.0f < -20.0f || (float)sliceY - currentScroll * 20.0f > (float)(this.windowHeight - 72)) continue;
            AllGuiTextures.STOCK_KEEPER_REQUEST_BG.render(pGuiGraphics, x + 22, y + sliceY + 18);
        }
        AllGuiTextures.STOCK_KEEPER_REQUEST_SEARCH.render(pGuiGraphics, x + 42, this.searchBox.getY() - 5);
        this.searchBox.render(pGuiGraphics, mouseX, mouseY, partialTicks);
        if (this.searchBox.getValue().isBlank() && !this.searchBox.isFocused()) {
            pGuiGraphics.drawString(this.font, this.searchBox.getMessage(), x + this.windowWidth / 2 - this.font.width((FormattedText)this.searchBox.getMessage()) / 2, this.searchBox.getY(), -11915983, false);
        }
        if (allEmpty = this.displayedItems.isEmpty()) {
            Component msg = this.getTroubleshootingMessage();
            float alpha = Mth.clamp((float)(((float)this.emptyTicks - 10.0f) / 5.0f), (float)0.0f, (float)1.0f);
            if (alpha > 0.0f) {
                List split = this.font.split((FormattedText)msg, 160);
                for (int i = 0; i < split.size(); ++i) {
                    FormattedCharSequence sequence = (FormattedCharSequence)split.get(i);
                    int lineWidth = this.font.width(sequence);
                    int n = x + this.windowWidth / 2 - lineWidth / 2 + 1;
                    Objects.requireNonNull(this.font);
                    pGuiGraphics.drawString(this.font, sequence, n, this.itemsY + 20 + 1 + i * (9 + 1), new Color(4861233).setAlpha(alpha).getRGB(), false);
                    int n2 = x + this.windowWidth / 2 - lineWidth / 2;
                    Objects.requireNonNull(this.font);
                    pGuiGraphics.drawString(this.font, sequence, n2, this.itemsY + 20 + i * (9 + 1), new Color(16316652).setAlpha(alpha).getRGB(), false);
                }
            }
        }
        block4: for (int categoryIndex = 0; categoryIndex < this.displayedItems.size(); ++categoryIndex) {
            int categoryY;
            List<BigGenericStack> category = this.displayedItems.get(categoryIndex);
            GenericSearch.CategoryEntry categoryEntry = this.categories.isEmpty() ? null : this.categories.get(categoryIndex);
            int n = categoryY = this.categories.isEmpty() ? 0 : categoryEntry.y().intValue();
            if (category.isEmpty()) continue;
            if (!this.categories.isEmpty()) {
                (categoryEntry.hidden().isTrue() ? AllGuiTextures.STOCK_KEEPER_CATEGORY_HIDDEN : AllGuiTextures.STOCK_KEEPER_CATEGORY_SHOWN).render(pGuiGraphics, this.itemsX, this.itemsY + categoryY + 6);
                pGuiGraphics.drawString(this.font, categoryEntry.name(), this.itemsX + 10, this.itemsY + categoryY + 8, 4861233, false);
                pGuiGraphics.drawString(this.font, categoryEntry.name(), this.itemsX + 9, this.itemsY + categoryY + 7, 16316652, false);
                if (categoryEntry.hidden().isTrue()) continue;
            }
            for (int index = 0; index < category.size(); ++index) {
                int pY = this.itemsY + categoryY + (this.categories.isEmpty() ? 4 : 20) + index / 9 * 20;
                float cullY = (float)pY - currentScroll * 20.0f;
                if (cullY < (float)y) continue;
                if (cullY > (float)(y + this.windowHeight - 72)) continue block4;
                boolean isStackHovered = index == (Integer)hoveredSlot.getSecond() && categoryIndex == (Integer)hoveredSlot.getFirst();
                BigGenericStack entry = category.get(index);
                ms.pushPose();
                ms.translate((float)(this.itemsX + index % 9 * 20), (float)pY, 0.0f);
                this.renderItemEntry(pGuiGraphics, 1.0f, entry, isStackHovered, false);
                ms.popPose();
            }
        }
        ms.popPose();
        pGuiGraphics.disableScissor();
        int windowH = this.windowHeight - 92;
        int totalH = this.getMaxScroll() * 20 + windowH;
        int barSize = Math.max(5, Mth.floor((float)((float)windowH / (float)totalH * (float)(windowH - 2))));
        if (barSize < windowH - 2) {
            int barX = this.itemsX + 180;
            int barY = y + 15;
            ms.pushPose();
            ms.translate(0.0f, currentScroll * 20.0f / (float)totalH * (float)(windowH - 2), 0.0f);
            AllGuiTextures pad = AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_PAD;
            pGuiGraphics.blit(pad.location, barX, barY, pad.getWidth(), barSize, (float)pad.getStartX(), (float)pad.getStartY(), pad.getWidth(), pad.getHeight(), 256, 256);
            AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_TOP.render(pGuiGraphics, barX, barY);
            if (barSize > 16) {
                AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_MID.render(pGuiGraphics, barX, barY + barSize / 2 - 4);
            }
            AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_BOT.render(pGuiGraphics, barX, barY + barSize - 5);
            ms.popPose();
        }
        if (!this.recipesToOrder.isEmpty()) {
            int jeiX = x + (this.windowWidth - 20 * this.recipesToOrder.size()) / 2 + 1;
            int jeiY = this.orderY - 31;
            ms.pushPose();
            ms.translate((float)jeiX, (float)jeiY, 200.0f);
            int xoffset = -3;
            AllGuiTextures.STOCK_KEEPER_REQUEST_BLUEPRINT_LEFT.render(pGuiGraphics, xoffset, -3);
            xoffset += 10;
            for (int i = 0; i <= (this.recipesToOrder.size() - 1) * 5; ++i) {
                AllGuiTextures.STOCK_KEEPER_REQUEST_BLUEPRINT_MIDDLE.render(pGuiGraphics, xoffset, -3);
                xoffset += 4;
            }
            AllGuiTextures.STOCK_KEEPER_REQUEST_BLUEPRINT_RIGHT.render(pGuiGraphics, xoffset, -3);
            for (int index = 0; index < this.recipesToOrder.size(); ++index) {
                CraftableGenericStack craftableBigItemStack = this.recipesToOrder.get(index);
                boolean isStackHovered = index == (Integer)hoveredSlot.getSecond() && -2 == (Integer)hoveredSlot.getFirst();
                ms.pushPose();
                ms.translate((float)(index * 20), 0.0f, 0.0f);
                this.renderItemEntry(pGuiGraphics, 1.0f, (BigGenericStack)craftableBigItemStack, isStackHovered, true);
                ms.popPose();
            }
            ms.popPose();
        }
    }

    private int getMaxScroll() {
        int visibleHeight = this.windowHeight - 84;
        int totalRows = 2;
        for (int i = 0; i < this.displayedItems.size(); ++i) {
            List<BigGenericStack> list = this.displayedItems.get(i);
            if (list.isEmpty()) continue;
            ++totalRows;
            if (this.categories.size() > i && this.categories.get(i).hidden().isTrue()) continue;
            totalRows += (int)Math.ceil((float)list.size() / 9.0f);
        }
        return Math.max(0, (totalRows * 20 - visibleHeight + 50) / 20);
    }

    private void renderItemEntry(GuiGraphics graphics, float scale, BigGenericStack entry, boolean isStackHovered, boolean isRenderingOrders) {
        int customCount = entry.get().amount();
        if (!isRenderingOrders) {
            BigGenericStack order = this.orderForStack(entry.get());
            if (entry.get().amount() < 1000000000) {
                int forcedCount = this.forcedEntries.getCountOf(entry.get().key());
                if (forcedCount != 0) {
                    customCount = Math.min(customCount, -forcedCount - 1);
                }
                if (order != null) {
                    customCount -= order.get().amount();
                }
                customCount = Math.max(0, customCount);
            }
            AllGuiTextures.STOCK_KEEPER_REQUEST_SLOT.render(graphics, 0, 0);
        }
        boolean craftable = entry instanceof CraftableBigItemStack;
        PoseStack ms = graphics.pose();
        ms.pushPose();
        float scaleFromHover = 1.0f;
        if (isStackHovered) {
            scaleFromHover += 0.075f;
        }
        ms.translate(1.0, 1.0, 0.0);
        ms.translate(9.0, 9.0, 0.0);
        ms.scale(scale, scale, scale);
        ms.scale(scaleFromHover, scaleFromHover, scaleFromHover);
        ms.translate(-9.0, -9.0, 0.0);
        if (customCount != 0 || craftable) {
            GenericContentExtender.registrationOf((GenericKey)entry.get().key()).clientProvider().guiHandler().renderSlot(graphics, entry.get().key(), 0, 0);
        }
        ms.popPose();
        ms.pushPose();
        ms.translate(0.0f, 0.0f, 200.0f);
        if (customCount != 0 || craftable) {
            GenericContentExtender.registrationOf((GenericKey)entry.get().key()).clientProvider().guiHandler().renderDecorations(graphics, entry.get().key(), customCount, 1, 1);
        }
        ms.popPose();
    }

    protected void renderForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
        Couple<Integer> hoveredSlot = this.getHoveredSlot(mouseX, mouseY);
        if (hoveredSlot != this.noneHovered) {
            boolean orderHovered;
            int slot = (Integer)hoveredSlot.getSecond();
            boolean recipeHovered = (Integer)hoveredSlot.getFirst() == -2;
            boolean bl = orderHovered = (Integer)hoveredSlot.getFirst() == -1;
            BigGenericStack entry = recipeHovered ? (BigGenericStack)this.recipesToOrder.get(slot) : (orderHovered ? this.itemsToOrder.get(slot) : this.displayedItems.get((Integer)hoveredSlot.getFirst()).get(slot));
            ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>(GenericContentExtender.registrationOf((GenericKey)entry.get().key()).clientProvider().guiHandler().tooltipBuilder(entry.get().key(), entry.get().amount()));
            if (recipeHovered && !lines.isEmpty()) {
                lines.set(0, CreateLang.translateDirect((String)"gui.stock_keeper.craft", (Object[])new Object[]{((Component)lines.getFirst()).copy()}));
            }
            graphics.renderComponentTooltip(this.font, lines, mouseX, mouseY);
        }
        if (this.addressBox.getValue().isBlank() && !this.addressBox.isFocused() && this.addressBox.isHovered()) {
            graphics.renderComponentTooltip(this.font, List.of(CreateLang.translate((String)"gui.factory_panel.restocker_address", (Object[])new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate((String)"gui.schedule.lmb_edit", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
        }
    }

    public List<BigGenericStack> itemsToOrder() {
        return this.itemsToOrder;
    }

    public List<CraftableGenericStack> recipesToOrder() {
        return this.recipesToOrder;
    }

    public Level world() {
        return this.playerInventory.player.level();
    }

    @Nullable
    public BigGenericStack orderForStack(GenericStack stack) {
        for (BigGenericStack entry : this.itemsToOrder) {
            if (!entry.get().canStack(stack)) continue;
            return entry;
        }
        return null;
    }

    public GenericInventorySummary stockSnapshot() {
        GenericInventorySummary summary = GenericInventorySummary.empty();
        ClientScreenStorage.stacks.forEach(arg_0 -> ((GenericInventorySummary)summary).add(arg_0));
        return summary;
    }

    private boolean isConfirmHovered(int mouseX, int mouseY) {
        int confirmX = this.getGuiLeft() + 143;
        int confirmY = this.getGuiTop() + this.windowHeight - 39;
        int confirmW = 78;
        int confirmH = 18;
        if (mouseX < confirmX || mouseX >= confirmX + confirmW) {
            return false;
        }
        return mouseY >= confirmY && mouseY < confirmY + confirmH;
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        int transfer;
        BigGenericStack entry;
        boolean recipeClicked;
        boolean rmb;
        boolean lmb = pButton == 0;
        boolean bl = rmb = pButton == 1;
        if (rmb && this.searchBox.isMouseOver(pMouseX, pMouseY)) {
            this.searchBox.setValue("");
            this.refreshSearchNextTick = true;
            this.moveToTopNextTick = true;
            this.searchBox.setFocused(true);
            this.syncJEI();
            return true;
        }
        if (this.addressBox.isFocused()) {
            if (this.addressBox.isHovered()) {
                return this.addressBox.mouseClicked(pMouseX, pMouseY, pButton);
            }
            this.addressBox.setFocused(false);
        }
        if (this.searchBox.isFocused()) {
            if (this.searchBox.isHovered()) {
                return this.searchBox.mouseClicked(pMouseX, pMouseY, pButton);
            }
            this.searchBox.setFocused(false);
        }
        int barX = this.itemsX + 180 - 1;
        if (this.getMaxScroll() > 0 && lmb && pMouseX > (double)barX && pMouseX <= (double)(barX + 8) && pMouseY > (double)(this.getGuiTop() + 15) && pMouseY < (double)(this.getGuiTop() + this.windowHeight - 82)) {
            this.scrollHandleActive = true;
            if (this.minecraft != null && this.minecraft.isWindowActive()) {
                GLFW.glfwSetInputMode((long)this.minecraft.getWindow().getWindow(), (int)208897, (int)212994);
            }
            return true;
        }
        Couple<Integer> hoveredSlot = this.getHoveredSlot((int)pMouseX, (int)pMouseY);
        if (lmb && this.isConfirmHovered((int)pMouseX, (int)pMouseY)) {
            this.sendIt();
            this.playUiSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
            return true;
        }
        int localY = (int)(pMouseY - (double)this.itemsY);
        if (this.itemScroll.settled() && lmb && !this.categories.isEmpty() && pMouseX >= (double)this.itemsX && pMouseX < (double)(this.itemsX + 180) && pMouseY >= (double)(this.getGuiTop() + 16) && pMouseY <= (double)(this.getGuiTop() + this.windowHeight - 80)) {
            for (int categoryIndex = 0; categoryIndex < this.displayedItems.size(); ++categoryIndex) {
                int indexOf;
                GenericSearch.CategoryEntry entry2 = this.categories.get(categoryIndex);
                if (Mth.floor((float)((float)(localY - entry2.y().intValue()) / 20.0f + this.itemScroll.getChaseTarget())) != 0 || this.displayedItems.get(categoryIndex).isEmpty() || (indexOf = entry2.targetCategory()) >= ((PortableStockTickerMenu)this.menu).portableStockTicker.categories.size()) continue;
                if (entry2.hidden().isFalse()) {
                    this.hiddenCategories.add(indexOf);
                    this.playUiSound(SoundEvents.ITEM_FRAME_ROTATE_ITEM, 1.0f, 1.5f);
                } else {
                    this.hiddenCategories.remove(indexOf);
                    this.playUiSound(SoundEvents.ITEM_FRAME_ROTATE_ITEM, 1.0f, 0.675f);
                }
                this.refreshSearchNextTick = true;
                this.moveToTopNextTick = false;
                return true;
            }
        }
        if (hoveredSlot == this.noneHovered || !lmb && !rmb) {
            return super.mouseClicked(pMouseX, pMouseY, pButton);
        }
        boolean orderClicked = (Integer)hoveredSlot.getFirst() == -1;
        boolean bl2 = recipeClicked = (Integer)hoveredSlot.getFirst() == -2;
        BigGenericStack bigGenericStack = recipeClicked ? (BigGenericStack)this.recipesToOrder.get((Integer)hoveredSlot.getSecond()) : (entry = orderClicked ? this.itemsToOrder.get((Integer)hoveredSlot.getSecond()) : this.displayedItems.get((Integer)hoveredSlot.getFirst()).get((Integer)hoveredSlot.getSecond()));
        int n = PortableStockTickerScreen.hasShiftDown() ? GenericContentExtender.registrationOf((GenericKey)entry.get().key()).clientProvider().guiHandler().stackSize(entry.get().key()) : (transfer = PortableStockTickerScreen.hasControlDown() ? 10 : 1);
        if (recipeClicked && entry instanceof CraftableGenericStack) {
            CraftableGenericStack cbis = (CraftableGenericStack)entry;
            if (rmb && cbis.get().amount() == 0) {
                this.recipesToOrder.remove(cbis);
                return true;
            }
            this.requestCraftable(cbis, rmb ? -transfer : transfer);
            return true;
        }
        BigGenericStack existingOrder = this.orderForStack(entry.get());
        if (existingOrder == null) {
            if (this.itemsToOrder.size() >= 9 || rmb) {
                return true;
            }
            existingOrder = BigGenericStack.of((GenericStack)entry.get().withAmount(0));
            this.itemsToOrder.add(existingOrder);
            this.playUiSound(SoundEvents.WOOL_STEP, 0.75f, 1.2f);
            this.playUiSound(SoundEvents.BAMBOO_WOOD_STEP, 0.75f, 0.8f);
        }
        int current = existingOrder.get().amount();
        if (rmb || orderClicked) {
            existingOrder.setAmount(current - transfer);
            if (existingOrder.get().amount() <= 0) {
                this.itemsToOrder.remove(existingOrder);
                this.playUiSound(SoundEvents.WOOL_STEP, 0.75f, 1.8f);
                this.playUiSound(SoundEvents.BAMBOO_WOOD_STEP, 0.75f, 1.8f);
            }
            return true;
        }
        existingOrder.setAmount(current + Math.min(transfer, entry.get().amount() - current));
        return true;
    }

    public void requestCraftable(CraftableGenericStack cbis, int requestedDifference) {
        RecipeRequestHelper.requestCraftable((OrderProvider)this, (CraftableGenericStack)cbis, (int)requestedDifference);
    }

    private void updateCraftableAmounts() {
        RecipeRequestHelper.updateCraftableAmounts((OrderProvider)this);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0 && this.scrollHandleActive) {
            this.scrollHandleActive = false;
            if (this.minecraft != null && this.minecraft.isWindowActive()) {
                GLFW.glfwSetInputMode((long)this.minecraft.getWindow().getWindow(), (int)208897, (int)212993);
            }
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean noHover;
        if (this.addressBox.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        Couple<Integer> hoveredSlot = this.getHoveredSlot((int)mouseX, (int)mouseY);
        boolean bl = noHover = hoveredSlot == this.noneHovered;
        if (noHover || (Integer)hoveredSlot.getFirst() >= 0 && !PortableStockTickerScreen.hasShiftDown() && this.getMaxScroll() != 0) {
            int maxScroll = this.getMaxScroll();
            int direction = (int)(Math.ceil(Math.abs(scrollY)) * -Math.signum(scrollY));
            float newTarget = Mth.clamp((int)Math.round(this.itemScroll.getChaseTarget() + (float)direction), (int)0, (int)maxScroll);
            this.itemScroll.chase((double)newTarget, 0.5, LerpedFloat.Chaser.EXP);
            return true;
        }
        try {
            int current;
            BigGenericStack existingOrder;
            boolean recipeClicked;
            boolean orderClicked = (Integer)hoveredSlot.getFirst() == -1;
            boolean bl2 = recipeClicked = (Integer)hoveredSlot.getFirst() == -2;
            BigGenericStack entry = recipeClicked ? (BigGenericStack)this.recipesToOrder.get((Integer)hoveredSlot.getSecond()) : (orderClicked ? this.itemsToOrder.get((Integer)hoveredSlot.getSecond()) : this.displayedItems.get((Integer)hoveredSlot.getFirst()).get((Integer)hoveredSlot.getSecond()));
            boolean remove = scrollY < 0.0;
            int transfer = Mth.ceil((double)Math.abs(scrollY)) * (PortableStockTickerScreen.hasControlDown() ? 10 : 1);
            BigGenericStack bigGenericStack = existingOrder = orderClicked ? entry : this.orderForStack(entry.get());
            if (existingOrder == null) {
                if (this.itemsToOrder.size() >= 9 || remove) {
                    return true;
                }
                if (entry != null) {
                    existingOrder = BigGenericStack.of((GenericStack)entry.get().withAmount(0));
                    this.itemsToOrder.add(existingOrder);
                }
                this.playUiSound(SoundEvents.WOOL_STEP, 0.75f, 1.2f);
                this.playUiSound(SoundEvents.BAMBOO_WOOD_STEP, 0.75f, 0.8f);
            }
            int n = current = existingOrder != null ? existingOrder.get().amount() : 0;
            if (remove) {
                existingOrder.setAmount(current - transfer);
                if (existingOrder.get().amount() <= 0) {
                    this.itemsToOrder.remove(existingOrder);
                    this.playUiSound(SoundEvents.WOOL_STEP, 0.75f, 1.8f);
                    this.playUiSound(SoundEvents.BAMBOO_WOOD_STEP, 0.75f, 1.8f);
                } else if (existingOrder.get().amount() != current) {
                    this.playUiSound(AllSoundEvents.SCROLL_VALUE.getMainEvent(), 0.25f, 1.2f);
                }
                return true;
            }
            GenericInventorySummary summary = GenericInventorySummary.empty();
            for (List<BigGenericStack> stackList : this.displayedItems) {
                for (BigGenericStack stack : stackList) {
                    summary.add(stack.get());
                }
            }
            if (existingOrder != null) {
                existingOrder.setAmount(current + Math.min(transfer, summary.getCountOf(entry.get().key()) - current));
            }
            if (existingOrder != null && existingOrder.get().amount() != current && current != 0) {
                this.playUiSound(AllSoundEvents.SCROLL_VALUE.getMainEvent(), 0.25f, 1.2f);
            }
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pButton != 0 || !this.scrollHandleActive) {
            return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        if (this.minecraft == null) {
            return false;
        }
        Window window = this.minecraft.getWindow();
        double scaleX = (double)window.getGuiScaledWidth() / (double)window.getScreenWidth();
        double scaleY = (double)window.getGuiScaledHeight() / (double)window.getScreenHeight();
        int windowH = this.windowHeight - 92;
        int totalH = this.getMaxScroll() * 20 + windowH;
        int barSize = Math.max(5, Mth.floor((float)((float)windowH / (float)totalH * (float)(windowH - 2))));
        int minY = this.getGuiTop() + 15 + barSize / 2;
        int maxY = this.getGuiTop() + 15 + windowH - barSize / 2;
        if (barSize >= windowH - 2) {
            return true;
        }
        int barX = this.itemsX + 180;
        double target = (pMouseY - (double)this.getGuiTop() - 15.0 - (double)barSize / 2.0) * (double)totalH / (double)(windowH - 2) / 20.0;
        this.itemScroll.chase(Mth.clamp((double)target, (double)0.0, (double)this.getMaxScroll()), 0.8, LerpedFloat.Chaser.EXP);
        if (this.minecraft.isWindowActive()) {
            double forceX = (double)(barX + 2) / scaleX;
            double forceY = Mth.clamp((double)pMouseY, (double)minY, (double)maxY) / scaleY;
            GLFW.glfwSetCursorPos((long)window.getWindow(), (double)forceX, (double)forceY);
        }
        return true;
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (this.addressBox.isFocused() && this.addressBox.charTyped(pCodePoint, pModifiers)) {
            return true;
        }
        String s = this.searchBox.getValue();
        if (!this.searchBox.charTyped(pCodePoint, pModifiers)) {
            return false;
        }
        if (!Objects.equals(s, this.searchBox.getValue())) {
            this.refreshSearchNextTick = true;
            this.moveToTopNextTick = true;
            this.syncJEI();
        }
        return true;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 257 && this.searchBox.isFocused()) {
            this.searchBox.setFocused(false);
            return true;
        }
        if (pKeyCode == 257 && PortableStockTickerScreen.hasShiftDown()) {
            this.sendIt();
            return true;
        }
        if (this.addressBox.isFocused() && this.addressBox.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        String s = this.searchBox.getValue();
        if (!this.searchBox.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return this.searchBox.isFocused() && this.searchBox.isVisible() && pKeyCode != 256 || super.keyPressed(pKeyCode, pScanCode, pModifiers);
        }
        if (!Objects.equals(s, this.searchBox.getValue())) {
            this.refreshSearchNextTick = true;
            this.moveToTopNextTick = true;
            this.syncJEI();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void sendIt() {
        void var3_9;
        if (this.itemsToOrder.isEmpty()) {
            return;
        }
        this.forcedEntries = GenericInventorySummary.empty();
        GenericInventorySummary summary = GenericInventorySummary.empty();
        for (List<BigGenericStack> list : this.displayedItems) {
            for (BigGenericStack stack : list) {
                summary.add(stack.get());
            }
        }
        for (BigGenericStack bigGenericStack : this.itemsToOrder) {
            int countOf = summary.getCountOf(bigGenericStack.get().key());
            if (countOf == 1000000000) continue;
            this.forcedEntries.add(bigGenericStack.get().withAmount(-1 - Math.max(0, countOf - bigGenericStack.get().amount())));
        }
        ArrayList<BigItemStack> stacks = new ArrayList<BigItemStack>(this.itemsToOrder.size());
        for (BigGenericStack stack : this.itemsToOrder) {
            stacks.add(stack.asStack());
        }
        PackageOrderWithCrafts packageOrderWithCrafts = PackageOrderWithCrafts.simple(stacks);
        if (!this.itemsToOrder.isEmpty() && !this.recipesToOrder.isEmpty()) {
            ArrayList<PackageOrderWithCrafts.CraftingEntry> craftList = new ArrayList<PackageOrderWithCrafts.CraftingEntry>();
            for (CraftableGenericStack cbis : this.recipesToOrder) {
                Recipe recipe = cbis.asStack().recipe;
                if (!(recipe instanceof CraftingRecipe)) continue;
                CraftingRecipe cr = (CraftingRecipe)recipe;
                PackageOrder pattern = new PackageOrder(FactoryPanelScreen.convertRecipeToPackageOrderContext((CraftingRecipe)cr, stacks, (boolean)true));
                int count = cbis.get().amount() / cbis.outputCount(this.playerInventory.player.level());
                craftList.add(new PackageOrderWithCrafts.CraftingEntry(pattern, count));
            }
            PackageOrderWithCrafts packageOrderWithCrafts2 = new PackageOrderWithCrafts(packageOrderWithCrafts.orderedStacks(), craftList);
        }
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new SendPackage(GenericOrder.of((PackageOrderWithCrafts)var3_9), this.addressBox.getValue()));
        ((PortableStockTickerMenu)this.menu).portableStockTicker.previouslyUsedAddress = this.addressBox.getValue();
        this.itemsToOrder = new ArrayList<BigGenericStack>();
        this.recipesToOrder = new ArrayList<CraftableGenericStack>();
        this.successTicks = 1;
        ClientScreenStorage.manualUpdate();
    }

    private Component getTroubleshootingMessage() {
        if (this.currentItemSource == null) {
            return CreateLang.translate((String)"gui.stock_keeper.checking_stocks", (Object[])new Object[0]).component();
        }
        if (this.currentItemSource.isEmpty()) {
            return CreateLang.translate((String)"gui.stock_keeper.inventories_empty", (Object[])new Object[0]).component();
        }
        return CreateLang.translate((String)"gui.stock_keeper.no_search_results", (Object[])new Object[0]).component();
    }

    private void syncJEI() {
        if (Mods.JEI.isLoaded() && ((Boolean)AllConfigs.client().syncJeiSearch.get()).booleanValue()) {
            CMPJEI.runtime.getIngredientFilter().setFilterText(this.searchBox.getValue());
        }
    }

    public void removed() {
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new HiddenCategoriesPacket(new ArrayList<Integer>(this.hiddenCategories)));
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new SendPackage(GenericOrder.empty(), this.addressBox.getValue()));
        super.removed();
    }

    public List<ItemStack> categories() {
        return ((PortableStockTickerMenu)this.menu).portableStockTicker.categories;
    }

    public Set<Integer> hiddenCategories() {
        return this.hiddenCategories;
    }

    public List<List<BigGenericStack>> currentItemSource() {
        return this.currentItemSource;
    }
}

