/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.portable_stock_ticker;

import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import de.theidler.create_mobile_packages.index.CMPDataComponents;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogisticallyLinkedItem
extends Item {
    public LogisticallyLinkedItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return LogisticallyLinkedItem.isTuned(stack);
    }

    public static boolean isTuned(ItemStack pStack) {
        return pStack.has(CMPDataComponents.CMP_FREQ);
    }

    @Nullable
    public static UUID networkFromStack(ItemStack pStack) {
        CompoundTag tag = ((CustomData)pStack.getOrDefault(CMPDataComponents.CMP_FREQ, (Object)CustomData.EMPTY)).copyTag();
        if (!tag.hasUUID("Freq")) {
            return null;
        }
        return tag.getUUID("Freq");
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, tooltipContext, tooltipComponents, tooltipFlag);
        CompoundTag tag = ((CustomData)stack.getOrDefault(CMPDataComponents.CMP_FREQ, (Object)CustomData.EMPTY)).copyTag();
        if (!tag.hasUUID("Freq")) {
            return;
        }
        CreateLang.translate((String)"logistically_linked.tooltip", (Object[])new Object[0]).style(ChatFormatting.GOLD).addTo(tooltipComponents);
        CreateLang.translate((String)"logistically_linked.tooltip_clear", (Object[])new Object[0]).style(ChatFormatting.GRAY).addTo(tooltipComponents);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        ItemStack stack = pContext.getItemInHand();
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        Player player = pContext.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        LogisticallyLinkedBehaviour link = (LogisticallyLinkedBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, (BehaviourType)LogisticallyLinkedBehaviour.TYPE);
        boolean tuned = LogisticallyLinkedItem.isTuned(stack);
        if (link != null) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!link.mayInteractMessage(player)) {
                return InteractionResult.SUCCESS;
            }
            LogisticallyLinkedItem.assignFrequency(stack, player, link.freqId);
            return InteractionResult.SUCCESS;
        }
        InteractionResult useOn = super.useOn(pContext);
        if (level.isClientSide || useOn == InteractionResult.FAIL) {
            return useOn;
        }
        player.displayClientMessage((Component)(tuned ? CreateLang.translateDirect((String)"logistically_linked.connected", (Object[])new Object[0]) : CreateLang.translateDirect((String)"logistically_linked.new_network_started", (Object[])new Object[0])), true);
        return useOn;
    }

    public static void assignFrequency(ItemStack stack, Player player, UUID frequency) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(CMPDataComponents.CMP_FREQ, (Object)CustomData.EMPTY)).copyTag();
        tag.putUUID("Freq", frequency);
        player.displayClientMessage((Component)CreateLang.translateDirect((String)"logistically_linked.tuned", (Object[])new Object[0]), true);
        stack.set(CMPDataComponents.CMP_FREQ, (Object)CustomData.of((CompoundTag)tag));
    }
}

