/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.mobile_packager;

import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.foundation.gui.menu.MenuBase;
import de.theidler.create_mobile_packages.index.CMPMenuTypes;
import de.theidler.create_mobile_packages.items.mobile_packager.MobilePackager;
import de.theidler.create_mobile_packages.items.mobile_packager.OpenEditMenuPacket;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class MobilePackagerMenu
extends MenuBase<MobilePackager> {
    private ItemStackHandler packageSlotInventory;
    public boolean confirmed = false;

    public MobilePackagerMenu(int id, Inventory inv, MobilePackager contentHolder) {
        super((MenuType)CMPMenuTypes.MOBILE_PACKAGER_MENU.get(), id, inv, (Object)contentHolder);
    }

    protected MobilePackager createOnClient(RegistryFriendlyByteBuf extraData) {
        return null;
    }

    public void initAndReadInventory(MobilePackager contentHolder) {
        this.packageSlotInventory = new ItemStackHandler(1);
    }

    public void addSlots() {
        this.addSlot((Slot)new MobilePackagerStackHandler((IItemHandler)this.packageSlotInventory, 0, 74, 28));
        this.addPlayerSlots(13, 112);
    }

    protected void saveData(MobilePackager contentHolder) {
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player pPlayer, int index) {
        Slot clickedSlot = this.getSlot(index);
        if (!clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = clickedSlot.getItem();
        boolean success = !this.moveItemStackTo(stack, 0, this.slots.size(), false);
        return success ? ItemStack.EMPTY : stack;
    }

    public void removed(Player playerIn) {
        if (!playerIn.level().isClientSide && !this.confirmed) {
            playerIn.getInventory().placeItemBackInInventory(this.packageSlotInventory.getStackInSlot(0));
        }
        super.removed(playerIn);
    }

    public void confirm() {
        ItemStack stack;
        if (this.player.level().isClientSide && !(stack = this.packageSlotInventory.getStackInSlot(0)).isEmpty()) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new OpenEditMenuPacket(this.packageSlotInventory.getStackInSlot(0)));
        }
    }

    public boolean stillValid(Player player) {
        if (player.getMainHandItem().getItem() instanceof MobilePackager) {
            return super.stillValid(player);
        }
        return false;
    }

    static class MobilePackagerStackHandler
    extends SlotItemHandler {
        public MobilePackagerStackHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return stack.getItem() instanceof PackageItem;
        }
    }
}

