/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.mobile_packager;

import com.simibubi.create.content.logistics.AddressEditBox;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.utility.CreateLang;
import de.theidler.create_mobile_packages.index.CMPItems;
import de.theidler.create_mobile_packages.items.mobile_packager.ConfirmEditMenuPacket;
import de.theidler.create_mobile_packages.items.mobile_packager.MobilePackagerEdit;
import de.theidler.create_mobile_packages.items.mobile_packager.MobilePackagerEditMenu;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MobilePackagerEditScreen
extends AbstractSimiContainerScreen<MobilePackagerEditMenu> {
    private EditBox addressBox;
    private IconButton confirmButton;

    public MobilePackagerEditScreen(MobilePackagerEditMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    protected void init() {
        int bgHeight = AllGuiTextures.REDSTONE_REQUESTER.getHeight();
        int bgWidth = AllGuiTextures.REDSTONE_REQUESTER.getWidth();
        this.setWindowSize(bgWidth, bgHeight + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        super.init();
        this.clearWidgets();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        ((MobilePackagerEditMenu)this.menu).addSlots();
        if (this.addressBox == null) {
            this.addressBox = new AddressEditBox((Screen)this, (Font)new NoShadowFontWrapper(this.font), x + 55, y + 68, 110, 10, false);
            this.addressBox.setValue(((MobilePackagerEdit)((MobilePackagerEditMenu)this.menu).contentHolder).address);
            this.addressBox.setTextColor(0x555555);
        }
        this.addRenderableWidget((GuiEventListener)this.addressBox);
        this.confirmButton = new IconButton(x + bgWidth - 30, y + bgHeight - 25, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ConfirmEditMenuPacket(this.addressBox.getValue())));
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
    }

    protected void renderBg(@NotNull GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        AllGuiTextures.REDSTONE_REQUESTER.render(pGuiGraphics, x + 3, y);
        this.renderPlayerInventory(pGuiGraphics, x + 25, y + 124);
        ItemStack stack = CMPItems.MOBILE_PACKAGER.asStack();
        MutableComponent title = CreateLang.text((String)stack.getHoverName().getString()).component();
        pGuiGraphics.drawString(this.font, (Component)title, x + 117 - this.font.width((FormattedText)title) / 2, y + 4, 4013128, false);
        GuiGameElement.of((ItemStack)stack).scale(3.0).render(pGuiGraphics, x + 245, y + 80);
    }
}

