/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.mobile_packager;

import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.foundation.gui.menu.MenuBase;
import de.theidler.create_mobile_packages.index.CMPMenuTypes;
import de.theidler.create_mobile_packages.items.mobile_packager.MobilePackager;
import de.theidler.create_mobile_packages.items.mobile_packager.MobilePackagerEdit;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class MobilePackagerEditMenu
extends MenuBase<MobilePackagerEdit> {
    public ItemStack originalPackage;
    public ItemStackHandler handler;

    public MobilePackagerEditMenu(MenuType<MobilePackagerEditMenu> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        this(id, inv, new MobilePackagerEdit(), extraData != null ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)extraData) : ItemStack.EMPTY);
    }

    public MobilePackagerEditMenu(int id, Inventory inv, MobilePackagerEdit contentHolder, ItemStack originalPackage) {
        super((MenuType)CMPMenuTypes.MOBILE_PACKAGER_EDIT_MENU.get(), id, inv, (Object)contentHolder);
        this.originalPackage = originalPackage;
        contentHolder.loadFromStack(originalPackage);
        this.handler = contentHolder.contents;
    }

    protected MobilePackagerEdit createOnClient(RegistryFriendlyByteBuf extraData) {
        return null;
    }

    protected void initAndReadInventory(MobilePackagerEdit contentHolder) {
    }

    protected void addSlots() {
        if (this.handler == null) {
            this.handler = ((MobilePackagerEdit)this.contentHolder).contents;
        }
        int slotX = 27;
        int slotY = 28;
        for (int i = 0; i < 9; ++i) {
            this.addSlot((Slot)new MobilePackagerEditStackHandler((IItemHandler)this.handler, i, slotX + 20 * i, slotY));
        }
        this.addPlayerSlots(33, 142);
    }

    protected void saveData(MobilePackagerEdit contentHolder) {
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot clickedSlot = this.getSlot(index);
        if (!clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = clickedSlot.getItem();
        ItemStack originalStack = stack.copy();
        if (index < 9 ? !this.moveItemStackTo(stack, 9, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, 9, false)) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            clickedSlot.set(ItemStack.EMPTY);
        } else {
            clickedSlot.setChanged();
        }
        if (stack.getCount() == originalStack.getCount()) {
            return ItemStack.EMPTY;
        }
        clickedSlot.onTake(player, stack);
        return originalStack;
    }

    public void removed(Player playerIn) {
        ItemStack box;
        if (!(playerIn.level().isClientSide || PackageItem.getAddress((ItemStack)(box = ((MobilePackagerEdit)this.contentHolder).writeToStack())).isEmpty() && !this.hasContents(PackageItem.getContents((ItemStack)box)))) {
            playerIn.getInventory().placeItemBackInInventory(box);
        }
        super.removed(playerIn);
    }

    private boolean hasContents(ItemStackHandler contents) {
        for (int i = 0; i < contents.getSlots(); ++i) {
            if (contents.getStackInSlot(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void serverConfirm(String address) {
        ((MobilePackagerEdit)this.contentHolder).address = address;
        this.player.closeContainer();
    }

    public boolean stillValid(Player player) {
        if (player.getMainHandItem().getItem() instanceof MobilePackager) {
            return super.stillValid(player);
        }
        return false;
    }

    static class MobilePackagerEditStackHandler
    extends SlotItemHandler {
        public MobilePackagerEditStackHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return !(stack.getItem() instanceof PackageItem) && !(stack.getItem() instanceof MobilePackager);
        }
    }
}

