/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.index;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.theidler.create_mobile_packages.index.CMPItems;
import de.theidler.create_mobile_packages.robo.RoboManager;
import de.theidler.create_mobile_packages.toast.RemoveAllToastsOnClientPacket;
import de.theidler.create_mobile_packages.toast.ShowToastOnClientPacket;
import de.theidler.create_mobile_packages.toast.types.SimpleToast;
import java.util.UUID;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class CMPCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cmp").requires(cs -> cs.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"toast").then(Commands.literal((String)"clear").executes(CMPCommands::clearToasts))).then(Commands.literal((String)"create").then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String message = StringArgumentType.getString((CommandContext)ctx, (String)"message");
            return CMPCommands.createToast((CommandContext<CommandSourceStack>)ctx, message);
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"robos").requires(cs -> cs.hasPermission(2))).then(Commands.literal((String)"clear").executes(CMPCommands::clearRobos))));
    }

    private static int clearRobos(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        RoboManager manager = RoboManager.get(level);
        int roboCount = manager.robos.size();
        manager.robos.clear();
        source.sendSuccess(() -> Component.literal((String)("Cleared " + roboCount + " robos")), true);
        return 1;
    }

    private static int createToast(CommandContext<CommandSourceStack> context, String message) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.isPlayer()) {
            return 0;
        }
        ServerPlayer player = source.getPlayer();
        if (player == null) {
            return 0;
        }
        SimpleToast toast = new SimpleToast(UUID.randomUUID(), (Component)Component.literal((String)message), (Component)Component.literal((String)""), CMPItems.ROBO_BEE.asStack());
        CatnipServices.NETWORK.sendToClient(player, (CustomPacketPayload)new ShowToastOnClientPacket(toast));
        return 1;
    }

    private static int clearToasts(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.isPlayer()) {
            return 0;
        }
        ServerPlayer player = source.getPlayer();
        if (player == null) {
            return 0;
        }
        CatnipServices.NETWORK.sendToClient(player, (CustomPacketPayload)RemoveAllToastsOnClientPacket.INSTANCE);
        return 1;
    }
}

