/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.blocks.bee_port;

import de.theidler.create_mobile_packages.blocks.bee_port.BeePortBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class DronePortTracker
extends SavedData {
    private final List<BeePortBlockEntity> dronePorts = new ArrayList<BeePortBlockEntity>();

    public static DronePortTracker get(ServerLevel level) {
        return (DronePortTracker)level.getDataStorage().computeIfAbsent(new SavedData.Factory(DronePortTracker::create, DronePortTracker::load), "drone_port_tracker");
    }

    public static DronePortTracker create() {
        return new DronePortTracker();
    }

    public static DronePortTracker load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        return DronePortTracker.create();
    }

    public void add(BeePortBlockEntity dronePort) {
        if (!this.dronePorts.contains((Object)dronePort)) {
            this.dronePorts.add(dronePort);
            this.setDirty();
        }
    }

    public void remove(BeePortBlockEntity dronePort) {
        if (this.dronePorts.remove((Object)dronePort)) {
            this.setDirty();
        }
    }

    public List<BeePortBlockEntity> getAll() {
        return this.dronePorts;
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        return compoundTag;
    }

    public List<BeePortBlockEntity> getAllByNetwork(UUID logisticsNetworkId) {
        return this.dronePorts.stream().filter(dpbe -> dpbe.getLogisticsNetworkId().equals(logisticsNetworkId)).toList();
    }
}

