/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.blocks.bee_port;

import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.simibubi.create.content.logistics.packagePort.PackagePortMenu;
import de.theidler.create_mobile_packages.blocks.bee_port.BeePortBeeStackHandler;
import de.theidler.create_mobile_packages.blocks.bee_port.BeePortBlockEntity;
import de.theidler.create_mobile_packages.index.CMPItems;
import de.theidler.create_mobile_packages.index.CMPMenuTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BeePortMenu
extends PackagePortMenu {
    private ContainerData data;

    public BeePortMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
        Object object = this.contentHolder;
        if (object instanceof BeePortBlockEntity) {
            BeePortBlockEntity beePortBlockEntity = (BeePortBlockEntity)((Object)object);
            this.data = beePortBlockEntity.getData();
            this.addDataSlots(this.data);
        }
    }

    public BeePortMenu(MenuType<?> type, int id, Inventory inv, BeePortBlockEntity beePortBlockEntity) {
        super(type, id, inv, (PackagePortBlockEntity)beePortBlockEntity);
        this.data = beePortBlockEntity.getData();
        this.addDataSlots(this.data);
    }

    protected BeePortBlockEntity createOnClient(RegistryFriendlyByteBuf extraData) {
        BlockEntity blockEntity;
        BlockPos readBlockPos = extraData.readBlockPos();
        ClientLevel world = Minecraft.getInstance().level;
        BlockEntity blockEntity2 = blockEntity = world != null ? world.getBlockEntity(readBlockPos) : null;
        if (blockEntity instanceof BeePortBlockEntity) {
            BeePortBlockEntity beePortBlockEntity = (BeePortBlockEntity)blockEntity;
            return beePortBlockEntity;
        }
        return null;
    }

    public static BeePortMenu create(int id, Inventory inv, BeePortBlockEntity beePortBlockEntity) {
        return new BeePortMenu((MenuType)CMPMenuTypes.BEE_PORT_MENU.get(), id, inv, beePortBlockEntity);
    }

    protected void addSlots() {
        super.addSlots();
        Object object = this.contentHolder;
        if (object instanceof BeePortBlockEntity) {
            BeePortBlockEntity beePortBlockEntity = (BeePortBlockEntity)((Object)object);
            this.addSlot((Slot)new BeePortBeeStackHandler((IItemHandler)beePortBlockEntity.getRoboBeeInventory(), 0, 12, 60));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return super.quickMoveStack(player, index);
        }
        ItemStack stack = slot.getItem();
        if (index == 54) {
            int originalCount = stack.getCount();
            if (this.moveItemStackTo(stack, 18, 54, false)) {
                int moved = originalCount - stack.getCount();
                if (stack.isEmpty()) {
                    slot.set(ItemStack.EMPTY);
                } else {
                    slot.setChanged();
                }
                ItemStack result = stack.copy();
                result.setCount(moved);
                return result;
            }
        } else if (stack.getItem() == CMPItems.ROBO_BEE.get()) {
            Slot roboBeeSlot = (Slot)this.slots.get(54);
            ItemStack targetStack = roboBeeSlot.getItem();
            int maxStackSize = stack.getMaxStackSize();
            int space = maxStackSize - (targetStack.isEmpty() ? 0 : targetStack.getCount());
            if (space > 0) {
                int toMove = Math.min(space, stack.getCount());
                if (targetStack.isEmpty()) {
                    ItemStack moved = stack.copy();
                    moved.setCount(toMove);
                    roboBeeSlot.set(moved);
                } else {
                    targetStack.grow(toMove);
                    roboBeeSlot.setChanged();
                }
                stack.shrink(toMove);
                if (stack.isEmpty()) {
                    slot.set(ItemStack.EMPTY);
                } else {
                    slot.setChanged();
                }
                ItemStack result = stack.copy();
                result.setCount(toMove);
                return result;
            }
            return ItemStack.EMPTY;
        }
        return super.quickMoveStack(player, index);
    }

    public int getETA() {
        if (this.data != null) {
            return this.data.get(0);
        }
        return -1;
    }

    public boolean isBeeOnTravel() {
        if (this.data != null && this.data.get(0) != -1) {
            return this.data.get(1) == 1;
        }
        return false;
    }
}

