/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages;

import com.simibubi.create.content.logistics.box.PackageItem;
import de.theidler.create_mobile_packages.blocks.bee_port.BeePortBlockEntity;
import de.theidler.create_mobile_packages.blocks.bee_port.DronePortTracker;
import de.theidler.create_mobile_packages.index.config.CMPConfigs;
import de.theidler.create_mobile_packages.robo.VirtualRobo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class CMPHelper {
    public static Vec3 readVec3FromTag(CompoundTag tag, String key) {
        double x = tag.getDouble(key + "X");
        double y = tag.getDouble(key + "Y");
        double z = tag.getDouble(key + "Z");
        return new Vec3(x, y, z);
    }

    public static CompoundTag writeVec3ToTag(CompoundTag tag, String key, Vec3 vec) {
        tag.putDouble(key + "X", vec.x);
        tag.putDouble(key + "Y", vec.y);
        tag.putDouble(key + "Z", vec.z);
        return tag;
    }

    public static boolean isWithinRange(BlockPos targetPos, BlockPos originPos) {
        int maxDistance = (Integer)CMPConfigs.server().beeMaxDistance.get();
        if (targetPos == null || originPos == null) {
            return false;
        }
        if (maxDistance == -1) {
            return true;
        }
        return targetPos.distSqr((Vec3i)originPos) <= (double)(maxDistance * maxDistance);
    }

    public static BeePortBlockEntity getClosestBeePort(Level level, String address, BlockPos origin, VirtualRobo entity, UUID logisticsNetworkId) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DronePortTracker tracker = DronePortTracker.get(serverLevel);
            ArrayList<BeePortBlockEntity> allBEs = new ArrayList<BeePortBlockEntity>(tracker.getAllByNetwork(logisticsNetworkId));
            if (allBEs.isEmpty()) {
                allBEs.addAll(tracker.getAll());
            }
            allBEs.removeIf(BlockEntity::isRemoved);
            allBEs.removeIf(dpbe -> !CMPHelper.isWithinRange(dpbe.getBlockPos(), origin));
            if (address != null && !address.isEmpty()) {
                allBEs.removeIf(dpbe -> !PackageItem.matchAddress((String)address, (String)dpbe.addressFilter));
            }
            allBEs.removeIf(dpbe -> !dpbe.canAcceptEntity(entity, entity != null && !entity.getItemStack().isEmpty()));
            return allBEs.stream().min(Comparator.comparingDouble(a -> a.getBlockPos().distSqr((Vec3i)origin))).orElse(null);
        }
        return null;
    }

    public static int calcETA(Vec3 targetPosition, Vec3 currentPosition) {
        if (targetPosition == null || currentPosition == null) {
            return -1;
        }
        double distance = targetPosition.distanceTo(currentPosition);
        return (int)(distance / (double)((Integer)CMPConfigs.server().beeSpeed.get()).intValue()) + 1;
    }

    public static boolean doesAddressMatchPlayer(Player player, String address) {
        if (address == null) {
            return false;
        }
        String playerName = player.getName().getString();
        int atIndex = address.lastIndexOf(64);
        if (atIndex == -1) {
            return address.equals(playerName);
        }
        return address.substring(atIndex + 1).equals(playerName);
    }
}

