/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import immersive_aircraft.Main;
import immersive_aircraft.client.render.entity.renderer.AircraftEntityRenderer;
import immersive_aircraft.client.render.entity.renderer.utils.ModelPartRenderHandler;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.QuadrocopterEntity;
import java.util.Random;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class QuadrocopterEntityRenderer<T extends QuadrocopterEntity>
extends AircraftEntityRenderer<T> {
    private static final ResourceLocation ID = Main.locate("quadrocopter");
    private final Random random = new Random();
    private final ModelPartRenderHandler<T> model = new ModelPartRenderHandler<QuadrocopterEntity>().add("engine", (entity, yaw, tickDelta, matrixStack) -> {
        double p = (double)entity.enginePower.getSmooth() / 128.0;
        matrixStack.translate((this.random.nextDouble() - 0.5) * p, (this.random.nextDouble() - 0.5) * p, (this.random.nextDouble() - 0.5) * p);
    }, (model, object, vertexConsumerProvider, entity, matrixStack, light, time, modelPartRenderer) -> {
        String engine = "engine_" + ((double)entity.enginePower.getSmooth() > 0.01 ? entity.tickCount % 2 : 0);
        this.renderOptionalObject(engine, model, vertexConsumerProvider, entity, matrixStack, light, time);
    });

    @Override
    protected ResourceLocation getModelId() {
        return ID;
    }

    public QuadrocopterEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.8f;
    }

    @Override
    protected ModelPartRenderHandler<T> getModel(AircraftEntity entity) {
        return this.model;
    }
}

