/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.content.components.recipe;

import com.oierbravo.create_mechanical_spawner.ModConstants;
import com.oierbravo.create_mechanical_spawner.content.components.recipe.SpawnerRecipeOutput;
import com.oierbravo.create_mechanical_spawner.content.components.recipe.SpawnerRecipeSerializer;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipe;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipeParams;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;

public class SpawnerRecipe
extends AbstractMechanicalRecipe<RecipeInput, SpawnerRecipeParams> {
    private final SizedFluidIngredient fluidIngredient;
    private NonNullList<ProcessingOutput> customLoot;
    private SpawnerRecipeOutput mob;
    private final int processingTime;

    public SpawnerRecipe(SpawnerRecipeParams params) {
        super((AbstractMechanicalRecipeParams)params);
        this.mob = params.mob;
        this.fluidIngredient = params.fluidIngredient;
        this.processingTime = params.processingTime;
        this.customLoot = params.customLoot;
    }

    public boolean matches(FluidStack fluidStack) {
        return this.fluidIngredient.test(fluidStack);
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }

    @NotNull
    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SpawnerRecipeSerializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public int getFluidAmount() {
        return this.fluidIngredient.amount();
    }

    public SizedFluidIngredient getFluidIngredient() {
        return this.fluidIngredient;
    }

    public ResourceKey<EntityType<?>> getMob() {
        return this.mob.getMob();
    }

    public NonNullList<ProcessingOutput> getCustomLoot() {
        return this.customLoot;
    }

    public List<ItemStack> rollCustomLoot(RandomSource source) {
        return this.rollCustomLoot((List<ProcessingOutput>)this.getCustomLoot(), source);
    }

    public List<ItemStack> rollCustomLoot(List<ProcessingOutput> rollableResults, RandomSource source) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (int i = 0; i < rollableResults.size(); ++i) {
            ProcessingOutput output = rollableResults.get(i);
            ItemStack stack = output.rollOutput(source);
            if (stack.isEmpty()) continue;
            results.add(stack);
        }
        return results;
    }

    public SpawnerRecipeOutput getOutput() {
        return this.mob;
    }

    public ArrayList<IRecipeRequirement> getRecipeRequirements() {
        return this.recipeRequirements;
    }

    public SizedFluidIngredient getInput() {
        return this.fluidIngredient;
    }

    public ResourceLocation getMobResourceLocation() {
        assert (this.mob.getMob() != null);
        if (this.mob.getMob() != null) {
            return this.mob.getMob().location();
        }
        return ModConstants.asResource("random");
    }

    public static class SpawnerRecipeParams
    extends AbstractMechanicalRecipeParams {
        protected SizedFluidIngredient fluidIngredient;
        protected SpawnerRecipeOutput mob = new SpawnerRecipeOutput();
        protected int processingTime = 200;
        protected NonNullList<ProcessingOutput> customLoot;

        protected SpawnerRecipeParams() {
            this.fluidIngredient = new SizedFluidIngredient(FluidIngredient.empty(), 1000);
            this.customLoot = NonNullList.create();
        }
    }

    public static class Type
    implements RecipeType<SpawnerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "spawner";

        private Type() {
        }
    }
}

