/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.content.components;

import com.oierbravo.create_mechanical_spawner.content.components.SpawnerBlockEntity;
import com.oierbravo.create_mechanical_spawner.infrastructure.config.MConfigs;
import com.oierbravo.create_mechanical_spawner.registrate.ModBlockEntities;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpawnerBlock
extends HorizontalKineticBlock
implements IBE<SpawnerBlockEntity>,
IWrenchable {
    public static final VoxelShape SHAPE = new AllShapes.Builder(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).add(new AllShapes.Builder(Block.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0)).build()).add(new AllShapes.Builder(Block.box((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).build()).build();

    public SpawnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == Direction.DOWN;
    }

    public Class<SpawnerBlockEntity> getBlockEntityClass() {
        return SpawnerBlockEntity.class;
    }

    public BlockEntityType<? extends SpawnerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.MECHANICAL_SPAWNER.get();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction prefferedSide = this.getPreferredHorizontalFacing(context);
        if (prefferedSide == null) {
            prefferedSide = context.getHorizontalDirection();
        }
        return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)(context.getPlayer() != null && context.getPlayer().isShiftKeyDown() ? prefferedSide : prefferedSide.getOpposite()));
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.of((float)MConfigs.server().spawner.minimumSpeed.getF());
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasBlockEntity() && state.getBlock() != newState.getBlock()) {
            this.withBlockEntityDo((BlockGetter)worldIn, pos, SmartBlockEntity::setRemoved);
            worldIn.removeBlockEntity(pos);
        }
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (placer instanceof ServerPlayer) {
            this.withBlockEntityDo((BlockGetter)worldIn, pos, dbe -> {
                dbe.owner = placer.getUUID();
            });
        }
    }
}

