/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.mixin;

import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.init.ModItems;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Shadow
    @Final
    private Abilities abilities;

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"getFlyingSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    protected void getFlyingSpeed(CallbackInfoReturnable<Float> cir) {
        Player player;
        PlayerMixin playerMixin = this;
        if (playerMixin instanceof Player && BackpackAbilities.ABILITIES.checkBackpack(player = (Player)playerMixin, (Item)ModItems.FOX_TRAVELERS_BACKPACK.get()) && (!this.abilities.flying || this.isPassenger())) {
            cir.setReturnValue((Object)Float.valueOf(this.isSprinting() ? 0.038999997f : 0.033f));
        }
    }
}

