/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items.upgrades;

import com.tiviacz.travelersbackpack.inventory.Tiers;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TierUpgrade
extends Item {
    private final Upgrade type;

    public TierUpgrade(Item.Properties pProperties, Upgrade type) {
        super(pProperties);
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        switch (this.type.ordinal()) {
            case 0: {
                tooltipComponents.add((Component)Component.translatable((String)"item.travelersbackpack.blank_upgrade_tooltip").withStyle(ChatFormatting.BLUE));
                break;
            }
            case 1: {
                tooltipComponents.add((Component)Component.translatable((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.LEATHER.getLocalizedName()}).withStyle(ChatFormatting.BLUE));
                break;
            }
            case 2: {
                tooltipComponents.add((Component)Component.translatable((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.IRON.getLocalizedName()}).withStyle(ChatFormatting.BLUE));
                break;
            }
            case 3: {
                tooltipComponents.add((Component)Component.translatable((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.GOLD.getLocalizedName()}).withStyle(ChatFormatting.BLUE));
                break;
            }
            case 4: {
                tooltipComponents.add((Component)Component.translatable((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.DIAMOND.getLocalizedName()}).withStyle(ChatFormatting.BLUE));
            }
        }
    }

    public static enum Upgrade {
        BLANK_UPGRADE,
        IRON_TIER_UPGRADE,
        GOLD_TIER_UPGRADE,
        DIAMOND_TIER_UPGRADE,
        NETHERITE_TIER_UPGRADE;

    }
}

