/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items.upgrades;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.refill.RefillUpgrade;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import java.util.Optional;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.function.TriFunction;

public class RefillUpgradeItem
extends UpgradeItem {
    public RefillUpgradeItem(Item.Properties pProperties) {
        super(pProperties, "refill_upgrade");
    }

    public boolean isEnabled(FeatureFlagSet enabledFeatures) {
        return (Boolean)TravelersBackpackConfig.SERVER.backpackUpgrades.refillUpgradeSettings.enableRefillUpgrade.get() != false && super.isEnabled(enabledFeatures);
    }

    @Override
    public boolean isTickingUpgrade() {
        return true;
    }

    @Override
    public Class<? extends UpgradeBase<?>> getUpgradeClass() {
        return RefillUpgrade.class;
    }

    @Override
    public TriFunction<UpgradeManager, Integer, ItemStack, Optional<? extends UpgradeBase<?>>> getUpgrade() {
        return (upgradeManager, dataHolderSlot, provider) -> {
            BackpackContainerContents filter = (BackpackContainerContents)provider.getOrDefault(ModDataComponents.BACKPACK_CONTAINER, (Object)new BackpackContainerContents(9));
            return Optional.of(new RefillUpgrade((UpgradeManager)upgradeManager, (int)dataHolderSlot, filter.getItems()));
        };
    }
}

