/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.voiding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidWidget;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;

public class VoidUpgrade
extends FilterUpgradeBase<VoidUpgrade, VoidFilterSettings>
implements IEnable {
    public VoidUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> filter, List<String> filterTags) {
        super(manager, dataHolderSlot, new Point(66, 49), (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.voidUpgradeSettings.filterSlotCount.get(), (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.voidUpgradeSettings.slotsInRow.get(), filter, filterTags);
    }

    @Override
    public List<Integer> getFilter() {
        return (List)this.getDataHolderStack().getOrDefault(ModDataComponents.FILTER_SETTINGS, List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1)));
    }

    @Override
    public VoidFilterSettings createFilterSettings(UpgradeManager manager, NonNullList<ItemStack> filter, List<String> filterTags) {
        return new VoidFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(this.getFilterSlotCount()).filter(stack -> !stack.isEmpty()).toList(), this.getFilter(), filterTags);
    }

    public boolean canVoid(ItemStack stack) {
        return ((VoidFilterSettings)this.getFilterSettings()).matchesFilter(null, stack) && this.isEnabled(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new VoidWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    protected FilterHandler createFilter(NonNullList<ItemStack> stacks, final int size) {
        return new FilterHandler(stacks, size){

            protected void onContentsChanged(int slot) {
                VoidUpgrade.this.updateDataHolderUnchecked((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get(), InventoryHelper.itemsToList(size, (IItemHandler)VoidUpgrade.this.filter));
                ((VoidFilterSettings)VoidUpgrade.this.getFilterSettings()).updateFilter((List<ItemStack>)((BackpackContainerContents)VoidUpgrade.this.getDataHolderStack().get(ModDataComponents.BACKPACK_CONTAINER)).getItems());
                ((VoidFilterSettings)VoidUpgrade.this.getFilterSettings()).updateFilterTags((List)VoidUpgrade.this.getDataHolderStack().get(ModDataComponents.FILTER_TAGS));
                VoidUpgrade.this.changeListeners.forEach(Runnable::run);
            }
        };
    }
}

