/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.tanks;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidWidget;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TankWidget
extends UpgradeWidgetBase<TanksUpgrade> {
    public final WidgetElement leftTankElement;
    public final WidgetElement rightTankElement;
    public final int tankWidth = 18;
    public final int tankHeight;
    public final Point leftTankPos;
    public final Point rightTankPos;

    public TankWidget(BackpackScreen screen, TanksUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(0, 0), "screen.travelersbackpack.tanks_upgrade");
        this.tankHeight = 18 * screen.visibleRows;
        this.leftTankPos = new Point(screen.getGuiLeft() + 7, screen.getGuiTop() + 17);
        this.rightTankPos = new Point(screen.getGuiLeft() + 195 + (screen.getWrapper().isExtended() ? 36 : 0), screen.getGuiTop() + 17);
        this.leftTankElement = new WidgetElement(this.leftTankPos, new Point(this.tankWidth, this.tankHeight));
        this.rightTankElement = new WidgetElement(this.rightTankPos, new Point(this.tankWidth, this.tankHeight));
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.inTank(this.leftTankElement, mouseX, mouseY)) {
            guiGraphics.renderComponentTooltip(((BackpackScreen)this.screen).getFont(), this.getTankTooltip(((TanksUpgrade)this.upgrade).leftTank), mouseX, mouseY);
        }
        if (this.inTank(this.rightTankElement, mouseX, mouseY)) {
            guiGraphics.renderComponentTooltip(((BackpackScreen)this.screen).getFont(), this.getTankTooltip(((TanksUpgrade)this.upgrade).rightTank), mouseX, mouseY);
        }
    }

    @Override
    public void renderAboveBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int rows = ((TanksUpgrade)this.upgrade).getUpgradeManager().getWrapper().getRows();
        RenderHelper.renderScreenTank(guiGraphics, ((TanksUpgrade)this.upgrade).leftTank, this.leftTankPos.x() + 1, this.leftTankPos.y() + 1, 0.0, this.getTankHeight(rows), 16.0);
        this.renderTank(guiGraphics, this.leftTankElement, 0, mouseX, mouseY, rows, this.leftTankPos.x(), this.leftTankPos.y());
        RenderHelper.renderScreenTank(guiGraphics, ((TanksUpgrade)this.upgrade).rightTank, this.rightTankPos.x() + 1, this.rightTankPos.y() + 1, 0.0, this.getTankHeight(rows), 16.0);
        this.renderTank(guiGraphics, this.rightTankElement, 1, mouseX, mouseY, rows, this.rightTankPos.x(), this.rightTankPos.y());
    }

    public int getTankHeight(int rows) {
        return (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : rows) * 18 - 2;
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.inTank(this.leftTankElement, pMouseX, pMouseY) && this.isValid(((BackpackBaseMenu)((BackpackScreen)this.screen).getMenu()).getCarried())) {
            ServerboundActionTagPacket.create(5, true);
            return true;
        }
        if (this.inTank(this.rightTankElement, pMouseX, pMouseY) && this.isValid(((BackpackBaseMenu)((BackpackScreen)this.screen).getMenu()).getCarried())) {
            ServerboundActionTagPacket.create(5, false);
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean isValid(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).isPresent() || stack.getItem() instanceof PotionItem || stack.getItem() == Items.GLASS_BOTTLE;
    }

    public void renderTank(GuiGraphics guiGraphics, WidgetElement tankElement, int tankIndex, int mouseX, int mouseY, int rows, int x, int y) {
        WidgetBase<?> widgetBase = ((BackpackScreen)this.screen).mappedWidgets.get(VoidUpgrade.class);
        if (widgetBase instanceof VoidWidget) {
            VoidWidget voidWidget = (VoidWidget)widgetBase;
            voidWidget.drawRedTankHighlight(guiGraphics, x + 1, y + 1, this.inTank(tankElement, mouseX, mouseY), this.getTankHeight(rows), tankIndex);
        }
        guiGraphics.blit(BackpackScreen.ICONS, x, y, 0, 95, 18, 18);
        for (int i = 1; i <= (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : rows) - 2; ++i) {
            guiGraphics.blit(BackpackScreen.ICONS, x, y + 18 * i, 0, 113, 18, 18);
        }
        guiGraphics.blit(BackpackScreen.ICONS, x, y + 18 * ((((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : rows) - 1), 0, 131, 18, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTankTooltip(FluidTank tank) {
        Object fluidAmount;
        FluidStack fluidStack = tank.getFluid();
        ArrayList<Component> tankTips = new ArrayList<Component>();
        String fluidName = !fluidStack.isEmpty() ? fluidStack.getHoverName().getString() : I18n.get((String)"screen.travelersbackpack.none", (Object[])new Object[0]);
        Object object = fluidAmount = !fluidStack.isEmpty() ? fluidStack.getAmount() + "/" + tank.getCapacity() : I18n.get((String)"screen.travelersbackpack.empty", (Object[])new Object[0]);
        if (!fluidStack.isEmpty() && fluidStack.has(DataComponents.POTION_CONTENTS)) {
            float durationFactor = 1.0f;
            if (fluidStack.has(DataComponents.CUSTOM_DATA) && ((CustomData)fluidStack.get(DataComponents.CUSTOM_DATA)).copyTag().contains("PotionType")) {
                int potionType = ((CustomData)fluidStack.get(DataComponents.CUSTOM_DATA)).copyTag().getInt("PotionType");
                if (potionType == 1) {
                    tankTips.add((Component)Component.translatable((String)"item.minecraft.splash_potion"));
                }
                if (potionType == 2) {
                    tankTips.add((Component)Component.translatable((String)"item.minecraft.lingering_potion"));
                    durationFactor = 0.25f;
                }
            }
            fluidName = null;
            PotionContents contents = (PotionContents)fluidStack.get(DataComponents.POTION_CONTENTS);
            if (Minecraft.getInstance().level != null) {
                contents.addPotionTooltip(tankTips::add, durationFactor, Minecraft.getInstance().level.tickRateManager().tickrate());
            }
        }
        if (fluidName != null) {
            tankTips.add((Component)Component.literal((String)fluidName));
        }
        tankTips.add((Component)Component.literal((String)fluidAmount));
        return tankTips;
    }

    public boolean inTank(WidgetElement tankElement, double mouseX, double mouseY) {
        return mouseX >= (double)tankElement.pos().x() && mouseX < (double)(tankElement.pos().x() + tankElement.size().x()) && mouseY >= (double)tankElement.pos().y() && mouseY < (double)(tankElement.pos().y() + tankElement.size().y());
    }
}

