/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.CommandDispatcher;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.commands.BackpackIconCommands;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.items.HoseItem;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.network.ServerboundRetrieveBackpackPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="travelersbackpack", value={Dist.CLIENT})
public class NeoForgeClientEventHandler {
    @SubscribeEvent
    public static void renderBackpackIcon(ScreenEvent.Render.Post event) {
        Screen backpack;
        Screen menu;
        AbstractContainerScreen screen;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Screen screen2 = mc.screen;
        if (screen2 instanceof AbstractContainerScreen) {
            screen = (AbstractContainerScreen)screen2;
            if (!TravelersBackpackItem.isCreative((Player)player)) {
                menu = screen.getMenu();
                ItemStack carried = menu.getCarried();
                Slot hoveredSlot = screen.getSlotUnderMouse();
                Optional<TooltipComponent> tooltip = Optional.empty();
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)screen.getGuiLeft(), (float)screen.getGuiTop(), 350.0f);
                for (Slot slot : menu.slots) {
                    ItemStack slotStack = slot.getItem();
                    if (carried.getItem() instanceof TravelersBackpackItem) {
                        tooltip = Optional.of(new BackpackTooltipComponent(carried, true));
                        if (slotStack.isEmpty() || !slot.mayPickup((Player)player) || !BackpackSlotItemHandler.isItemValid(slotStack)) continue;
                        guiGraphics.drawString(mc.font, "-", slot.x + 2, slot.y - 1, ChatFormatting.YELLOW.getColor().intValue());
                        if (slot != hoveredSlot) continue;
                        NeoForgeClientEventHandler.renderBackpackTooltipOnHover(event, mc, tooltip, screen.getGuiLeft(), screen.getGuiTop(), 350.0f);
                        continue;
                    }
                    if (carried.isEmpty() || !BackpackSlotItemHandler.isItemValid(carried) || !(slotStack.getItem() instanceof TravelersBackpackItem) || !slot.allowModification((Player)player)) continue;
                    tooltip = Optional.of(new BackpackTooltipComponent(slotStack, true));
                    guiGraphics.drawString(mc.font, "+", slot.x + 9, slot.y + 8, ChatFormatting.YELLOW.getColor().intValue());
                    if (slot != hoveredSlot) continue;
                    NeoForgeClientEventHandler.renderBackpackTooltipOnHover(event, mc, tooltip, screen.getGuiLeft(), screen.getGuiTop(), 350.0f);
                }
                guiGraphics.pose().popPose();
            }
        }
        if ((menu = mc.screen) instanceof InventoryScreen) {
            screen = (InventoryScreen)menu;
            if (AttachmentUtils.getAttachment((Player)player).isPresent() && AttachmentUtils.getAttachment((Player)player).get().hasBackpack() && TravelersBackpack.enableIntegration()) {
                backpack = AttachmentUtils.getAttachment((Player)player).get().getBackpack();
                guiGraphics.renderItem((ItemStack)backpack, screen.getGuiLeft() + 77, screen.getGuiTop() + 62 - 18);
                if (event.getMouseX() >= screen.getGuiLeft() + 77 && event.getMouseX() < screen.getGuiLeft() + 77 + 16 && event.getMouseY() >= screen.getGuiTop() + 62 - 18 && event.getMouseY() < screen.getGuiTop() + 62 - 18 + 16) {
                    AbstractContainerScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(screen.getGuiLeft() + 77), (int)(screen.getGuiTop() + 62 - 18), (int)-1000);
                    ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
                    components.add(Component.translatable((String)"screen.travelersbackpack.retrieve_backpack"));
                    guiGraphics.renderTooltip(mc.font, components, Optional.of(new BackpackTooltipComponent((ItemStack)backpack)), event.getMouseX(), event.getMouseY());
                }
            }
        }
        if (!((Boolean)TravelersBackpackConfig.CLIENT.showBackpackIconInInventory.get()).booleanValue()) {
            return;
        }
        backpack = mc.screen;
        if (backpack instanceof InventoryScreen) {
            screen = (InventoryScreen)backpack;
            if (AttachmentUtils.isWearingBackpack((Player)player)) {
                if (TravelersBackpack.enableIntegration()) {
                    return;
                }
                backpack = AttachmentUtils.getWearingBackpack((Player)player);
                guiGraphics.renderItem((ItemStack)backpack, screen.getGuiLeft() + 77, screen.getGuiTop() + 62 - 18);
                if (event.getMouseX() >= screen.getGuiLeft() + 77 && event.getMouseX() < screen.getGuiLeft() + 77 + 16 && event.getMouseY() >= screen.getGuiTop() + 62 - 18 && event.getMouseY() < screen.getGuiTop() + 62 - 18 + 16) {
                    AbstractContainerScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(screen.getGuiLeft() + 77), (int)(screen.getGuiTop() + 62 - 18), (int)-1000);
                    String button = ModClientEventHandler.OPEN_BACKPACK.getKey().getDisplayName().getString();
                    ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
                    components.add(Component.translatable((String)"screen.travelersbackpack.open_inventory", (Object[])new Object[]{button}));
                    components.add(Component.translatable((String)"screen.travelersbackpack.unequip_tip"));
                    components.add(Component.translatable((String)"screen.travelersbackpack.hide_icon"));
                    TooltipFlag.Default tooltipflag$default = mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
                    backpack.getItem().appendHoverText((ItemStack)backpack, Item.TooltipContext.of((Level)player.level()), components, (TooltipFlag)tooltipflag$default);
                    guiGraphics.renderTooltip(mc.font, components, Optional.of(new BackpackTooltipComponent((ItemStack)backpack)), event.getMouseX(), event.getMouseY());
                }
            }
        }
    }

    private static void renderBackpackTooltipOnHover(ScreenEvent.Render.Post event, Minecraft mc, Optional<TooltipComponent> component, float fx, float fy, float fz) {
        PoseStack poseStack = event.getGuiGraphics().pose();
        poseStack.pushPose();
        poseStack.translate(-fx, -fy, -fz);
        poseStack.translate(0.0f, 0.0f, 100.0f);
        event.getGuiGraphics().renderTooltip(mc.font, List.of(Component.translatable((String)"screen.travelersbackpack.add_to_backpack").withStyle(ChatFormatting.YELLOW)), component, event.getMouseX(), event.getMouseY());
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void hideBackpackIcon(ScreenEvent.MouseButtonPressed.Post event) {
        InventoryScreen screen;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Screen screen2 = Minecraft.getInstance().screen;
        if (screen2 instanceof InventoryScreen) {
            screen = (InventoryScreen)screen2;
            if (AttachmentUtils.getAttachment((Player)player).isPresent() && AttachmentUtils.getAttachment((Player)player).get().hasBackpack() && TravelersBackpack.enableIntegration() && event.getMouseX() >= (double)(screen.getGuiLeft() + 77) && event.getMouseX() < (double)(screen.getGuiLeft() + 77 + 16) && event.getMouseY() >= (double)(screen.getGuiTop() + 62 - 18) && event.getMouseY() < (double)(screen.getGuiTop() + 62 - 18 + 16) && event.getButton() == 0) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundRetrieveBackpackPacket(AttachmentUtils.getAttachment((Player)player).get().getBackpack().getItem().getDefaultInstance()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (!((Boolean)TravelersBackpackConfig.CLIENT.showBackpackIconInInventory.get()).booleanValue()) {
            return;
        }
        if (AttachmentUtils.isWearingBackpack((Player)player) && (screen2 = Minecraft.getInstance().screen) instanceof InventoryScreen) {
            screen = (InventoryScreen)screen2;
            if (TravelersBackpack.enableIntegration()) {
                return;
            }
            if (event.getMouseX() >= (double)(screen.getGuiLeft() + 77) && event.getMouseX() < (double)(screen.getGuiLeft() + 77 + 16) && event.getMouseY() >= (double)(screen.getGuiTop() + 62 - 18) && event.getMouseY() < (double)(screen.getGuiTop() + 62 - 18 + 16) && event.getButton() == 1) {
                if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340)) {
                    player.sendSystemMessage((Component)Component.translatable((String)"screen.travelersbackpack.hide_icon_info"));
                } else {
                    ServerboundActionTagPacket.create(1, new Object[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void screenTickEvent(ScreenEvent.KeyPressed.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.allowOpeningFromSlot.get()).booleanValue()) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            Slot slot;
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (event.getScreen().getMinecraft().player != null && ModClientEventHandler.OPEN_BACKPACK.isActiveAndMatches(InputConstants.getKey((int)event.getKeyCode(), (int)event.getScanCode())) && (slot = screen2.getSlotUnderMouse()) != null && slot.getItem().getItem() instanceof TravelersBackpackItem && slot.allowModification((Player)event.getScreen().getMinecraft().player) && slot.container instanceof Inventory) {
                ServerboundActionTagPacket.create(2, slot.getContainerSlot(), true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void clientTickEvent(ClientTickEvent.Pre event) {
        block11: {
            LocalPlayer player;
            block10: {
                ItemStack heldItem;
                player = Minecraft.getInstance().player;
                if (player == null) {
                    return;
                }
                if (player.getMainHandItem().getItem() instanceof HoseItem && player.getMainHandItem().has(ModDataComponents.HOSE_MODES)) {
                    while (ModClientEventHandler.TOGGLE_TANK.consumeClick()) {
                        ServerboundActionTagPacket.create(12, new Object[0]);
                    }
                }
                if (((Boolean)TravelersBackpackConfig.CLIENT.disableScrollWheel.get()).booleanValue() && !ToolSlotItemHandler.isValid(heldItem = player.getMainHandItem())) {
                    while (ModClientEventHandler.SWAP_TOOL.consumeClick()) {
                        if (heldItem.isEmpty() || !(heldItem.getItem() instanceof HoseItem) || !heldItem.has(ModDataComponents.HOSE_MODES)) continue;
                        ServerboundActionTagPacket.create(11, 1.0);
                    }
                }
                if (!AttachmentUtils.isWearingBackpack((Player)player)) break block10;
                while (ModClientEventHandler.OPEN_BACKPACK.consumeClick()) {
                    ServerboundActionTagPacket.create(1, new Object[0]);
                }
                while (ModClientEventHandler.ABILITY.consumeClick()) {
                    if (!BackpackAbilities.ALLOWED_ABILITIES.contains(AttachmentUtils.getWearingBackpack((Player)player).getItem())) continue;
                    boolean ability = AttachmentUtils.getBackpackWrapperArtificial((Player)player).isAbilityEnabled();
                    ServerboundActionTagPacket.create(14, !ability);
                    player.displayClientMessage((Component)Component.translatable((String)(ability ? "screen.travelersbackpack.ability_disabled" : "screen.travelersbackpack.ability_enabled")), true);
                }
                if (!((Boolean)TravelersBackpackConfig.CLIENT.disableScrollWheel.get()).booleanValue()) break block11;
                heldItem = player.getMainHandItem();
                while (ModClientEventHandler.SWAP_TOOL.consumeClick()) {
                    if (heldItem.isEmpty() || !((Boolean)TravelersBackpackConfig.CLIENT.enableToolCycling.get()).booleanValue() || !ToolSlotItemHandler.isValid(heldItem)) continue;
                    ServerboundActionTagPacket.create(6, 1.0);
                }
                break block11;
            }
            block5: while (ModClientEventHandler.OPEN_BACKPACK.consumeClick()) {
                for (int i = 0; i < player.getInventory().items.size(); ++i) {
                    ItemStack stack = (ItemStack)player.getInventory().items.get(i);
                    if (!(stack.getItem() instanceof TravelersBackpackItem)) continue;
                    ServerboundActionTagPacket.create(2, i, false);
                    continue block5;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void mouseWheelDetect(InputEvent.MouseScrollingEvent event) {
        ItemStack heldItem;
        LocalPlayer player;
        Minecraft mc = Minecraft.getInstance();
        double scrollDelta = event.getScrollDeltaY();
        if (!((Boolean)TravelersBackpackConfig.CLIENT.disableScrollWheel.get()).booleanValue() && scrollDelta != 0.0 && (player = mc.player) != null && player.isAlive() && ModClientEventHandler.SWAP_TOOL.isDown() && !(heldItem = player.getMainHandItem()).isEmpty()) {
            if (heldItem.getItem() instanceof HoseItem && heldItem.has(ModDataComponents.HOSE_MODES)) {
                ServerboundActionTagPacket.create(11, scrollDelta);
                event.setCanceled(true);
            }
            if (AttachmentUtils.isWearingBackpack((Player)player) && ((Boolean)TravelersBackpackConfig.CLIENT.enableToolCycling.get()).booleanValue() && ToolSlotItemHandler.isValid(heldItem)) {
                ServerboundActionTagPacket.create(6, scrollDelta);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterClientCommandsEvent event) {
        new BackpackIconCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

