/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.polymorph;

import com.illusivesoulworks.polymorph.api.client.PolymorphWidgets;
import com.illusivesoulworks.polymorph.common.PolymorphRecipeManager;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.compat.polymorph.PolymorphWidget;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ResultSlotExt;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingContainerImproved;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PolymorphCompat {
    public static boolean shouldResetRecipe(RecipeHolder<CraftingRecipe> current, BackpackBaseMenu menu, CraftingContainerImproved craftSlots, Level level, Player player) {
        PolymorphRecipeManager manager = new PolymorphRecipeManager();
        Optional optional = manager.getPlayerRecipe((AbstractContainerMenu)menu, RecipeType.CRAFTING, (RecipeInput)craftSlots.asCraftInput(), level, player);
        return optional.filter(craftingRecipe -> craftingRecipe != current).isPresent();
    }

    public static RecipeHolder<CraftingRecipe> getPolymorphedRecipe(BackpackBaseMenu menu, CraftingContainerImproved craftSlots, Level level, Player player) {
        PolymorphRecipeManager manager = new PolymorphRecipeManager();
        Optional optional = manager.getPlayerRecipe((AbstractContainerMenu)menu, RecipeType.CRAFTING, (RecipeInput)craftSlots.asCraftInput(), level, player);
        return optional.orElse(null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerWidget() {
        PolymorphWidgets.getInstance().registerWidget(screen -> {
            if (screen instanceof BackpackScreen) {
                BackpackScreen backpackScreen = (BackpackScreen)screen;
                for (Slot slot : ((BackpackBaseMenu)backpackScreen.getMenu()).slots) {
                    if (!(slot instanceof ResultSlotExt)) continue;
                    return new PolymorphWidget(backpackScreen, slot);
                }
            }
            return null;
        });
    }
}

