/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.emi;

import com.google.common.collect.Maps;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class DragDropHandler
implements EmiDragDropHandler<BackpackScreen> {
    private final BiFunction<BackpackScreen, EmiIngredient, Map<Bounds, Consumer<EmiIngredient>>> bounds = (screen, ingredient) -> {
        HashMap map = Maps.newHashMap();
        if (ingredient.getEmiStacks().isEmpty()) {
            return map;
        }
        EmiStack emiGhostStack = (EmiStack)ingredient.getEmiStacks().get(0);
        if (!emiGhostStack.isEmpty()) {
            ItemStack ghostStack = emiGhostStack.getItemStack();
            BackpackBaseMenu menu = (BackpackBaseMenu)screen.getMenu();
            menu.mappedSlots.values().forEach(list -> list.forEach(slot -> {
                FilterSlotItemHandler filterSlot;
                if (slot >= menu.slots.size()) {
                    return;
                }
                Slot patt0$temp = menu.getSlot((int)slot);
                if (patt0$temp instanceof FilterSlotItemHandler && (filterSlot = (FilterSlotItemHandler)patt0$temp).mayPlace(ghostStack)) {
                    map.put(new Bounds(screen.getGuiLeft() + filterSlot.x, screen.getGuiTop() + filterSlot.y, 16, 16), i -> ServerboundActionTagPacket.create(16, 0, ghostStack, menu.getSlot((int)slot.intValue()).index));
                }
            }));
        }
        return map;
    };

    public boolean dropStack(BackpackScreen backpackScreen, EmiIngredient emiIngredient, int x, int y) {
        Map<Bounds, Consumer<EmiIngredient>> bounds = this.bounds.apply(backpackScreen, emiIngredient);
        for (Bounds b : bounds.keySet()) {
            if (!b.contains(x, y)) continue;
            bounds.get(b).accept(emiIngredient);
            return true;
        }
        return false;
    }

    public void render(BackpackScreen screen, EmiIngredient dragged, GuiGraphics draw, int mouseX, int mouseY, float delta) {
        for (Bounds b : this.bounds.apply(screen, dragged).keySet()) {
            draw.fill(b.x(), b.y(), b.x() + b.width(), b.y() + b.height(), -2010989773);
        }
    }
}

