/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.craftingtweaks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.craftingtweaks.api.ButtonAlignment;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingGridBuilder;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.GridBalanceHandler;
import net.blay09.mods.craftingtweaks.api.GridTransferHandler;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BackpackCraftingGridProvider
implements CraftingGridProvider {
    public String getModId() {
        return "travelersbackpack";
    }

    public boolean requiresServerSide() {
        return true;
    }

    public boolean handles(AbstractContainerMenu menu) {
        return menu instanceof BackpackBaseMenu;
    }

    public void buildCraftingGrids(CraftingGridBuilder craftingGridBuilder, AbstractContainerMenu abstractContainerMenu) {
        if (abstractContainerMenu instanceof BackpackBaseMenu) {
            BackpackBaseMenu backpackMenu = (BackpackBaseMenu)abstractContainerMenu;
            craftingGridBuilder.addGrid(backpackMenu.CRAFTING_GRID_START, 9).setButtonAlignment(ButtonAlignment.RIGHT).clearHandler(this::clearGrid).rotateHandler(this::rotateGrid).balanceHandler((GridBalanceHandler)new BackpackBalanceGridHandler()).transferHandler((GridTransferHandler)new BackpackTransferGridHandler()).hideAllTweakButtons();
        }
    }

    public void clearGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu, boolean forced) {
        if (!(menu instanceof BackpackBaseMenu)) {
            return;
        }
        BackpackBaseMenu backpackMenu = (BackpackBaseMenu)menu;
        Optional<CraftingUpgrade> upgrade = backpackMenu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class);
        if (upgrade.isEmpty() || !upgrade.get().isTabOpened()) {
            return;
        }
        Container craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix != null) {
            int start = grid.getGridStartSlot(player, menu);
            int size = grid.getGridSize(player, menu);
            for (int i = start; i < start + size; ++i) {
                int slotIndex = ((Slot)menu.slots.get(i)).getContainerSlot();
                ItemStack itemStack = craftMatrix.getItem(slotIndex);
                if (itemStack.isEmpty()) continue;
                ItemStack returnStack = itemStack.copy();
                player.getInventory().add(returnStack);
                craftMatrix.setItem(slotIndex, returnStack.getCount() == 0 ? ItemStack.EMPTY : returnStack);
                if (returnStack.getCount() <= 0 || !forced) continue;
                player.drop(returnStack, false);
                craftMatrix.setItem(slotIndex, ItemStack.EMPTY);
            }
            menu.broadcastChanges();
        }
    }

    protected boolean ignoresSlotId(int slotId) {
        return slotId == 4;
    }

    protected int rotateSlotId(int slotId, boolean counterClockwise) {
        block21: {
            block20: {
                if (counterClockwise) break block20;
                switch (slotId) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        return 0;
                    }
                    default: {
                        break block21;
                    }
                    case 5: {
                        return 8;
                    }
                    case 6: {
                        return 3;
                    }
                    case 7: {
                        return 6;
                    }
                    case 8: {
                        return 7;
                    }
                }
            }
            switch (slotId) {
                case 0: {
                    return 3;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 6;
                }
                default: {
                    break;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 8;
                }
                case 8: {
                    return 5;
                }
            }
        }
        return 0;
    }

    public void rotateGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu, boolean reverse) {
        if (!(menu instanceof BackpackBaseMenu)) {
            return;
        }
        BackpackBaseMenu backpackMenu = (BackpackBaseMenu)menu;
        Optional<CraftingUpgrade> upgrade = backpackMenu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class);
        if (upgrade.isEmpty() || !upgrade.get().isTabOpened()) {
            return;
        }
        Container craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix != null) {
            int slotIndex;
            int i;
            int start = grid.getGridStartSlot(player, menu);
            int size = grid.getGridSize(player, menu);
            SimpleContainer matrixClone = new SimpleContainer(size);
            for (i = 0; i < size; ++i) {
                slotIndex = ((Slot)menu.slots.get(start + i)).getContainerSlot();
                matrixClone.setItem(i, craftMatrix.getItem(slotIndex));
            }
            for (i = 0; i < size; ++i) {
                if (this.ignoresSlotId(i)) continue;
                slotIndex = ((Slot)menu.slots.get(start + this.rotateSlotId(i, reverse))).getContainerSlot();
                craftMatrix.setItem(slotIndex, matrixClone.getItem(i));
            }
            menu.broadcastChanges();
        }
    }

    public static class BackpackBalanceGridHandler
    implements GridBalanceHandler<AbstractContainerMenu> {
        public void balanceGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu) {
            if (!(menu instanceof BackpackBaseMenu)) {
                return;
            }
            BackpackBaseMenu backpackMenu = (BackpackBaseMenu)menu;
            Optional<CraftingUpgrade> upgrade = backpackMenu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class);
            if (upgrade.isEmpty() || !upgrade.get().isTabOpened()) {
                return;
            }
            Container craftMatrix = grid.getCraftingMatrix(player, menu);
            if (craftMatrix != null) {
                ArrayListMultimap itemMap = ArrayListMultimap.create();
                HashMultiset itemCount = HashMultiset.create();
                int start = grid.getGridStartSlot(player, menu);
                int size = grid.getGridSize(player, menu);
                for (int i = start; i < start + size; ++i) {
                    int slotIndex = ((Slot)menu.slots.get(i)).getContainerSlot();
                    ItemStack itemStack = craftMatrix.getItem(slotIndex);
                    if (itemStack.isEmpty() || itemStack.getMaxStackSize() <= 1) continue;
                    ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
                    Object key = Objects.toString(registryName);
                    DataComponentPatch componentsPatch = itemStack.getComponentsPatch();
                    if (!componentsPatch.isEmpty()) {
                        key = (String)key + "@" + String.valueOf(componentsPatch);
                    }
                    itemMap.put(key, (Object)slotIndex);
                    itemCount.add(key, itemStack.getCount());
                }
                for (String key : itemMap.keySet()) {
                    ItemStack stack;
                    int index;
                    List balanceList = itemMap.get((Object)key);
                    int totalCount = itemCount.count((Object)key);
                    int countPerStack = totalCount / balanceList.size();
                    int restCount = totalCount % balanceList.size();
                    Iterator iterator = balanceList.iterator();
                    while (iterator.hasNext()) {
                        index = (Integer)iterator.next();
                        stack = craftMatrix.getItem(index);
                        stack.setCount(countPerStack);
                        craftMatrix.setItem(index, stack);
                    }
                    int idx = 0;
                    while (restCount > 0) {
                        index = (Integer)balanceList.get(idx);
                        stack = craftMatrix.getItem(index);
                        if (stack.getCount() < stack.getMaxStackSize()) {
                            ItemStack copy = stack.copy();
                            copy.grow(1);
                            craftMatrix.setItem(index, copy);
                            --restCount;
                        }
                        if (++idx < balanceList.size()) continue;
                        idx = 0;
                    }
                }
                menu.broadcastChanges();
            }
        }

        public void spreadGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu) {
            if (!(menu instanceof BackpackBaseMenu)) {
                return;
            }
            BackpackBaseMenu backpackMenu = (BackpackBaseMenu)menu;
            Optional<CraftingUpgrade> upgrade = backpackMenu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class);
            if (upgrade.isEmpty() || !upgrade.get().isTabOpened()) {
                return;
            }
            Container craftMatrix = grid.getCraftingMatrix(player, menu);
            if (craftMatrix != null) {
                boolean emptyBiggestSlot;
                do {
                    ItemStack itemStack;
                    int slotIndex;
                    int i;
                    ItemStack biggestSlotStack = null;
                    int biggestSlotStackSlot = 0;
                    int biggestSlotSize = 1;
                    int start = grid.getGridStartSlot(player, menu);
                    int size = grid.getGridSize(player, menu);
                    for (i = start; i < start + size; ++i) {
                        slotIndex = ((Slot)menu.slots.get(i)).getContainerSlot();
                        itemStack = craftMatrix.getItem(slotIndex);
                        if (itemStack.isEmpty() || itemStack.getCount() <= biggestSlotSize) continue;
                        biggestSlotStack = itemStack;
                        biggestSlotStackSlot = slotIndex;
                        biggestSlotSize = itemStack.getCount();
                    }
                    if (biggestSlotStack == null) {
                        return;
                    }
                    emptyBiggestSlot = false;
                    for (i = start; i < start + size; ++i) {
                        slotIndex = ((Slot)menu.slots.get(i)).getContainerSlot();
                        itemStack = craftMatrix.getItem(slotIndex);
                        if (!itemStack.isEmpty()) continue;
                        if (biggestSlotStack.getCount() > 1) {
                            ItemStack splitted = biggestSlotStack.split(1);
                            craftMatrix.setItem(biggestSlotStackSlot, biggestSlotStack);
                            craftMatrix.setItem(slotIndex, splitted);
                            continue;
                        }
                        emptyBiggestSlot = true;
                    }
                } while (emptyBiggestSlot);
                this.balanceGrid(grid, player, menu);
            }
        }
    }

    public static class BackpackTransferGridHandler
    implements GridTransferHandler<AbstractContainerMenu> {
        public ItemStack putIntoGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu, int slotId, ItemStack itemStack) {
            Container craftMatrix = grid.getCraftingMatrix(player, menu);
            if (craftMatrix == null) {
                return itemStack;
            }
            ItemStack craftStack = craftMatrix.getItem(slotId).copy();
            if (!craftStack.isEmpty()) {
                int spaceLeft;
                if (ItemStack.isSameItemSameComponents((ItemStack)craftStack, (ItemStack)itemStack) && (spaceLeft = Math.min(craftMatrix.getMaxStackSize(), craftStack.getMaxStackSize()) - craftStack.getCount()) > 0) {
                    ItemStack splitStack = itemStack.split(Math.min(spaceLeft, itemStack.getCount()));
                    craftStack.grow(splitStack.getCount());
                    craftMatrix.setItem(slotId, craftStack);
                    if (itemStack.getCount() <= 0) {
                        return ItemStack.EMPTY;
                    }
                }
            } else {
                ItemStack transferStack = itemStack.split(Math.min(itemStack.getCount(), craftMatrix.getMaxStackSize()));
                craftMatrix.setItem(slotId, transferStack);
            }
            return itemStack.getCount() <= 0 ? ItemStack.EMPTY : itemStack;
        }

        public boolean transferIntoGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu, Slot fromSlot) {
            Container craftMatrix = grid.getCraftingMatrix(player, menu);
            if (craftMatrix == null) {
                return false;
            }
            int start = grid.getGridStartSlot(player, menu);
            int size = grid.getGridSize(player, menu);
            ItemStack itemStack = fromSlot.getItem();
            if (itemStack.isEmpty()) {
                return false;
            }
            int firstEmptySlot = -1;
            for (int i = start; i < start + size; ++i) {
                int slotIndex = ((Slot)menu.slots.get(i)).getContainerSlot();
                ItemStack craftStack = craftMatrix.getItem(slotIndex).copy();
                if (!craftStack.isEmpty()) {
                    int spaceLeft;
                    if (!ItemStack.isSameItemSameComponents((ItemStack)craftStack, (ItemStack)itemStack) || (spaceLeft = Math.min(craftMatrix.getMaxStackSize(), craftStack.getMaxStackSize()) - craftStack.getCount()) <= 0) continue;
                    ItemStack splitStack = itemStack.split(Math.min(spaceLeft, itemStack.getCount()));
                    craftStack.grow(splitStack.getCount());
                    craftMatrix.setItem(slotIndex, craftStack);
                    if (itemStack.getCount() > 0) continue;
                    return true;
                }
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = slotIndex;
            }
            if (itemStack.getCount() > 0 && firstEmptySlot != -1) {
                ItemStack transferStack = itemStack.split(Math.min(itemStack.getCount(), craftMatrix.getMaxStackSize()));
                craftMatrix.setItem(firstEmptySlot, transferStack);
                return true;
            }
            return false;
        }

        public boolean canTransferFrom(Player player, AbstractContainerMenu abstractContainerMenu, Slot slot, CraftingGrid craftingGrid) {
            if (abstractContainerMenu instanceof BackpackBaseMenu) {
                BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
                Optional<CraftingUpgrade> upgrade = menu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class);
                if (upgrade.isEmpty() || !upgrade.get().isTabOpened()) {
                    return false;
                }
                if (slot.mayPickup(player)) {
                    return slot.container == player.getInventory() || slot.index < menu.BACKPACK_INV_END;
                }
            }
            return false;
        }
    }
}

