/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watervision.client.screens;

import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import me.srrapero720.watervision.WaterVision;
import me.srrapero720.watervision.WaterVisionClient;
import me.srrapero720.watervision.client.render.TextureWrapper;
import me.srrapero720.watervision.client.screens.widgets.FadeBackground;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.fml.loading.FMLLoader;
import org.watermedia.api.player.PlayerAPI;
import org.watermedia.api.player.videolan.VideoPlayer;

public class VisionScreen
extends Screen {
    private static final DateFormat FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final ResourceLocation TEXTURE = ResourceLocation.tryBuild((String)"watervision", (String)"video_texture");
    private final boolean stretch;
    private final boolean controls;
    private final boolean exit;
    private final VideoPlayer videoPlayer;
    private final TextureWrapper textureWrapper;
    private Status status = Status.OPENING_GAME;
    private final FadeBackground gameBackground;
    private final FadeBackground videoBackground;

    public VisionScreen(URI uri, int volume, float speed, boolean stretch, float gameFadeDuration, float videoFadeDuration, boolean controls, boolean exit) {
        super((Component)Component.literal((String)"WaterVision"));
        this.stretch = stretch;
        this.controls = controls;
        this.exit = exit;
        this.gameBackground = new FadeBackground(gameFadeDuration);
        this.videoBackground = new FadeBackground(videoFadeDuration);
        this.videoBackground.forceFadeIn();
        this.videoPlayer = new VideoPlayer(PlayerAPI.getFactory(), (Executor)Minecraft.getInstance());
        this.videoPlayer.setVolume(Mth.clamp((int)volume, (int)0, (int)100));
        this.videoPlayer.setSpeed(Mth.clamp((float)speed, (float)0.1f, (float)3.0f));
        this.textureWrapper = new TextureWrapper(this.videoPlayer.texture());
        Minecraft.getInstance().getTextureManager().register(TEXTURE, (AbstractTexture)this.textureWrapper);
        this.videoPlayer.startPaused(uri);
        Minecraft.getInstance().getSoundManager().pause();
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float partialTick) {
        this.gameBackground.render(guiGraphics, this.width, this.height, this.status != Status.CLOSING_GAME, partialTick);
        if (this.status == Status.OPENING_VIDEO || this.status == Status.CLOSING_VIDEO) {
            this.videoPlayer.preRender();
            if (this.stretch) {
                WaterVisionClient.internal$blit(guiGraphics, TEXTURE, 1.0f, 0, 0, 0, 0, this.width, this.height);
            } else {
                AspectRatioDimension dim = this.render$getAspectRatio(this.width, this.height, this.videoPlayer.width(), this.videoPlayer.height());
                WaterVisionClient.internal$blit(guiGraphics, TEXTURE, 1.0f, dim.x, dim.y, 0, 0, dim.width, dim.height);
            }
        }
        if (this.status != Status.OPENING_GAME && this.status != Status.CLOSING_GAME) {
            this.videoBackground.render(guiGraphics, this.width, this.height, this.status == Status.CLOSING_VIDEO, partialTick);
        }
        if (this.status == Status.OPENING_GAME || this.status == Status.CLOSING_VIDEO || this.status == Status.CLOSING_GAME || this.videoPlayer.isBuffering() || this.videoPlayer.isLoading()) {
            this.render$loadingIcon(guiGraphics, partialTick);
        }
        if (!FMLLoader.isProduction()) {
            if (!this.videoPlayer.isSafeUse()) {
                return;
            }
            guiGraphics.drawString(this.font, String.format("State: %s", this.videoPlayer.getStateName()), 0, this.height / 2 - 12, 0xFFFFFF);
            guiGraphics.drawString(this.font, String.format("Time: %s (%s) / %s (%s)", FORMAT.format(new Date(this.videoPlayer.getTime())), this.videoPlayer.getTime(), FORMAT.format(new Date(this.videoPlayer.getDuration())), this.videoPlayer.getDuration()), 0, this.height / 2, 0xFFFFFF);
            guiGraphics.drawString(this.font, String.format("Media Duration: %s (%s)", FORMAT.format(new Date(this.videoPlayer.getMediaInfoDuration())), this.videoPlayer.getMediaInfoDuration()), 0, this.height / 2 + 12, 0xFFFFFF);
            guiGraphics.drawString(this.font, String.format("Orchestrator Status: %s", this.status.name()), 0, this.height / 2 + 24, 0xFFFFFF);
            guiGraphics.drawString(this.font, String.format("Video Size: %sx%s", this.videoPlayer.width(), this.videoPlayer.height()), 0, this.height / 2 + 36, 0xFFFFFF);
        }
    }

    private void render$loadingIcon(GuiGraphics graphics, float partialTick) {
        WaterVisionClient.internal$blit(graphics, WaterVision.LOADING_ANIM_TEXTURE, 1.0f, this.width - 40, this.height - 40, 0, 0, 40, 40);
    }

    private AspectRatioDimension render$getAspectRatio(int screenWidth, int screenHeight, int videoWidth, int videoHeight) {
        int renderHeight;
        int renderWidth;
        float videoAspectRatio = (float)videoWidth / (float)videoHeight;
        float containerAspectRatio = (float)screenWidth / (float)screenHeight;
        if (videoAspectRatio > containerAspectRatio) {
            renderWidth = screenWidth;
            renderHeight = (int)((float)screenWidth / videoAspectRatio);
        } else {
            renderWidth = (int)((float)screenHeight * videoAspectRatio);
            renderHeight = screenHeight;
        }
        int offsetX = (screenWidth - renderWidth) / 2;
        int offsetY = (screenHeight - renderHeight) / 2;
        return new AspectRatioDimension(offsetX, offsetY, renderWidth, renderHeight);
    }

    public void tick() {
        switch (this.status.ordinal()) {
            case 0: {
                if (!this.gameBackground.isFadedIn() || !this.videoPlayer.isSafeUse() || !this.videoPlayer.isReady()) break;
                this.status = Status.OPENING_VIDEO;
                this.videoPlayer.play();
                break;
            }
            case 1: {
                if (!this.videoBackground.isFadedOut() || !this.videoPlayer.isEnded() && !this.videoPlayer.isStopped() && !this.videoPlayer.isBroken()) break;
                this.status = Status.CLOSING_VIDEO;
                break;
            }
            case 2: {
                if (!this.videoBackground.isFadedIn()) break;
                this.status = Status.CLOSING_GAME;
                break;
            }
            case 3: {
                if (!this.gameBackground.isFadedOut()) break;
                this.onClose();
            }
        }
    }

    public boolean shouldCloseOnEsc() {
        return this.exit;
    }

    public void onClose() {
        if (this.videoPlayer.isSafeUse() && this.videoPlayer.isPlaying()) {
            this.videoPlayer.stop();
            return;
        }
        if (this.status != Status.CLOSING_GAME) {
            return;
        }
        Minecraft.getInstance().getSoundManager().resume();
        this.videoPlayer.release();
        super.onClose();
    }

    static {
        FORMAT.setTimeZone(TimeZone.getTimeZone("GMT-00:00"));
    }

    public static enum Status {
        OPENING_GAME,
        OPENING_VIDEO,
        CLOSING_VIDEO,
        CLOSING_GAME;

    }

    public record AspectRatioDimension(int x, int y, int width, int height) {
    }
}

