/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watervision;

import java.net.URI;
import java.util.concurrent.Executor;
import me.srrapero720.watervision.WaterVisionClient;
import me.srrapero720.watervision.client.render.TextureWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPauseChangeEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import org.watermedia.api.player.PlayerAPI;
import org.watermedia.api.player.videolan.VideoPlayer;

@EventBusSubscriber(modid="watervision", value={Dist.CLIENT})
public class VisionOverlay {
    private static final int PADDING = 8;
    private static VideoPlayer player;
    private static final ResourceLocation TEXTURE;
    static URI uri;
    static URI activeUri;

    @SubscribeEvent
    public static void onClientPause(ClientPauseChangeEvent.Post e) {
        if (player != null && player.isPaused() != e.isPaused()) {
            player.setPauseMode(e.isPaused());
        }
    }

    public static void onClientDisconnect() {
        if (player != null) {
            player.release();
        }
        player = null;
        uri = null;
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post e) {
        if (uri != null && player == null) {
            player = new VideoPlayer(PlayerAPI.getFactory(), (Executor)Minecraft.getInstance());
            Minecraft.getInstance().getTextureManager().register(TEXTURE, (AbstractTexture)new TextureWrapper(player.texture()));
            player.start(uri);
            activeUri = uri;
        }
        if (player == null) {
            return;
        }
        if (player.isBroken()) {
            Minecraft.getInstance().getChatListener().handleSystemMessage((Component)Component.literal((String)"Failed to open a video overlay"), true);
            player.release();
            player = null;
            return;
        }
        if (uri == null && activeUri != null) {
            player.release();
            player = null;
            activeUri = null;
            return;
        }
        if (activeUri != uri) {
            player.start(uri);
            activeUri = uri;
        }
        if (player.isSafeUse() && player.isPlaying()) {
            player.preRender();
            GuiGraphics graphics = e.getGuiGraphics();
            int screenWidth = graphics.guiWidth();
            int screenHeight = graphics.guiHeight();
            int x = (int)((float)screenWidth / 1.6f) - 8;
            int y = (int)((float)screenHeight / 1.6f) - 8;
            int width = screenWidth - x;
            int height = screenHeight - y;
            WaterVisionClient.internal$blit(graphics, TEXTURE, 1.0f, x, y, 0, 0, width -= 8, height -= 8);
        } else if (player.isSafeUse() && player.isEnded()) {
            uri = null;
            activeUri = null;
            player.release();
            player = null;
        }
    }

    static {
        TEXTURE = ResourceLocation.tryBuild((String)"watervision", (String)"overlay_texture");
    }
}

