/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.util.platform.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.fzzyhmstrs.fzzy_config.FC;
import me.fzzyhmstrs.fzzy_config.registry.SyncedConfigRegistry;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.fzzyhmstrs.fzzy_config.util.platform.impl.PlatformUtils;
import me.fzzyhmstrs.fzzy_config.util.platform.impl.RegistrarImpl;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\tJ\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0006J\u001d\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b\u001f\u0010#J\u001d\u0010\u001f\u001a\u00020\u001e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002\u00a2\u0006\u0004\b\u001f\u0010'\u00a8\u0006("}, d2={"Lme/fzzyhmstrs/fzzy_config/util/platform/impl/PlatformUtils;", "", "<init>", "()V", "", "isClient", "()Z", "Ljava/io/File;", "configDir", "()Ljava/io/File;", "gameDir", "", "mod", "isModLoaded", "(Ljava/lang/String;)Z", "isDev", "scope", "fallback", "configName", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "", "customScopes", "()Ljava/util/List;", "Lnet/minecraft/server/level/ServerPlayer;", "player", "permission", "hasPermission", "(Lnet/minecraft/server/level/ServerPlayer;Ljava/lang/String;)Z", "Lnet/neoforged/bus/api/IEventBus;", "bus", "", "registerCommands", "(Lnet/neoforged/bus/api/IEventBus;)V", "Lnet/neoforged/neoforge/event/RegisterCommandsEvent;", "event", "(Lnet/neoforged/neoforge/event/RegisterCommandsEvent;)V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "fzzy_config"})
@SourceDebugExtension(value={"SMAP\nPlatformUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformUtils.kt\nme/fzzyhmstrs/fzzy_config/util/platform/impl/PlatformUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1#2:159\n295#3,2:160\n*S KotlinDebug\n*F\n+ 1 PlatformUtils.kt\nme/fzzyhmstrs/fzzy_config/util/platform/impl/PlatformUtils\n*L\n88#1:160,2\n*E\n"})
public final class PlatformUtils {
    @NotNull
    public static final PlatformUtils INSTANCE = new PlatformUtils();

    private PlatformUtils() {
    }

    public final boolean isClient() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    @NotNull
    public final File configDir() {
        File file = FMLPaths.CONFIGDIR.get().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    @NotNull
    public final File gameDir() {
        File file = FMLPaths.GAMEDIR.get().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    public final boolean isModLoaded(@NotNull String mod) {
        Intrinsics.checkNotNullParameter((Object)mod, (String)"mod");
        return ModList.get().isLoaded(mod);
    }

    public final boolean isDev() {
        return !FMLEnvironment.production;
    }

    @NotNull
    public final String configName(@NotNull String scope, @NotNull String fallback) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        String string = ModList.get().getModContainerById(scope).map(arg_0 -> PlatformUtils.configName$lambda$0(configName.1.INSTANCE, arg_0)).orElse(fallback);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"orElse(...)");
        return string;
    }

    @NotNull
    public final List<String> customScopes() {
        List list = new ArrayList();
        for (IModInfo container : ModList.get().getMods()) {
            Map map;
            Map map1;
            Map map2;
            Map it = map2 = container.getModProperties();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Map map3 = map1 = !it.isEmpty() ? map2 : null;
            if (map1 != null) {
                map = map1;
            } else {
                String[] stringArray = new String[]{"modproperties"};
                Map map22 = container.getConfig().getConfigElement(stringArray).orElse(MapsKt.emptyMap());
                Intrinsics.checkNotNull((Object)map22);
                if (!map22.isEmpty()) {
                    FC.INSTANCE.getLOGGER$fzzy_config().error("Mod " + container.getModId() + " uses outdated modproperties format. See https://github.com/fzzyhmstrs/fconfig/blob/master/wiki/config-design/Troubleshooting.mdx for proper 1.21.1+ syntax");
                }
                map = map22;
            }
            Map map4 = map;
            Object customValue = map4.get("fzzy_config");
            if (customValue instanceof String) {
                list.add(customValue);
                continue;
            }
            if (!(customValue instanceof List)) continue;
            for (Object value : (List)customValue) {
                if (!(value instanceof String)) continue;
                list.add(value);
            }
        }
        return list;
    }

    public final boolean hasPermission(@NotNull ServerPlayer player, @NotNull String permission) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            Collection collection = PermissionAPI.getRegisteredNodes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredNodes(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PermissionNode it = (PermissionNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getNodeName(), (Object)permission)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        PermissionNode permissionNode = v1;
        if (permissionNode == null) {
            return false;
        }
        PermissionNode node = permissionNode;
        return Intrinsics.areEqual((Object)PermissionAPI.getPermission((ServerPlayer)player, (PermissionNode)node, (PermissionDynamicContext[])new PermissionDynamicContext[0]), (Object)true);
    }

    public final void registerCommands(@NotNull IEventBus bus) {
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        RegistrarImpl.Companion.resolveUnbound$fzzy_config(bus);
        NeoForge.EVENT_BUS.addListener(PlatformUtils::registerCommands$lambda$3);
    }

    private final void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher commandDispatcher = event.getDispatcher();
        Intrinsics.checkNotNullExpressionValue((Object)commandDispatcher, (String)"getDispatcher(...)");
        this.registerCommands((CommandDispatcher<CommandSourceStack>)commandDispatcher);
    }

    private final void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"configure_update").requires(PlatformUtils::registerCommands$lambda$4)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"id", (ArgumentType)((ArgumentType)StringArgumentType.string())).then(Commands.literal((String)"list").executes(PlatformUtils::registerCommands$lambda$6))).then(Commands.literal((String)"inspect").executes(PlatformUtils::registerCommands$lambda$9))).then(Commands.literal((String)"accept").executes(PlatformUtils::registerCommands$lambda$11))).then(Commands.literal((String)"reject").executes(PlatformUtils::registerCommands$lambda$13))));
    }

    private static final String configName$lambda$0(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void registerCommands$lambda$3(RegisterCommandsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        INSTANCE.registerCommands(event);
    }

    private static final boolean registerCommands$lambda$4(CommandSourceStack source) {
        return source.hasPermission(3);
    }

    private static final void registerCommands$lambda$6$lambda$5(CommandContext $context, Component message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ((CommandSourceStack)$context.getSource()).sendSystemMessage(message);
    }

    private static final int registerCommands$lambda$6(CommandContext context) {
        SyncedConfigRegistry.INSTANCE.listQuarantines$fzzy_config(arg_0 -> PlatformUtils.registerCommands$lambda$6$lambda$5(context, arg_0));
        return 1;
    }

    private static final Component registerCommands$lambda$9$lambda$7(CommandContext $context, UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        ServerPlayer serverPlayer = ((CommandSourceStack)$context.getSource()).getServer().getPlayerList().getPlayer(uuid);
        return serverPlayer != null ? serverPlayer.getName() : null;
    }

    private static final void registerCommands$lambda$9$lambda$8(CommandContext $context, Component message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ((CommandSourceStack)$context.getSource()).sendSystemMessage(message);
    }

    private static final int registerCommands$lambda$9(CommandContext context) {
        String id = StringArgumentType.getString((CommandContext)context, (String)"id");
        if (id == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)FcText.INSTANCE.translate("fc.command.error.no_id", new Object[0]));
            return 0;
        }
        SyncedConfigRegistry.INSTANCE.inspectQuarantine$fzzy_config(id, arg_0 -> PlatformUtils.registerCommands$lambda$9$lambda$7(context, arg_0), arg_0 -> PlatformUtils.registerCommands$lambda$9$lambda$8(context, arg_0));
        return 1;
    }

    private static final Component registerCommands$lambda$11$lambda$10(String $id) {
        Object[] objectArray = new Object[]{$id};
        return (Component)FcText.INSTANCE.translate("fc.command.accepted", objectArray);
    }

    private static final int registerCommands$lambda$11(CommandContext context) {
        String id = StringArgumentType.getString((CommandContext)context, (String)"id");
        if (id == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)FcText.INSTANCE.translate("fc.command.error.no_id", new Object[0]));
            return 0;
        }
        MinecraftServer minecraftServer = ((CommandSourceStack)context.getSource()).getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        SyncedConfigRegistry.INSTANCE.acceptQuarantine$fzzy_config(id, minecraftServer);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> PlatformUtils.registerCommands$lambda$11$lambda$10(id), true);
        return 1;
    }

    private static final Component registerCommands$lambda$13$lambda$12(String $id) {
        Object[] objectArray = new Object[]{$id};
        return (Component)FcText.INSTANCE.translate("fc.command.rejected", objectArray);
    }

    private static final int registerCommands$lambda$13(CommandContext context) {
        String id = StringArgumentType.getString((CommandContext)context, (String)"id");
        if (id == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)FcText.INSTANCE.translate("fc.command.error.no_id", new Object[0]));
            return 0;
        }
        SyncedConfigRegistry.INSTANCE.rejectQuarantine$fzzy_config(id);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> PlatformUtils.registerCommands$lambda$13$lambda$12(id), true);
        return 1;
    }
}

