/*
 * Decompiled with CFR 0.152.
 */
package betterdays.wrappers;

import betterdays.BetterDays;
import betterdays.time.SleepStatus;
import betterdays.utils.ReflectionUtil;
import betterdays.wrappers.ServerPlayerWrapper;
import betterdays.wrappers.Wrapper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.ServerLevelData;

public class ServerLevelWrapper
extends Wrapper<ServerLevel> {
    private static final Class<ServerLevel> levelClass = ServerLevel.class;
    private static final Class<ServerLevelData> levelDataClass = ServerLevelData.class;
    private static final Class<DerivedLevelData> derivedLevelDataClass = DerivedLevelData.class;
    public final ServerLevelData levelData = levelDataClass.cast(((ServerLevel)this.get()).getLevelData());

    public ServerLevelWrapper(LevelAccessor level) {
        super(levelClass.cast(level));
    }

    public boolean daylightRuleEnabled() {
        return ((ServerLevel)this.get()).getGameRules().getBoolean(GameRules.RULE_DAYLIGHT);
    }

    public boolean weatherRuleEnabled() {
        return ((ServerLevel)this.get()).getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE);
    }

    public void setRandomTickSpeed(int speed) {
        ((GameRules.IntegerValue)((ServerLevel)this.get()).getGameRules().getRule(GameRules.RULE_RANDOMTICKING)).set(speed, ((ServerLevel)this.get()).getServer());
    }

    public boolean weatherCycleEnabled() {
        return this.weatherRuleEnabled() && ((ServerLevel)this.get()).dimensionType().hasSkyLight();
    }

    public void stopWeather() {
        this.levelData.setRainTime(0);
        this.levelData.setRaining(false);
        this.levelData.setThunderTime(0);
        this.levelData.setThundering(false);
    }

    public void setSleepStatus(SleepStatus newStatus) {
        try {
            Field sleepStatus = ReflectionUtil.findField(ServerLevel.class, "sleepStatus");
            sleepStatus.set(this.get(), (Object)newStatus);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            BetterDays.LOGGER.error("Error settings sleep status.", (Throwable)e);
        }
    }

    public void wakeUpAllPlayers() {
        ((ServerLevel)this.get()).players().stream().map(player -> new ServerPlayerWrapper((Player)player)).filter(ServerPlayerWrapper::isSleeping).forEach(player -> ((ServerPlayer)player.get()).stopSleepInBed(false, false));
    }

    public void tickBlockEntities() {
        try {
            Method tickBlockEntitiesMethod = ReflectionUtil.findMethod(Level.class, "tickBlockEntities", new Class[0]);
            tickBlockEntitiesMethod.invoke(this.get(), new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            BetterDays.LOGGER.error("Error ticking block entities.", (Throwable)e);
        }
    }

    public static boolean isDerived(LevelAccessor level) {
        return level != null && level.getLevelData().getClass() == derivedLevelDataClass;
    }

    public static boolean isServerLevel(LevelAccessor level) {
        return level != null && level.getClass() == levelClass;
    }
}

