/*
 * Decompiled with CFR 0.152.
 */
package betterdays.time;

import betterdays.wrappers.ServerPlayerWrapper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;

public class SleepStatus
extends net.minecraft.server.players.SleepStatus {
    protected int activePlayerCount;
    protected int sleepingPlayerCount;
    protected Supplier<Boolean> preventSleepSupplier;

    public SleepStatus(Supplier<Boolean> preventSleepSupplier) {
        this.preventSleepSupplier = preventSleepSupplier;
    }

    public void removeAllSleepers() {
        this.sleepingPlayerCount = 0;
    }

    public int amountSleeping() {
        return this.sleepingPlayerCount;
    }

    public int amountActive() {
        return this.activePlayerCount;
    }

    public boolean allAwake() {
        return this.sleepingPlayerCount == 0;
    }

    public boolean allAsleep() {
        return this.sleepingPlayerCount == this.activePlayerCount;
    }

    public double ratio() {
        return (double)this.sleepingPlayerCount / (double)this.activePlayerCount;
    }

    public int percentage() {
        return (int)(this.ratio() * 100.0);
    }

    public void updatePlayerCounts(List<ServerPlayer> playerList) {
        this.activePlayerCount = 0;
        this.sleepingPlayerCount = 0;
        for (ServerPlayer player : playerList) {
            if (player.isSpectator()) continue;
            ++this.activePlayerCount;
            if (!player.isSleeping()) continue;
            ++this.sleepingPlayerCount;
        }
    }

    public int sleepersNeeded(int percentageRequired) {
        return Math.max(1, (int)Math.ceil((double)(this.activePlayerCount * percentageRequired) / 100.0));
    }

    public boolean areEnoughSleeping(int percentageRequired) {
        if (this.preventSleepSupplier.get().booleanValue()) {
            return false;
        }
        return this.sleepingPlayerCount >= this.sleepersNeeded(percentageRequired);
    }

    public boolean areEnoughDeepSleeping(int percentageRequired, List<ServerPlayer> playerList) {
        if (this.preventSleepSupplier.get().booleanValue()) {
            return false;
        }
        long deepSleepers = playerList.stream().map(ServerPlayerWrapper::new).filter(ServerPlayerWrapper::isSleepingLongEnough).count();
        return deepSleepers >= (long)this.sleepersNeeded(percentageRequired);
    }

    public boolean update(List<ServerPlayer> playerList) {
        int oldActiveCount = this.activePlayerCount;
        int oldSleepingCount = this.sleepingPlayerCount;
        this.updatePlayerCounts(playerList);
        if (this.preventSleepSupplier.get().booleanValue()) {
            return false;
        }
        boolean noSleepers = oldSleepingCount == 0 && this.sleepingPlayerCount == 0;
        boolean valueChanged = oldActiveCount != this.activePlayerCount || oldSleepingCount != this.sleepingPlayerCount;
        return !noSleepers && valueChanged;
    }
}

