/*
 * Decompiled with CFR 0.152.
 */
package com.ilexiconn.llibrary.client.model.tools;

import com.bobmowzie.mowziesmobs.client.model.tools.MathUtils;
import com.bobmowzie.mowziesmobs.client.render.MowzieRenderUtils;
import com.ilexiconn.llibrary.client.model.tools.AdvancedModelBase;
import com.ilexiconn.llibrary.client.model.tools.BasicModelBase;
import com.ilexiconn.llibrary.client.model.tools.BasicModelRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import net.minecraft.client.model.Model;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class AdvancedModelRenderer
extends BasicModelRenderer {
    private static final float MINIMUM_SCALE = 1.0E-6f;
    public float defaultRotationX;
    public float defaultRotationY;
    public float defaultRotationZ;
    public float defaultPositionX;
    public float defaultPositionY;
    public float defaultPositionZ;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public float opacity = 1.0f;
    public boolean scaleChildren;
    private final Model model;
    private AdvancedModelRenderer parent;
    private boolean doubleSided = true;
    private boolean hasLighting = true;
    private boolean isHidden = false;
    public ObjectList<ModelBox> cubeList;
    public ObjectList<BasicModelRenderer> childModels;
    public int textureOffsetX;
    public int textureOffsetY;
    private float textureWidth;
    private float textureHeight;
    private Matrix3f mat3Override;
    private Matrix4f mat4Override;

    public AdvancedModelRenderer(BasicModelBase model) {
        this(model, 0, 0);
    }

    public AdvancedModelRenderer(BasicModelBase model, int textureOffsetX, int textureOffsetY) {
        super(model, textureOffsetX, textureOffsetY);
        this.model = model;
        this.textureWidth = model.textureWidth;
        this.textureHeight = model.textureHeight;
        this.textureOffsetX = textureOffsetX;
        this.textureOffsetY = textureOffsetY;
        this.cubeList = new ObjectArrayList();
        this.childModels = new ObjectArrayList();
    }

    public AdvancedModelRenderer(AdvancedModelRenderer copyFrom) {
        this(copyFrom.getAdvancedModel(), copyFrom.textureOffsetX, copyFrom.textureOffsetY);
        this.rotationPointX = copyFrom.rotationPointX;
        this.rotationPointY = copyFrom.rotationPointY;
        this.rotationPointZ = copyFrom.rotationPointZ;
        this.rotateAngleX = copyFrom.rotateAngleX;
        this.rotateAngleY = copyFrom.rotateAngleY;
        this.rotateAngleZ = copyFrom.rotateAngleZ;
        this.scaleX = copyFrom.scaleX;
        this.scaleY = copyFrom.scaleY;
        this.scaleZ = copyFrom.scaleZ;
        this.defaultPositionX = copyFrom.defaultPositionX;
        this.defaultPositionY = copyFrom.defaultPositionY;
        this.defaultPositionZ = copyFrom.defaultPositionZ;
        this.defaultRotationX = copyFrom.defaultRotationX;
        this.defaultRotationY = copyFrom.defaultRotationY;
        this.defaultRotationZ = copyFrom.defaultRotationZ;
        this.scaleChildren = copyFrom.scaleChildren;
        this.cubeList.addAll(copyFrom.cubeList);
        this.childModels = copyFrom.childModels;
    }

    @Override
    public BasicModelRenderer setTextureSize(int textureWidthIn, int textureHeightIn) {
        this.textureWidth = textureWidthIn;
        this.textureHeight = textureHeightIn;
        return super.setTextureSize(textureWidthIn, textureHeightIn);
    }

    @Override
    public BasicModelRenderer setTextureOffset(int x, int y) {
        this.textureOffsetX = x;
        this.textureOffsetY = y;
        return super.setTextureOffset(x, y);
    }

    @Override
    public AdvancedModelRenderer addBox(String partName, float x, float y, float z, int width, int height, int depth, float delta, int texX, int texY) {
        this.setTextureSize(texX, texY);
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, delta, delta, this.mirror, false);
        return this;
    }

    @Override
    public AdvancedModelRenderer addBox(float x, float y, float z, float width, float height, float depth) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, 0.0f, 0.0f, 0.0f, this.mirror, false);
        return this;
    }

    @Override
    public AdvancedModelRenderer addBox(float x, float y, float z, float width, float height, float depth, boolean mirrorIn) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, 0.0f, 0.0f, 0.0f, mirrorIn, false);
        return this;
    }

    @Override
    public void addBox(float x, float y, float z, float width, float height, float depth, float delta) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, delta, delta, this.mirror, false);
    }

    @Override
    public void addBox(float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, this.mirror, false);
    }

    @Override
    public void addBox(float x, float y, float z, float width, float height, float depth, float delta, boolean mirrorIn) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, delta, delta, mirrorIn, false);
    }

    private void addBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirror, boolean p_228305_13_) {
        this.cubeList.add((Object)new ModelBox(texOffX, texOffY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, mirror, this.textureWidth, this.textureHeight));
    }

    public void setShouldScaleChildren(boolean scaleChildren) {
        this.scaleChildren = scaleChildren;
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
        this.setScaleZ(scaleZ);
    }

    public void setScale(float scale) {
        this.setScaleX(scale);
        this.setScaleY(scale);
        this.setScaleZ(scale);
    }

    public void setScaleX(float scaleX) {
        this.scaleX = Math.max(1.0E-6f, scaleX);
    }

    public void setScaleY(float scaleY) {
        this.scaleY = Math.max(1.0E-6f, scaleY);
    }

    public void setScaleZ(float scaleZ) {
        this.scaleZ = Math.max(1.0E-6f, scaleZ);
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public void setHasLighting(boolean hasLighting) {
        this.hasLighting = hasLighting;
    }

    public void setDoubleSided(boolean doubleSided) {
        this.doubleSided = doubleSided;
    }

    public void setIsHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public float getTextureWidth() {
        return this.textureWidth;
    }

    public float getTextureHeight() {
        return this.textureHeight;
    }

    public void updateDefaultPose() {
        this.defaultRotationX = this.rotateAngleX;
        this.defaultRotationY = this.rotateAngleY;
        this.defaultRotationZ = this.rotateAngleZ;
        this.defaultPositionX = this.rotationPointX;
        this.defaultPositionY = this.rotationPointY;
        this.defaultPositionZ = this.rotationPointZ;
    }

    public void resetToDefaultPose() {
        this.rotateAngleX = this.defaultRotationX;
        this.rotateAngleY = this.defaultRotationY;
        this.rotateAngleZ = this.defaultRotationZ;
        this.rotationPointX = this.defaultPositionX;
        this.rotationPointY = this.defaultPositionY;
        this.rotationPointZ = this.defaultPositionZ;
    }

    @Override
    public void addChild(BasicModelRenderer renderer) {
        super.addChild(renderer);
        this.childModels.add((Object)renderer);
        if (renderer instanceof AdvancedModelRenderer) {
            AdvancedModelRenderer advancedChild = (AdvancedModelRenderer)renderer;
            advancedChild.setParent(this);
        }
    }

    public AdvancedModelRenderer getParent() {
        return this.parent;
    }

    public void setParent(AdvancedModelRenderer parent) {
        this.parent = parent;
    }

    @Override
    public void translateRotate(PoseStack matrixStackIn) {
        AdvancedModelRenderer parent = this.getParent();
        if (parent != null && !parent.scaleChildren) {
            matrixStackIn.scale(1.0f / parent.scaleX, 1.0f / parent.scaleY, 1.0f / parent.scaleZ);
        }
        super.translateRotate(matrixStackIn);
        matrixStackIn.scale(this.scaleX, this.scaleY, this.scaleZ);
    }

    @Override
    public void render(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        if (!(!this.showModel || this.cubeList.isEmpty() && this.childModels.isEmpty())) {
            matrixStackIn.pushPose();
            this.translateRotate(matrixStackIn);
            if (!this.isHidden) {
                if (this.opacity < 1.0f) {
                    float alpha = (float)FastColor.ARGB32.alpha((int)color) / 255.0f * this.opacity;
                    float red = (float)FastColor.ARGB32.red((int)color) / 255.0f;
                    float green = (float)FastColor.ARGB32.green((int)color) / 255.0f;
                    float blue = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
                    color = FastColor.ARGB32.colorFromFloat((float)alpha, (float)red, (float)green, (float)blue);
                }
                this.doRender(matrixStackIn.last(), bufferIn, packedLightIn, packedOverlayIn, color);
            }
            for (BasicModelRenderer modelrenderer : this.childModels) {
                modelrenderer.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
            }
            matrixStackIn.popPose();
        }
    }

    protected void doRender(PoseStack.Pose matrixEntryIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        Matrix4f matrix4f = matrixEntryIn.pose();
        Matrix3f matrix3f = matrixEntryIn.normal();
        if (this.mat3Override != null) {
            matrix3f = this.mat3Override;
        }
        if (this.mat4Override != null) {
            matrix4f = this.mat4Override;
        }
        for (ModelPart modelrenderer$modelbox : this.cubeList) {
            modelrenderer$modelbox.render(matrix4f, matrix3f, bufferIn, packedLightIn, packedOverlayIn, color);
        }
    }

    public AdvancedModelBase getAdvancedModel() {
        return (AdvancedModelBase)this.model;
    }

    private float calculateRotation(float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        float movementScale = this.model instanceof AdvancedModelBase ? ((AdvancedModelBase)this.model).getMovementScale() : 1.0f;
        float rotation = Mth.cos((float)(f * (speed * movementScale) + offset)) * (degree * movementScale) * f1 + weight * f1;
        return invert ? -rotation : rotation;
    }

    public void walk(float speed, float degree, boolean invert, float offset, float weight, float walk, float walkAmount) {
        this.rotateAngleX += this.calculateRotation(speed, degree, invert, offset, weight, walk, walkAmount);
    }

    public void flap(float speed, float degree, boolean invert, float offset, float weight, float flap, float flapAmount) {
        this.rotateAngleZ += this.calculateRotation(speed, degree, invert, offset, weight, flap, flapAmount);
    }

    public void swing(float speed, float degree, boolean invert, float offset, float weight, float swing, float swingAmount) {
        this.rotateAngleY += this.calculateRotation(speed, degree, invert, offset, weight, swing, swingAmount);
    }

    public void bob(float speed, float degree, boolean bounce, float f, float f1) {
        float movementScale = this.model instanceof AdvancedModelBase ? ((AdvancedModelBase)this.model).getMovementScale() : 1.0f;
        float bob = (float)(Math.sin(f * (speed *= movementScale)) * (double)f1 * (double)(degree *= movementScale) - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(Math.sin(f * speed) * (double)f1 * (double)degree));
        }
        this.rotationPointY += bob;
    }

    public void transitionTo(AdvancedModelRenderer to, float timer, float maxTime) {
        this.rotateAngleX += (to.rotateAngleX - this.rotateAngleX) / maxTime * timer;
        this.rotateAngleY += (to.rotateAngleY - this.rotateAngleY) / maxTime * timer;
        this.rotateAngleZ += (to.rotateAngleZ - this.rotateAngleZ) / maxTime * timer;
        this.rotationPointX += (to.rotationPointX - this.rotationPointX) / maxTime * timer;
        this.rotationPointY += (to.rotationPointY - this.rotationPointY) / maxTime * timer;
        this.rotationPointZ += (to.rotationPointZ - this.rotationPointZ) / maxTime * timer;
    }

    public void setMatrixOverrides(Matrix3f mat3Override, Matrix4f mat4Override) {
        this.mat4Override = mat4Override;
        this.mat3Override = mat3Override;
    }

    public void clearMatrixOverrides() {
        this.mat3Override = null;
        this.mat4Override = null;
    }

    public void getMatrixStack(PoseStack matrixStack) {
        AdvancedModelRenderer parent = this.getParent();
        if (parent != null) {
            parent.getMatrixStack(matrixStack);
        }
        this.translateRotate(matrixStack);
    }

    public Vec3 getWorldPos(Entity entity, float delta) {
        PoseStack matrixStack = new PoseStack();
        float dx = (float)(entity.xOld + (entity.getX() - entity.xOld) * (double)delta);
        float dy = (float)(entity.yOld + (entity.getY() - entity.yOld) * (double)delta);
        float dz = (float)(entity.zOld + (entity.getZ() - entity.zOld) * (double)delta);
        matrixStack.translate(dx, dy, dz);
        float dYaw = Mth.rotLerp((float)delta, (float)entity.yRotO, (float)entity.getYRot());
        matrixStack.mulPose(MathUtils.quatFromRotationXYZ(0.0f, -dYaw + 180.0f, 0.0f, true));
        matrixStack.scale(-1.0f, -1.0f, 1.0f);
        matrixStack.translate(0.0f, -1.5f, 0.0f);
        MowzieRenderUtils.matrixStackFromModel(matrixStack, this);
        PoseStack.Pose matrixEntry = matrixStack.last();
        Matrix4f matrix4f = matrixEntry.pose();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.mul((Matrix4fc)matrix4f);
        return new Vec3((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    public void setWorldPos(Entity entity, Vec3 worldPos, float delta) {
        PoseStack matrixStack = new PoseStack();
        float dx = (float)(entity.xOld + (entity.getX() - entity.xOld) * (double)delta);
        float dy = (float)(entity.yOld + (entity.getY() - entity.yOld) * (double)delta);
        float dz = (float)(entity.zOld + (entity.getZ() - entity.zOld) * (double)delta);
        matrixStack.translate(dx, dy, dz);
        float dYaw = Mth.rotLerp((float)delta, (float)entity.yRotO, (float)entity.getYRot());
        matrixStack.mulPose(MathUtils.quatFromRotationXYZ(0.0f, -dYaw + 180.0f, 0.0f, true));
        matrixStack.scale(-1.0f, -1.0f, 1.0f);
        matrixStack.translate(0.0f, -1.5f, 0.0f);
        PoseStack.Pose matrixEntry = matrixStack.last();
        Matrix4f matrix4f = matrixEntry.pose();
        matrix4f.invert();
        Vector4f vec = new Vector4f((float)worldPos.x(), (float)worldPos.y(), (float)worldPos.z(), 1.0f);
        vec.mul((Matrix4fc)matrix4f);
        this.rotationPointX = vec.x() * 16.0f;
        this.rotationPointY = vec.y() * 16.0f;
        this.rotationPointZ = vec.z() * 16.0f;
    }

    public static class ModelBox
    extends ModelPart {
        protected final TexturedQuad[] quads;
        public final float posX1;
        public final float posY1;
        public final float posZ1;
        public final float posX2;
        public final float posY2;
        public final float posZ2;

        public ModelBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirror, float texWidth, float texHeight) {
            this.posX1 = x;
            this.posY1 = y;
            this.posZ1 = z;
            this.posX2 = x + width;
            this.posY2 = y + height;
            this.posZ2 = z + depth;
            this.quads = new TexturedQuad[6];
            float f = x + width;
            float f1 = y + height;
            float f2 = z + depth;
            x -= deltaX;
            y -= deltaY;
            z -= deltaZ;
            f += deltaX;
            f1 += deltaY;
            f2 += deltaZ;
            if (mirror) {
                float f3 = f;
                f = x;
                x = f3;
            }
            PositionTextureVertex modelrenderer$positiontexturevertex7 = new PositionTextureVertex(x, y, z, 0.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex = new PositionTextureVertex(f, y, z, 0.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex1 = new PositionTextureVertex(f, f1, z, 8.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex2 = new PositionTextureVertex(x, f1, z, 8.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex3 = new PositionTextureVertex(x, y, f2, 0.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex4 = new PositionTextureVertex(f, y, f2, 0.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex5 = new PositionTextureVertex(f, f1, f2, 8.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex6 = new PositionTextureVertex(x, f1, f2, 8.0f, 0.0f);
            float f4 = texOffX;
            float f5 = (float)texOffX + depth;
            float f6 = (float)texOffX + depth + width;
            float f7 = (float)texOffX + depth + width + width;
            float f8 = (float)texOffX + depth + width + depth;
            float f9 = (float)texOffX + depth + width + depth + width;
            float f10 = texOffY;
            float f11 = (float)texOffY + depth;
            float f12 = (float)texOffY + depth + height;
            this.quads[2] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex4, modelrenderer$positiontexturevertex3, modelrenderer$positiontexturevertex7, modelrenderer$positiontexturevertex}, f5, f10, f6, f11, texWidth, texHeight, mirror, Direction.DOWN);
            this.quads[3] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex1, modelrenderer$positiontexturevertex2, modelrenderer$positiontexturevertex6, modelrenderer$positiontexturevertex5}, f6, f11, f7, f10, texWidth, texHeight, mirror, Direction.UP);
            this.quads[1] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex7, modelrenderer$positiontexturevertex3, modelrenderer$positiontexturevertex6, modelrenderer$positiontexturevertex2}, f4, f11, f5, f12, texWidth, texHeight, mirror, Direction.WEST);
            this.quads[4] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex, modelrenderer$positiontexturevertex7, modelrenderer$positiontexturevertex2, modelrenderer$positiontexturevertex1}, f5, f11, f6, f12, texWidth, texHeight, mirror, Direction.NORTH);
            this.quads[0] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex4, modelrenderer$positiontexturevertex, modelrenderer$positiontexturevertex1, modelrenderer$positiontexturevertex5}, f6, f11, f8, f12, texWidth, texHeight, mirror, Direction.EAST);
            this.quads[5] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex3, modelrenderer$positiontexturevertex4, modelrenderer$positiontexturevertex5, modelrenderer$positiontexturevertex6}, f8, f11, f9, f12, texWidth, texHeight, mirror, Direction.SOUTH);
        }

        @Override
        public void render(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
            for (TexturedQuad modelrenderer$texturedquad : this.quads) {
                Vector3f vector3f = new Vector3f((Vector3fc)modelrenderer$texturedquad.normal);
                vector3f.mul((Matrix3fc)matrix3f);
                float f = vector3f.x();
                float f1 = vector3f.y();
                float f2 = vector3f.z();
                for (int i = 0; i < 4; ++i) {
                    PositionTextureVertex modelrenderer$positiontexturevertex = modelrenderer$texturedquad.vertexPositions[i];
                    float f3 = modelrenderer$positiontexturevertex.position.x() / 16.0f;
                    float f4 = modelrenderer$positiontexturevertex.position.y() / 16.0f;
                    float f5 = modelrenderer$positiontexturevertex.position.z() / 16.0f;
                    Vector4f vector4f = new Vector4f(f3, f4, f5, 1.0f);
                    vector4f.mul((Matrix4fc)matrix4f);
                    bufferIn.addVertex(vector4f.x(), vector4f.y(), vector4f.z(), color, modelrenderer$positiontexturevertex.textureU, modelrenderer$positiontexturevertex.textureV, packedOverlayIn, packedLightIn, f, f1, f2);
                }
            }
        }
    }

    public static abstract class ModelPart {
        public void render(Matrix4f mat4, Matrix3f mat3, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        }
    }

    static class TexturedQuad {
        public final PositionTextureVertex[] vertexPositions;
        public final Vector3f normal;

        public TexturedQuad(PositionTextureVertex[] positionsIn, float u1, float v1, float u2, float v2, float texWidth, float texHeight, boolean mirrorIn, Direction directionIn) {
            this.vertexPositions = positionsIn;
            float f = 0.0f / texWidth;
            float f1 = 0.0f / texHeight;
            positionsIn[0] = positionsIn[0].setTextureUV(u2 / texWidth - f, v1 / texHeight + f1);
            positionsIn[1] = positionsIn[1].setTextureUV(u1 / texWidth + f, v1 / texHeight + f1);
            positionsIn[2] = positionsIn[2].setTextureUV(u1 / texWidth + f, v2 / texHeight - f1);
            positionsIn[3] = positionsIn[3].setTextureUV(u2 / texWidth - f, v2 / texHeight - f1);
            if (mirrorIn) {
                int i = positionsIn.length;
                for (int j = 0; j < i / 2; ++j) {
                    PositionTextureVertex modelrenderer$positiontexturevertex = positionsIn[j];
                    positionsIn[j] = positionsIn[i - 1 - j];
                    positionsIn[i - 1 - j] = modelrenderer$positiontexturevertex;
                }
            }
            this.normal = directionIn.step();
            if (mirrorIn) {
                this.normal.mul(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    static class PositionTextureVertex {
        public final Vector3f position;
        public final float textureU;
        public final float textureV;

        public PositionTextureVertex(float x, float y, float z, float texU, float texV) {
            this(new Vector3f(x, y, z), texU, texV);
        }

        public PositionTextureVertex setTextureUV(float texU, float texV) {
            return new PositionTextureVertex(this.position, texU, texV);
        }

        public PositionTextureVertex(Vector3f posIn, float texU, float texV) {
            this.position = posIn;
            this.textureU = texU;
            this.textureV = texV;
        }
    }
}

