/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure.processor;

import com.bobmowzie.mowziesmobs.server.world.feature.structure.processor.ProcessorHandler;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BaseDecoProcessor
extends StructureProcessor {
    public static final BaseDecoProcessor INSTANCE = new BaseDecoProcessor();
    public static final MapCodec<BaseDecoProcessor> CODEC = MapCodec.unit(() -> INSTANCE);
    private static final BlockState trapDoorBottom = Blocks.DARK_OAK_TRAPDOOR.defaultBlockState();
    private static final BlockState trapDoorTop = (BlockState)Blocks.DARK_OAK_TRAPDOOR.defaultBlockState().setValue((Property)TrapDoorBlock.HALF, (Comparable)Half.TOP);
    private static final BlockState slabBottom = Blocks.DARK_OAK_SLAB.defaultBlockState();
    private static final BlockState slabTop = (BlockState)Blocks.DARK_OAK_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP);
    private static final BlockState woodStairs = (BlockState)Blocks.DARK_OAK_STAIRS.defaultBlockState().setValue((Property)StairBlock.HALF, (Comparable)Half.TOP);
    private static final BlockState wall = Blocks.DEEPSLATE_BRICK_WALL.defaultBlockState();
    private static final BlockState button = Blocks.DARK_OAK_BUTTON.defaultBlockState();
    private static final BlockState stoneStairs = Blocks.COBBLED_DEEPSLATE_STAIRS.defaultBlockState();
    private static final BlockState[][] DECO = new BlockState[][]{{trapDoorBottom, slabBottom, trapDoorBottom, slabBottom, trapDoorBottom, slabBottom, trapDoorBottom}, {woodStairs, trapDoorTop, slabTop, trapDoorTop, slabTop, trapDoorTop, woodStairs}, {wall, button, null, null, null, button, wall}, {wall, stoneStairs, stoneStairs, stoneStairs, stoneStairs, stoneStairs, wall}};

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)ProcessorHandler.BASE_DECO_PROCESSOR.value();
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData, StructureTemplate template) {
        if (blockInfoGlobal.state().is(Blocks.PURPUR_STAIRS)) {
            WorldGenRegion worldGenRegion;
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos(blockInfoGlobal.pos()))) {
                return blockInfoGlobal;
            }
            Direction facing = ((Direction)blockInfoGlobal.state().getValue((Property)StairBlock.FACING)).getOpposite();
            facing = structurePlacementData.getRotation().rotate(facing);
            RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.RED_TERRACOTTA.defaultBlockState(), blockInfoGlobal.nbt());
            for (int x = 0; x < 7; ++x) {
                for (int y = 0; y < 4; ++y) {
                    BlockState state = DECO[y][x];
                    if (state == null) continue;
                    if (state.getBlock() == Blocks.COBBLED_DEEPSLATE_STAIRS) {
                        state = this.chooseRandomState(random);
                    }
                    BlockPos pos = blockInfoGlobal.pos().relative(facing);
                    pos = pos.relative(facing.getClockWise(), x - 3);
                    if (levelReader.getBlockState(pos = pos.relative(Direction.UP, 1 - y)).isSolid() || levelReader.getBlockState(pos.below()).getBlock() == Blocks.DARK_OAK_PLANKS || levelReader.getBlockState(pos.below()).getBlock() == Blocks.STRIPPED_BIRCH_LOG || levelReader.getBlockState(pos.below()).getBlock() == Blocks.BIRCH_PLANKS) continue;
                    if (state.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
                        state = state.getBlock() instanceof StairBlock ? (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing.getOpposite()) : (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing);
                    }
                    levelReader.getChunk(pos).setBlockState(pos, state, false);
                }
            }
        }
        return blockInfoGlobal;
    }

    public BlockState chooseRandomState(RandomSource random) {
        float v = random.nextFloat();
        if ((double)v > 0.7) {
            return Blocks.POLISHED_DEEPSLATE_STAIRS.defaultBlockState();
        }
        return Blocks.COBBLED_DEEPSLATE_STAIRS.defaultBlockState();
    }
}

