/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.frostmaw;

import com.bobmowzie.mowziesmobs.client.particle.ParticleCloud;
import com.bobmowzie.mowziesmobs.client.particle.ParticleRing;
import com.bobmowzie.mowziesmobs.client.particle.ParticleSnowFlake;
import com.bobmowzie.mowziesmobs.client.sound.BossMusic;
import com.bobmowzie.mowziesmobs.client.sound.BossMusicPlayer;
import com.bobmowzie.mowziesmobs.server.advancement.AdvancementHandler;
import com.bobmowzie.mowziesmobs.server.advancement.StealIceCrystalTrigger;
import com.bobmowzie.mowziesmobs.server.ai.MMEntityMoveHelper;
import com.bobmowzie.mowziesmobs.server.ai.MMPathNavigateGround;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationActivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAreaAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDeactivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.ai.animation.SimpleAnimationAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.LegSolverQuadruped;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.MowzieLLibraryEntity;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityIceBall;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityIceBreath;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class EntityFrostmaw
extends MowzieLLibraryEntity
implements Enemy {
    public static final Animation DIE_ANIMATION = Animation.create(94);
    public static final Animation HURT_ANIMATION = Animation.create(0);
    public static final Animation ROAR_ANIMATION = Animation.create(76);
    public static final Animation SWIPE_ANIMATION = Animation.create(28);
    public static final Animation SWIPE_TWICE_ANIMATION = Animation.create(57);
    public static final Animation ICE_BREATH_ANIMATION = Animation.create(92);
    public static final Animation ICE_BALL_ANIMATION = Animation.create(50);
    public static final Animation ACTIVATE_ANIMATION = Animation.create(118);
    public static final Animation ACTIVATE_NO_CRYSTAL_ANIMATION = Animation.create(100);
    public static final Animation DEACTIVATE_ANIMATION = Animation.create(25);
    public static final Animation DODGE_ANIMATION = Animation.create(15);
    public static final Animation LAND_ANIMATION = Animation.create(14);
    public static final Animation SLAM_ANIMATION = Animation.create(113);
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.defineId(EntityFrostmaw.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_CRYSTAL = SynchedEntityData.defineId(EntityFrostmaw.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ALWAYS_ACTIVE = SynchedEntityData.defineId(EntityFrostmaw.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final int ICE_BREATH_COOLDOWN = 260;
    public static final int ICE_BALL_COOLDOWN = 200;
    public static final int SLAM_COOLDOWN = 500;
    public static final int DODGE_COOLDOWN = 200;
    public EntityIceBreath iceBreath;
    public boolean swingWhichArm = false;
    private Vec3 prevRightHandPos = new Vec3(0.0, 0.0, 0.0);
    private Vec3 prevLeftHandPos = new Vec3(0.0, 0.0, 0.0);
    private int iceBreathCooldown = 0;
    private int iceBallCooldown = 0;
    private int slamCooldown = 0;
    private int timeWithoutTarget;
    private int shouldDodgeMeasure = 0;
    private int dodgeCooldown = 0;
    private boolean shouldDodge;
    private float dodgeYaw = 0.0f;
    private boolean wantsToIceBreathAfterDodging = false;
    private Vec3 prevTargetPos = new Vec3(0.0, 0.0, 0.0);
    private boolean shouldPlayLandAnimation = false;
    public LegSolverQuadruped legSolver;

    public EntityFrostmaw(EntityType<? extends EntityFrostmaw> type, Level world) {
        super(type, world);
        this.frame += this.random.nextInt(50);
        this.legSolver = new LegSolverQuadruped(1.0f, 2.0f, -1.0f, 1.5f);
        if (world.isClientSide) {
            this.socketPosArray = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0)};
        }
        this.active = false;
        this.playsHurtAnimation = false;
        this.yBodyRot = this.random.nextFloat() * 360.0f;
        this.setYRot(this.yBodyRot);
        this.xpReward = 60;
        this.moveControl = new MMEntityMoveHelper((Mob)this, 7.0f);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new AnimationAreaAttackAI<EntityFrostmaw>(this, this, SWIPE_ANIMATION, null, null, 2.0f, 6.5f, 6.0f, 135.0f, 1.0f, 9){

            @Override
            public void start() {
                super.start();
            }
        });
        this.goalSelector.addGoal(2, (Goal)new AnimationAreaAttackAI<EntityFrostmaw>(this, SWIPE_TWICE_ANIMATION, null, null, 1.0f, 6.5f, 6.0f, 135.0f, 1.0f, 9){

            @Override
            public void start() {
                super.start();
            }

            @Override
            public void tick() {
                super.tick();
                if (EntityFrostmaw.this.getAnimationTick() == 21) {
                    this.hitEntities();
                }
                if (EntityFrostmaw.this.getAnimationTick() == 16) {
                    EntityFrostmaw.this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_WHOOSH.get(), 2.0f, 0.7f);
                }
                if (EntityFrostmaw.this.getAnimationTick() == 6) {
                    EntityFrostmaw.this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_WHOOSH.get(), 2.0f, 0.8f);
                }
                if (EntityFrostmaw.this.getTarget() != null) {
                    EntityFrostmaw.this.lookControl.setLookAt((Entity)EntityFrostmaw.this.getTarget(), 30.0f, 30.0f);
                }
            }

            @Override
            protected void onAttack(LivingEntity entityTarget, float damageMultiplier, float applyKnockbackMultiplier) {
                Player player;
                super.onAttack(entityTarget, damageMultiplier, applyKnockbackMultiplier);
                if (EntityFrostmaw.this.getAnimationTick() == 21 && entityTarget instanceof Player && (player = (Player)entityTarget).isBlocking()) {
                    player.disableShield();
                }
            }
        });
        this.goalSelector.addGoal(2, new SimpleAnimationAI<EntityFrostmaw>(this, ICE_BREATH_ANIMATION, true));
        this.goalSelector.addGoal(2, (Goal)new SimpleAnimationAI<EntityFrostmaw>(this, ICE_BALL_ANIMATION, true){

            @Override
            public void start() {
                super.start();
                EntityFrostmaw.this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_ICEBALL_CHARGE.get(), 2.0f, 0.9f);
            }
        });
        this.goalSelector.addGoal(2, new SimpleAnimationAI<EntityFrostmaw>(this, ROAR_ANIMATION, false));
        this.goalSelector.addGoal(2, (Goal)new AnimationActivateAI<EntityFrostmaw>(this, ACTIVATE_ANIMATION){

            @Override
            public void start() {
                super.start();
                EntityFrostmaw.this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_WAKEUP.get(), 1.0f, 1.0f);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new AnimationActivateAI<EntityFrostmaw>(this, ACTIVATE_NO_CRYSTAL_ANIMATION){

            @Override
            public void start() {
                super.start();
                EntityFrostmaw.this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_WAKEUP.get(), 1.0f, 1.0f);
            }
        });
        this.goalSelector.addGoal(2, new AnimationDeactivateAI<EntityFrostmaw>(this, DEACTIVATE_ANIMATION));
        this.goalSelector.addGoal(2, new SimpleAnimationAI<EntityFrostmaw>(this, LAND_ANIMATION, false));
        this.goalSelector.addGoal(2, new SimpleAnimationAI<EntityFrostmaw>(this, SLAM_ANIMATION, EnumSet.of(Goal.Flag.LOOK)));
        this.goalSelector.addGoal(2, new SimpleAnimationAI<EntityFrostmaw>(this, DODGE_ANIMATION, EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP)));
        this.goalSelector.addGoal(3, new AnimationTakeDamage<EntityFrostmaw>(this));
        this.goalSelector.addGoal(1, new AnimationDieAI<EntityFrostmaw>(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, false, null));
    }

    protected PathNavigation createNavigation(Level world) {
        return new MMPathNavigateGround(this, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MowzieEntity.createAttributes().add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.MAX_HEALTH, 250.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 50.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected float getWaterSlowDown() {
        return 0.98f;
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ACTIVE, (Object)false);
        builder.define(HAS_CRYSTAL, (Object)true);
        builder.define(ALWAYS_ACTIVE, (Object)false);
    }

    public void playAmbientSound() {
        if (!this.active) {
            return;
        }
        int i = this.random.nextInt(4);
        super.playAmbientSound();
        if (i == 0 && this.getAnimation() == NO_ANIMATION) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, ROAR_ANIMATION);
            return;
        }
        if (i < MMSounds.ENTITY_FROSTMAW_LIVING.size()) {
            this.playSound((SoundEvent)((DeferredHolder)MMSounds.ENTITY_FROSTMAW_LIVING.get(i)).get(), 2.0f, 0.8f + this.random.nextFloat() * 0.3f);
        }
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return super.getAmbientSound();
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    @Override
    protected void repelEntities(float x, float y, float z, float radius) {
        List<Player> nearbyEntities = this.getPlayersNearby(x, y, z, radius);
        for (Entity entity : nearbyEntities) {
            double angle = (this.getAngleBetweenEntities((Entity)this, entity) + 90.0) * Math.PI / 180.0;
            entity.setDeltaMovement(-0.1 * Math.cos(angle), entity.getDeltaMovement().y, -0.1 * Math.sin(angle));
        }
    }

    @Override
    public void tick() {
        block81: {
            block79: {
                block80: {
                    int i;
                    this.setYRot(this.yBodyRot);
                    super.tick();
                    this.repelEntities(3.8f, 3.8f, 3.8f, 3.8f);
                    if (this.getTarget() != null && (!this.getTarget().isAlive() || this.getTarget().getHealth() <= 0.0f)) {
                        this.setTarget(null);
                    }
                    if (this.isAlwaysActive()) {
                        this.setActive(true);
                    }
                    if (!this.getActive() || this.getAnimation() == ACTIVATE_ANIMATION || this.getAnimation() == ACTIVATE_NO_CRYSTAL_ANIMATION) break block79;
                    this.legSolver.update((LivingEntity)this);
                    if ((this.getAnimation() == SWIPE_ANIMATION || this.getAnimation() == SWIPE_TWICE_ANIMATION) && this.getAnimationTick() == 3 && (i = Mth.nextInt((RandomSource)this.random, (int)0, (int)MMSounds.ENTITY_FROSTMAW_ATTACK.size())) < MMSounds.ENTITY_FROSTMAW_ATTACK.size()) {
                        this.playSound((SoundEvent)((DeferredHolder)MMSounds.ENTITY_FROSTMAW_ATTACK.get(i)).get(), 2.0f, 0.9f + this.random.nextFloat() * 0.2f);
                    }
                    if (this.getAnimation() == SWIPE_ANIMATION) {
                        if (this.getAnimationTick() == 6) {
                            this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_WHOOSH.get(), 2.0f, 0.8f);
                        }
                        if (this.getTarget() != null) {
                            this.lookControl.setLookAt((Entity)this.getTarget(), 30.0f, 30.0f);
                        }
                    }
                    if (this.getAnimation() == ROAR_ANIMATION) {
                        if (this.getAnimationTick() == 10) {
                            this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_ROAR.get(), 4.0f, 1.0f);
                            EntityCameraShake.cameraShake(this.level(), this.position(), 45.0f, 0.03f, 60, 20);
                        }
                        if (this.getAnimationTick() >= 8 && this.getAnimationTick() < 65) {
                            this.doRoarEffects();
                        }
                    }
                    if (this.getAnimation() == LAND_ANIMATION && this.getAnimationTick() == 3) {
                        this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_LAND.get(), 3.0f, 0.9f);
                    }
                    if (this.getAnimation() == SLAM_ANIMATION) {
                        if (this.getAnimationTick() == 82) {
                            this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_LIVING_1.get(), 2.0f, 1.0f);
                        }
                        if (this.getTarget() != null) {
                            this.lookControl.setLookAt((Entity)this.getTarget(), 30.0f, 30.0f);
                        }
                        if (this.getAnimationTick() == 82) {
                            i = Mth.nextInt((RandomSource)this.random, (int)0, (int)(MMSounds.ENTITY_FROSTMAW_ATTACK.size() - 1));
                            if (i < MMSounds.ENTITY_FROSTMAW_ATTACK.size()) {
                                this.playSound((SoundEvent)((DeferredHolder)MMSounds.ENTITY_FROSTMAW_ATTACK.get(i)).get(), 2.0f, 0.9f + this.random.nextFloat() * 0.2f);
                            }
                            this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_WHOOSH.get(), 2.0f, 0.7f);
                        }
                        if (this.getAnimationTick() == 87) {
                            this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_LAND.get(), 3.0f, 1.0f);
                            float radius = 4.0f;
                            float slamPosX = (float)(this.getX() + (double)radius * Math.cos(Math.toRadians(this.getYRot() + 90.0f)));
                            float slamPosZ = (float)(this.getZ() + (double)radius * Math.sin(Math.toRadians(this.getYRot() + 90.0f)));
                            if (this.level().isClientSide) {
                                this.level().addParticle((ParticleOptions)new ParticleRing.Data(0.0f, 1.5707964f, 17.0f, 1.0f, 1.0f, 1.0f, 1.0f, 60, false, ParticleRing.EnumRingBehavior.GROW), (double)slamPosX, this.getY() + (double)0.2f, (double)slamPosZ, 0.0, 0.0, 0.0);
                            }
                            AABB hitBox = new AABB((double)(slamPosX - 0.5f), this.getY() - 0.5, (double)(slamPosZ - 0.5f), (double)(slamPosX + 0.5f), this.getY() + 0.5, (double)(slamPosZ + 0.5f)).inflate(3.0, 3.0, 3.0);
                            List entitiesHit = this.level().getEntitiesOfClass(LivingEntity.class, hitBox);
                            for (LivingEntity entity : entitiesHit) {
                                if (entity == this || !(entity.position().distanceToSqr((double)slamPosX, this.getY(), (double)slamPosZ) <= 9.0)) continue;
                                this.doHurtTarget((Entity)entity, 4.0f, 1.0f);
                                if (!entity.isBlocking()) continue;
                                entity.getUseItem().hurtAndBreak(400, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
                            }
                            EntityCameraShake.cameraShake(this.level(), new Vec3((double)slamPosX, this.getY(), (double)slamPosZ), 30.0f, 0.1f, 0, 20);
                        }
                    }
                    if (this.getAnimation() == DODGE_ANIMATION && !this.level().isClientSide) {
                        this.getNavigation().stop();
                        if (this.getAnimationTick() == 2) {
                            this.dodgeYaw = (float)Math.toRadians(this.targetAngle + 90.0f + this.random.nextFloat() * 150.0f - 75.0f);
                        }
                        if (this.getAnimationTick() == 6 && (this.onGround() || this.isInLava() || this.isInWater())) {
                            float speed = 1.7f;
                            Vec3 m = this.getDeltaMovement().add((double)speed * Math.cos(this.dodgeYaw), 0.0, (double)speed * Math.sin(this.dodgeYaw));
                            this.setDeltaMovement(m.x, 0.6, m.z);
                        }
                        if (this.getTarget() != null) {
                            this.lookControl.setLookAt((Entity)this.getTarget(), 30.0f, 30.0f);
                        }
                    }
                    if (this.getAnimation() == ICE_BREATH_ANIMATION) {
                        if (this.getTarget() != null) {
                            this.lookControl.setLookAt((Entity)this.getTarget(), 30.0f, 30.0f);
                            this.lookAt((Entity)this.getTarget(), 30.0f, 30.0f);
                            this.yHeadRot = this.yBodyRot = this.getYRot();
                        }
                        Vec3 mouthPos = new Vec3(2.3, 2.65, 0.0);
                        mouthPos = mouthPos.yRot((float)Math.toRadians(-this.getYRot() - 90.0f));
                        mouthPos = mouthPos.add(this.position());
                        mouthPos = mouthPos.add(new Vec3(0.0, 0.0, 1.0).xRot((float)Math.toRadians(-this.getXRot())).yRot((float)Math.toRadians(-this.yHeadRot)));
                        if (this.getAnimationTick() == 13) {
                            this.iceBreath = new EntityIceBreath((EntityType<? extends EntityIceBreath>)((EntityType)EntityHandler.ICE_BREATH.get()), this.level(), (LivingEntity)this);
                            this.iceBreath.absMoveTo(mouthPos.x, mouthPos.y, mouthPos.z, this.yHeadRot, this.getXRot() + 10.0f);
                            if (!this.level().isClientSide) {
                                this.level().addFreshEntity((Entity)this.iceBreath);
                            }
                        }
                        if (this.iceBreath != null) {
                            this.iceBreath.absMoveTo(mouthPos.x, mouthPos.y, mouthPos.z, this.yHeadRot, this.getXRot() + 10.0f);
                        }
                    }
                    if (this.getAnimation() == ICE_BALL_ANIMATION) {
                        if (this.getTarget() != null) {
                            this.lookControl.setLookAt((Entity)this.getTarget(), 15.0f, 15.0f);
                        }
                        Vec3 projectilePos = new Vec3(2.0, 1.9, 0.0);
                        projectilePos = projectilePos.yRot((float)Math.toRadians(-this.getYRot() - 90.0f));
                        projectilePos = projectilePos.add(this.position());
                        projectilePos = projectilePos.add(new Vec3(0.0, 0.0, 1.0).xRot((float)Math.toRadians(-this.getXRot())).yRot((float)Math.toRadians(-this.yHeadRot)));
                        if (this.level().isClientSide) {
                            Vec3 mouthPos = this.socketPosArray[2];
                            if (this.getAnimationTick() < 12) {
                                Vec3 particlePos;
                                int i2;
                                for (i2 = 0; i2 < 6; ++i2) {
                                    particlePos = new Vec3(3.5, 0.0, 0.0);
                                    particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                                    particlePos = particlePos.xRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                                    float value = this.random.nextFloat() * 0.15f;
                                    this.level().addParticle((ParticleOptions)new ParticleCloud.Data(0.75f + value, 0.75f + value, 1.0f, 5.0f + this.random.nextFloat() * 15.0f, 30, ParticleCloud.EnumCloudBehavior.CONSTANT, 1.0f), mouthPos.x + particlePos.x, mouthPos.y + particlePos.y, mouthPos.z + particlePos.z, -0.1 * particlePos.x, -0.1 * particlePos.y, -0.1 * particlePos.z);
                                }
                                for (i2 = 0; i2 < 8; ++i2) {
                                    particlePos = new Vec3(3.5, 0.0, 0.0);
                                    particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                                    particlePos = particlePos.xRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
                                    this.level().addParticle((ParticleOptions)new ParticleSnowFlake.Data(40.0f, false), mouthPos.x + particlePos.x, mouthPos.y + particlePos.y, mouthPos.z + particlePos.z, -0.07 * particlePos.x, -0.07 * particlePos.y, -0.07 * particlePos.z);
                                }
                            }
                        }
                        if (this.getAnimationTick() == 32 && this.getTarget() != null) {
                            this.prevTargetPos = this.getTarget().position().add(new Vec3(0.0, (double)this.getTarget().getBbHeight() / 2.0, 0.0));
                        }
                        if (this.getAnimationTick() == 33) {
                            this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_ICEBALL_SHOOT.get(), 2.0f, 0.7f);
                            EntityIceBall iceBall = new EntityIceBall((EntityType<? extends EntityIceBall>)((EntityType)EntityHandler.ICE_BALL.get()), this.level(), (LivingEntity)this);
                            iceBall.absMoveTo(projectilePos.x, projectilePos.y, projectilePos.z, this.yHeadRot, this.getXRot() + 10.0f);
                            float projSpeed = 1.6f;
                            if (this.getTarget() != null) {
                                float ticksUntilHit = this.targetDistance / projSpeed;
                                Vec3 targetPos = this.getTarget().position().add(new Vec3(0.0, (double)this.getTarget().getBbHeight() / 2.0, 0.0));
                                Vec3 targetMovement = targetPos.subtract(this.prevTargetPos).scale((double)ticksUntilHit * 0.95);
                                targetMovement = targetMovement.subtract(0.0, targetMovement.y, 0.0);
                                Vec3 futureTargetPos = targetPos.add(targetMovement);
                                Vec3 projectileMid = projectilePos.add(new Vec3(0.0, (double)iceBall.getBbHeight() / 2.0, 0.0));
                                Vec3 shootVec = futureTargetPos.subtract(projectileMid).normalize();
                                iceBall.shoot(shootVec.x, shootVec.y, shootVec.z, projSpeed, 0.0f);
                            } else {
                                iceBall.shoot(this.getLookAngle().x, this.getLookAngle().y, this.getLookAngle().z, projSpeed, 0.0f);
                            }
                            if (!this.level().isClientSide) {
                                this.level().addFreshEntity((Entity)iceBall);
                            }
                        }
                    }
                    this.spawnSwipeParticles();
                    if ((double)this.fallDistance > 0.2 && !this.onGround() && this.getLastDamageSource() != null && !this.getLastDamageSource().is(DamageTypes.LAVA)) {
                        this.shouldPlayLandAnimation = true;
                    }
                    if (this.onGround() && this.shouldPlayLandAnimation && this.getAnimation() != DODGE_ANIMATION) {
                        if (!this.level().isClientSide && this.getAnimation() == NO_ANIMATION) {
                            AnimationHandler.INSTANCE.sendAnimationMessage(this, LAND_ANIMATION);
                        }
                        this.shouldPlayLandAnimation = false;
                    }
                    if (this.getTarget() == null) break block80;
                    this.timeWithoutTarget = 0;
                    float entityHitAngle = (float)((Math.atan2(this.getTarget().getZ() - this.getZ(), this.getTarget().getX() - this.getX()) * 57.29577951308232 - 90.0) % 360.0);
                    float entityAttackingAngle = this.yBodyRot % 360.0f;
                    if (entityHitAngle < 0.0f) {
                        entityHitAngle += 360.0f;
                    }
                    if (entityAttackingAngle < 0.0f) {
                        entityAttackingAngle += 360.0f;
                    }
                    float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                    if (!(!this.getNavigation().isDone() || entityRelativeAngle <= 15.0f && entityRelativeAngle >= -15.0f || entityRelativeAngle >= 345.0f || entityRelativeAngle <= -345.0f)) {
                        this.getNavigation().moveTo((Entity)this.getTarget(), 0.85);
                    }
                    if (this.shouldDodgeMeasure >= 16) {
                        this.shouldDodge = true;
                    }
                    if (this.getTarget().hasEffect(EffectHandler.FROZEN)) {
                        this.shouldDodge = false;
                    }
                    if (this.targetDistance < 4.0f && this.shouldDodge && this.getAnimation() == NO_ANIMATION) {
                        this.shouldDodge = false;
                        this.dodgeCooldown = 200;
                        this.shouldDodgeMeasure = 0;
                        if (this.getHasCrystal()) {
                            this.wantsToIceBreathAfterDodging = true;
                        }
                        this.iceBreathCooldown = 0;
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, DODGE_ANIMATION);
                    }
                    if ((double)this.targetDistance > 5.5 && (this.getAnimation() != ICE_BREATH_ANIMATION || !((double)this.targetDistance < 7.5))) {
                        if (this.getAnimation() != SLAM_ANIMATION) {
                            this.getNavigation().moveTo((Entity)this.getTarget(), 1.0);
                        } else {
                            this.getNavigation().moveTo((Entity)this.getTarget(), 0.95);
                        }
                    } else {
                        this.getNavigation().stop();
                    }
                    if ((double)this.targetDistance <= 8.5 && this.getAnimation() == NO_ANIMATION && this.slamCooldown <= 0 && this.random.nextInt(4) == 0 && (double)this.getHealthRatio() < 0.6) {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, SLAM_ANIMATION);
                        this.slamCooldown = 500;
                    }
                    if ((double)this.targetDistance <= 6.5 && this.getAnimation() == NO_ANIMATION && !this.wantsToIceBreathAfterDodging) {
                        if (this.random.nextInt(4) == 0) {
                            AnimationHandler.INSTANCE.sendAnimationMessage(this, SWIPE_TWICE_ANIMATION);
                        } else {
                            AnimationHandler.INSTANCE.sendAnimationMessage(this, SWIPE_ANIMATION);
                        }
                    }
                    if ((double)this.targetDistance <= 13.5 && this.getAnimation() == NO_ANIMATION && this.iceBreathCooldown <= 0 && this.getHasCrystal() && (this.onGround() || this.wasTouchingWater)) {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, ICE_BREATH_ANIMATION);
                        this.iceBreathCooldown = 260;
                        this.wantsToIceBreathAfterDodging = false;
                    }
                    if (!((double)this.targetDistance >= 14.5) || this.getAnimation() != NO_ANIMATION || this.iceBallCooldown > 0 || !this.getHasCrystal() || !this.onGround() && !this.wasTouchingWater) break block81;
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, ICE_BALL_ANIMATION);
                    this.iceBallCooldown = 200;
                    break block81;
                }
                if (this.level().isClientSide || this.isAlwaysActive()) break block81;
                ++this.timeWithoutTarget;
                if (this.timeWithoutTarget > 1200 || this.level().getDifficulty() == Difficulty.PEACEFUL) {
                    this.timeWithoutTarget = 0;
                    if (this.getAnimation() == NO_ANIMATION) {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, DEACTIVATE_ANIMATION);
                        this.setActive(false);
                    }
                }
                break block81;
            }
            this.getNavigation().stop();
            this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
            this.yBodyRot = this.yBodyRotO;
            if (!this.level().isClientSide && this.getAnimation() != ACTIVATE_ANIMATION && ((Boolean)ConfigHandler.COMMON.MOBS.FROSTMAW.healsOutOfBattle.get()).booleanValue()) {
                this.heal(0.3f);
            }
            if (this.getTarget() != null && this.getTarget().hasEffect(MobEffects.INVISIBILITY)) {
                this.setTarget(null);
            }
            if (!this.getAttackableEntityLivingBaseNearby(8.0, 8.0, 8.0, 8.0).isEmpty() && this.getTarget() != null && this.getAnimation() == NO_ANIMATION && this.level().getDifficulty() != Difficulty.PEACEFUL) {
                if (this.getHasCrystal()) {
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_ANIMATION);
                } else {
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_NO_CRYSTAL_ANIMATION);
                }
                this.setActive(true);
            }
            if (((Boolean)ConfigHandler.COMMON.MOBS.FROSTMAW.stealableIceCrystal.get()).booleanValue() && this.getHasCrystal() && this.tickCount > 20 && this.getAnimation() == NO_ANIMATION) {
                Vec3 crystalPos = new Vec3(1.6, 0.4, 1.8);
                crystalPos = crystalPos.yRot((float)Math.toRadians(-this.getYRot() - 90.0f));
                crystalPos = crystalPos.add(this.position());
                for (Player player : this.getPlayersNearby(8.0, 8.0, 8.0, 8.0)) {
                    if (!(player.position().distanceTo(crystalPos) <= 1.8) || !player.isCreative() && !player.isInvisible() || EntityFrostmaw.isInventoryFull(player.getInventory())) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ItemHandler.ICE_CRYSTAL.get()));
                    this.setHasCrystal(false);
                    if (this.level().getDifficulty() != Difficulty.PEACEFUL) {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_NO_CRYSTAL_ANIMATION);
                        this.setActive(true);
                    }
                    if (!(player instanceof ServerPlayer)) break;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((StealIceCrystalTrigger)((Object)AdvancementHandler.STEAL_ICE_CRYSTAL_TRIGGER.value())).trigger(serverPlayer);
                    break;
                }
            }
        }
        if (this.getAnimation() == ACTIVATE_ANIMATION || this.getAnimation() == ACTIVATE_NO_CRYSTAL_ANIMATION) {
            if (this.getAnimation() == ACTIVATE_ANIMATION && this.getAnimationTick() == 18) {
                this.playSound((SoundEvent)((DeferredHolder)MMSounds.ENTITY_FROSTMAW_ATTACK.get(0)).get(), 1.5f, 1.0f);
            }
            if (this.getAnimation() == ACTIVATE_ANIMATION && this.getAnimationTick() == 52 || this.getAnimation() == ACTIVATE_NO_CRYSTAL_ANIMATION && this.getAnimationTick() == 34) {
                this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_ROAR.get(), 4.0f, 1.0f);
                EntityCameraShake.cameraShake(this.level(), this.position(), 45.0f, 0.03f, 60, 20);
            }
            if (this.getAnimation() == ACTIVATE_ANIMATION && this.getAnimationTick() >= 51 && this.getAnimationTick() < 108 || this.getAnimation() == ACTIVATE_NO_CRYSTAL_ANIMATION && this.getAnimationTick() >= 33 && this.getAnimationTick() < 90) {
                this.doRoarEffects();
            }
        }
        if (this.level().isClientSide && (this.getAnimation() == SWIPE_ANIMATION || this.getAnimation() == SWIPE_TWICE_ANIMATION) && this.getAnimationTick() == 1) {
            this.swingWhichArm = this.random.nextBoolean();
        }
        float moveX = (float)(this.getX() - this.xo);
        float moveZ = (float)(this.getZ() - this.zo);
        float speed = Mth.sqrt((float)(moveX * moveX + moveZ * moveZ));
        if (this.frame % 16 == 5 && (double)speed > 0.05 && this.active) {
            this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_STEP.get(), 3.0f, 0.8f + this.random.nextFloat() * 0.2f);
            EntityCameraShake.cameraShake(this.level(), this.position(), 20.0f, 0.03f, 0, 10);
        }
        if (this.frame % 118 == 1 && !this.active) {
            int i = Mth.nextInt((RandomSource)this.random, (int)0, (int)1);
            this.playSound((SoundEvent)((DeferredHolder)MMSounds.ENTITY_FROSTMAW_BREATH.get(i)).get(), 1.5f, 1.1f + this.random.nextFloat() * 0.1f);
        }
        if (this.iceBreathCooldown > 0) {
            --this.iceBreathCooldown;
        }
        if (this.iceBallCooldown > 0) {
            --this.iceBallCooldown;
        }
        if (this.slamCooldown > 0) {
            --this.slamCooldown;
        }
        if (this.shouldDodgeMeasure > 0 && this.tickCount % 7 == 0) {
            --this.shouldDodgeMeasure;
        }
        if (this.dodgeCooldown > 0) {
            --this.dodgeCooldown;
        }
        this.yRotO = this.getYRot();
    }

    private void doRoarEffects() {
        if (this.getHasCrystal()) {
            List<LivingEntity> entities = this.getEntityLivingBaseNearby(10.0, 3.0, 10.0, 10.0);
            for (LivingEntity entity : entities) {
                if (entity == this) continue;
                double angle = (this.getAngleBetweenEntities((Entity)this, (Entity)entity) + 90.0) * Math.PI / 180.0;
                double distance = this.distanceTo((Entity)entity) - 4.0f;
                entity.setDeltaMovement(entity.getDeltaMovement().add(Math.min(1.0 / (distance * distance), 1.0) * -1.0 * Math.cos(angle), 0.0, Math.min(1.0 / (distance * distance), 1.0) * -1.0 * Math.sin(angle)));
            }
            if (this.getAnimationTick() % 12 == 0 && this.level().isClientSide) {
                double zSpeed;
                double xSpeed;
                double speed;
                double yaw;
                int i;
                int particleCount = 15;
                for (i = 1; i <= particleCount; ++i) {
                    yaw = (float)i * 360.0f / (float)particleCount;
                    speed = 0.9;
                    xSpeed = speed * Math.cos(Math.toRadians(yaw));
                    zSpeed = speed * Math.sin(Math.toRadians(yaw));
                    this.level().addParticle((ParticleOptions)new ParticleCloud.Data(0.75f, 0.75f, 1.0f, 40.0f, 22, ParticleCloud.EnumCloudBehavior.GROW, 1.0f), this.getX(), this.getY() + 1.0, this.getZ(), xSpeed, 0.0, zSpeed);
                }
                for (i = 1; i <= particleCount; ++i) {
                    yaw = (float)i * 360.0f / (float)particleCount;
                    speed = 0.65;
                    xSpeed = speed * Math.cos(Math.toRadians(yaw));
                    zSpeed = speed * Math.sin(Math.toRadians(yaw));
                    this.level().addParticle((ParticleOptions)new ParticleCloud.Data(0.75f, 0.75f, 1.0f, 35.0f, 22, ParticleCloud.EnumCloudBehavior.GROW, 1.0f), this.getX(), this.getY() + 1.0, this.getZ(), xSpeed, 0.0, zSpeed);
                }
            }
        }
    }

    private static boolean isInventoryFull(Inventory inventory) {
        for (ItemStack itemstack : inventory.items) {
            if (!itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean checkSpawnRules(LevelAccessor world, MobSpawnType reason) {
        List<LivingEntity> nearby = this.getEntityLivingBaseNearby(100.0, 100.0, 100.0, 100.0);
        for (LivingEntity nearbyEntity : nearby) {
            if (!(nearbyEntity instanceof EntityFrostmaw) && !(nearbyEntity instanceof Villager)) continue;
            return false;
        }
        return super.checkSpawnRules(world, reason);
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingData) {
        this.setHasCrystal(true);
        return super.finalizeSpawn(world, difficulty, reason, livingData);
    }

    private void spawnSwipeParticles() {
        if (this.level().isClientSide && this.getHasCrystal()) {
            double motionX = this.getDeltaMovement().x();
            double motionY = this.getDeltaMovement().y();
            double motionZ = this.getDeltaMovement().z();
            int snowflakeDensity = 4;
            float snowflakeRandomness = 0.5f;
            int cloudDensity = 2;
            float cloudRandomness = 0.5f;
            if (this.getAnimation() == SWIPE_ANIMATION || this.getAnimation() == SWIPE_TWICE_ANIMATION) {
                Vec3 rightHandPos = this.socketPosArray[0];
                Vec3 leftHandPos = this.socketPosArray[1];
                if (this.getAnimation() == SWIPE_ANIMATION) {
                    if (this.getAnimationTick() > 8 && this.getAnimationTick() < 14) {
                        if (this.swingWhichArm) {
                            double length = this.prevRightHandPos.subtract(rightHandPos).length();
                            int numClouds = (int)Math.floor(2.0 * length);
                            for (int i = 0; i < numClouds; ++i) {
                                float zOffset;
                                float yOffset;
                                float xOffset;
                                int j;
                                double x = this.prevRightHandPos.x + (double)i * (rightHandPos.x - this.prevRightHandPos.x) / (double)numClouds;
                                double y = this.prevRightHandPos.y + (double)i * (rightHandPos.y - this.prevRightHandPos.y) / (double)numClouds;
                                double z = this.prevRightHandPos.z + (double)i * (rightHandPos.z - this.prevRightHandPos.z) / (double)numClouds;
                                for (j = 0; j < snowflakeDensity; ++j) {
                                    xOffset = snowflakeRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                                    yOffset = snowflakeRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                                    zOffset = snowflakeRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                                    this.level().addParticle((ParticleOptions)new ParticleSnowFlake.Data(40.0f, false), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY - (double)0.01f, motionZ);
                                }
                                for (j = 0; j < cloudDensity; ++j) {
                                    xOffset = cloudRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                                    yOffset = cloudRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                                    zOffset = cloudRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                                    float value = this.random.nextFloat() * 0.1f;
                                    this.level().addParticle((ParticleOptions)new ParticleCloud.Data(0.8f + value, 0.8f + value, 1.0f, (float)(10.0 + this.random.nextDouble() * 10.0), 40, ParticleCloud.EnumCloudBehavior.SHRINK, 1.0f), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY, motionZ);
                                }
                            }
                        } else {
                            double length = this.prevLeftHandPos.subtract(leftHandPos).length();
                            int numClouds = (int)Math.floor(2.5 * length);
                            for (int i = 0; i < numClouds; ++i) {
                                float zOffset;
                                float yOffset;
                                float xOffset;
                                int j;
                                double x = this.prevLeftHandPos.x + (double)i * (leftHandPos.x - this.prevLeftHandPos.x) / (double)numClouds;
                                double y = this.prevLeftHandPos.y + (double)i * (leftHandPos.y - this.prevLeftHandPos.y) / (double)numClouds;
                                double z = this.prevLeftHandPos.z + (double)i * (leftHandPos.z - this.prevLeftHandPos.z) / (double)numClouds;
                                for (j = 0; j < snowflakeDensity; ++j) {
                                    xOffset = snowflakeRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                                    yOffset = snowflakeRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                                    zOffset = snowflakeRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                                    this.level().addParticle((ParticleOptions)new ParticleSnowFlake.Data(40.0f, false), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY - (double)0.01f, motionZ);
                                }
                                for (j = 0; j < cloudDensity; ++j) {
                                    xOffset = cloudRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                                    yOffset = cloudRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                                    zOffset = cloudRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                                    float value = this.random.nextFloat() * 0.1f;
                                    this.level().addParticle((ParticleOptions)new ParticleCloud.Data(0.8f + value, 0.8f + value, 1.0f, (float)(10.0 + this.random.nextDouble() * 10.0), 40, ParticleCloud.EnumCloudBehavior.SHRINK, 1.0f), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY, motionZ);
                                }
                            }
                        }
                    }
                } else if (this.swingWhichArm && this.getAnimationTick() > 8 && this.getAnimationTick() < 14 || !this.swingWhichArm && this.getAnimationTick() > 19 && this.getAnimationTick() < 25) {
                    double length = this.prevRightHandPos.subtract(rightHandPos).length();
                    int numClouds = (int)Math.floor(2.0 * length);
                    for (int i = 0; i < numClouds; ++i) {
                        float zOffset;
                        float yOffset;
                        float xOffset;
                        int j;
                        double x = this.prevRightHandPos.x + (double)i * (rightHandPos.x - this.prevRightHandPos.x) / (double)numClouds;
                        double y = this.prevRightHandPos.y + (double)i * (rightHandPos.y - this.prevRightHandPos.y) / (double)numClouds;
                        double z = this.prevRightHandPos.z + (double)i * (rightHandPos.z - this.prevRightHandPos.z) / (double)numClouds;
                        for (j = 0; j < snowflakeDensity; ++j) {
                            xOffset = snowflakeRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                            yOffset = snowflakeRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                            zOffset = snowflakeRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                            this.level().addParticle((ParticleOptions)new ParticleSnowFlake.Data(40.0f, false), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY - (double)0.01f, motionZ);
                        }
                        for (j = 0; j < cloudDensity; ++j) {
                            xOffset = cloudRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                            yOffset = cloudRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                            zOffset = cloudRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                            float value = this.random.nextFloat() * 0.1f;
                            this.level().addParticle((ParticleOptions)new ParticleCloud.Data(0.8f + value, 0.8f + value, 1.0f, (float)(10.0 + this.random.nextDouble() * 10.0), 40, ParticleCloud.EnumCloudBehavior.SHRINK, 1.0f), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY, motionZ);
                        }
                    }
                } else if (!this.swingWhichArm && this.getAnimationTick() > 8 && this.getAnimationTick() < 14 || this.swingWhichArm && this.getAnimationTick() > 19 && this.getAnimationTick() < 25) {
                    double length = this.prevLeftHandPos.subtract(leftHandPos).length();
                    int numClouds = (int)Math.floor(2.5 * length);
                    for (int i = 0; i < numClouds; ++i) {
                        float zOffset;
                        float yOffset;
                        float xOffset;
                        int j;
                        double x = this.prevLeftHandPos.x + (double)i * (leftHandPos.x - this.prevLeftHandPos.x) / (double)numClouds;
                        double y = this.prevLeftHandPos.y + (double)i * (leftHandPos.y - this.prevLeftHandPos.y) / (double)numClouds;
                        double z = this.prevLeftHandPos.z + (double)i * (leftHandPos.z - this.prevLeftHandPos.z) / (double)numClouds;
                        for (j = 0; j < snowflakeDensity; ++j) {
                            xOffset = snowflakeRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                            yOffset = snowflakeRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                            zOffset = snowflakeRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                            this.level().addParticle((ParticleOptions)new ParticleSnowFlake.Data(40.0f, false), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY - (double)0.01f, motionZ);
                        }
                        for (j = 0; j < cloudDensity; ++j) {
                            xOffset = cloudRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                            yOffset = cloudRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                            zOffset = cloudRandomness * (2.0f * this.random.nextFloat() - 1.0f);
                            float value = this.random.nextFloat() * 0.1f;
                            this.level().addParticle((ParticleOptions)new ParticleCloud.Data(0.8f + value, 0.8f + value, 1.0f, (float)(10.0 + this.random.nextDouble() * 10.0), 40, ParticleCloud.EnumCloudBehavior.SHRINK, 1.0f), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY, motionZ);
                        }
                    }
                }
                this.prevLeftHandPos = leftHandPos;
                this.prevRightHandPos = rightHandPos;
            }
        }
    }

    @Override
    public boolean hurt(DamageSource source, float damage) {
        if (source.is(DamageTypeTags.IS_FALL)) {
            return false;
        }
        if (source.is(DamageTypes.LAVA) && this.getAnimation() == NO_ANIMATION) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, DODGE_ANIMATION);
        }
        if (source.is(DamageTypeTags.IS_FIRE)) {
            damage = (float)((double)damage * 1.25);
        }
        if (source.getDirectEntity() instanceof AbstractArrow) {
            this.playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_UNDAMAGED.get(), 0.4f, 2.0f);
            Entity entity = source.getEntity();
            if (!(entity == null || !(entity instanceof LivingEntity) || entity instanceof Player && ((Player)entity).isCreative() || this.getTarget() != null || entity instanceof EntityFrostmaw)) {
                this.setTarget((LivingEntity)entity);
            }
            if (!this.getActive()) {
                if (this.getAnimation() != DIE_ANIMATION && this.level().getDifficulty() != Difficulty.PEACEFUL) {
                    if (this.getHasCrystal()) {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_ANIMATION);
                    } else {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_NO_CRYSTAL_ANIMATION);
                    }
                }
                if (this.level().getDifficulty() != Difficulty.PEACEFUL) {
                    this.setActive(true);
                }
            }
            return false;
        }
        boolean attack = super.hurt(source, damage);
        if (attack) {
            this.shouldDodgeMeasure = (int)((float)this.shouldDodgeMeasure + damage);
            Entity entity = source.getEntity();
            if (!(entity == null || !(entity instanceof LivingEntity) || entity instanceof Player && ((Player)entity).isCreative() || this.getTarget() != null || entity instanceof EntityFrostmaw)) {
                this.setTarget((LivingEntity)entity);
            }
            if (!this.getActive()) {
                if (this.getAnimation() != DIE_ANIMATION && this.level().getDifficulty() != Difficulty.PEACEFUL) {
                    if (this.getHasCrystal()) {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_ANIMATION);
                    } else {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_NO_CRYSTAL_ANIMATION);
                    }
                }
                if (this.level().getDifficulty() != Difficulty.PEACEFUL) {
                    this.setActive(true);
                }
            }
        }
        return attack;
    }

    @Override
    protected void tickDeath() {
        super.tickDeath();
        if (this.getAnimationTick() == 5) {
            this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_DIE.get(), 2.5f, 1.0f);
        } else if (this.getAnimationTick() == 53) {
            this.playSound((SoundEvent)MMSounds.ENTITY_FROSTMAW_LAND.get(), 2.5f, 1.0f);
        }
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    public void setActive(boolean active) {
        this.getEntityData().set(ACTIVE, (Object)active);
    }

    public boolean getActive() {
        this.active = (Boolean)this.getEntityData().get(ACTIVE);
        return this.active;
    }

    public void setHasCrystal(boolean hasCrystal) {
        this.getEntityData().set(HAS_CRYSTAL, (Object)hasCrystal);
    }

    public boolean getHasCrystal() {
        return (Boolean)this.getEntityData().get(HAS_CRYSTAL);
    }

    public boolean isAlwaysActive() {
        return (Boolean)this.getEntityData().get(ALWAYS_ACTIVE);
    }

    public void setAlwaysActive(boolean isAlwaysActive) {
        this.getEntityData().set(ALWAYS_ACTIVE, (Object)isAlwaysActive);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{DIE_ANIMATION, HURT_ANIMATION, ROAR_ANIMATION, SWIPE_ANIMATION, SWIPE_TWICE_ANIMATION, ICE_BREATH_ANIMATION, ICE_BALL_ANIMATION, ACTIVATE_ANIMATION, ACTIVATE_NO_CRYSTAL_ANIMATION, DEACTIVATE_ANIMATION, SLAM_ANIMATION, LAND_ANIMATION, DODGE_ANIMATION};
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("has_crystal")) {
            this.setHasCrystal(compound.getBoolean("has_crystal"));
        }
        this.setActive(compound.getBoolean("active"));
        this.setAlwaysActive(compound.getBoolean("alwaysActive"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("has_crystal", this.getHasCrystal());
        compound.putBoolean("active", this.getActive());
        compound.putBoolean("alwaysActive", this.isAlwaysActive());
    }

    public boolean requiresCustomPersistence() {
        return this.getHasCrystal();
    }

    @Override
    public boolean hasBossBar() {
        return (Boolean)ConfigHandler.COMMON.MOBS.FROSTMAW.hasBossBar.get();
    }

    @Override
    public BossEvent.BossBarColor bossBarColor() {
        return BossEvent.BossBarColor.WHITE;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return LootTableHandler.FROSTMAW;
    }

    @Override
    protected ConfigHandler.CombatConfig getCombatConfig() {
        return ConfigHandler.COMMON.MOBS.FROSTMAW.combatConfig;
    }

    public Vec3 getDeltaMovement() {
        if (!this.getActive()) {
            return super.getDeltaMovement().multiply(0.0, 1.0, 0.0);
        }
        return super.getDeltaMovement();
    }

    @Override
    public boolean hasBossMusic() {
        return true;
    }

    @Override
    public BossMusic<?> getBossMusic() {
        return BossMusicPlayer.FROSTMAW_MUSIC;
    }

    @Override
    protected boolean canPlayMusic() {
        return super.canPlayMusic() && (this.active || this.getAnimation() == ACTIVATE_ANIMATION);
    }

    @Override
    public boolean resetHealthOnPlayerRespawn() {
        return (Boolean)ConfigHandler.COMMON.MOBS.FROSTMAW.resetHealthWhenRespawn.get();
    }
}

