/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects.geomancy;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.bobmowzie.mowziesmobs.client.sound.IGeomancyRumbler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderBase;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderProjectile;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityPillarPiece;
import com.bobmowzie.mowziesmobs.server.entity.sculptor.EntitySculptor;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animation.AnimatableManager;

public class EntityPillar
extends EntityGeomancyBase
implements IGeomancyRumbler {
    private static final EntityDataAccessor<Float> HEIGHT = SynchedEntityData.defineId(EntityPillar.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> RISING = SynchedEntityData.defineId(EntityPillar.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FALLING = SynchedEntityData.defineId(EntityPillar.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final float RISING_SPEED = 0.25f;
    public float prevPrevHeight = 0.0f;
    public float prevHeight = 0.0f;
    public List<Entity> popUpEntities = Collections.emptyList();
    public static final HashMap<EntityGeomancyBase.GeomancyTier, Integer> SIZE_MAP = new HashMap();
    private EntityPillarPiece currentPiece;

    public EntityPillar(EntityType<? extends EntityMagicEffect> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityPillar(EntityType<? extends EntityPillar> type, Level world, LivingEntity caster, BlockState blockState, BlockPos pos) {
        super(type, world, caster, blockState, pos);
        this.setDeathTime(300);
    }

    public boolean checkCanSpawn() {
        if (!this.level().getEntitiesOfClass(EntityPillar.class, this.getBoundingBox().deflate(0.01)).isEmpty()) {
            return false;
        }
        return this.level().noCollision((Entity)this, this.getBoundingBox().deflate(0.01));
    }

    public boolean canCollideWith(Entity p_20303_) {
        return false;
    }

    @Override
    public boolean canBeCollidedWith() {
        return false;
    }

    @Override
    public void tick() {
        this.prevPrevHeight = this.prevHeight;
        this.prevHeight = this.getHeight();
        if (this.firstTick) {
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 2.0f, 1.0f);
            if (!this.isFalling()) {
                this.startRising();
            }
            if (this.level().isClientSide()) {
                MMCommon.PROXY.playGeomancyRumbleSound(this);
            }
        }
        if (!this.level().isClientSide()) {
            if (this.isRising()) {
                height = this.getHeight();
                if ((double)height == 0.0) {
                    this.currentPiece = new EntityPillarPiece((EntityType)EntityHandler.PILLAR_PIECE.get(), this.level(), this, new Vec3(this.getX(), this.getY() - 1.0, this.getZ()));
                    this.level().addFreshEntity((Entity)this.currentPiece);
                }
                this.setHeight(height += 0.25f);
                if (Math.floor(height) > Math.floor(this.prevHeight)) {
                    this.currentPiece = new EntityPillarPiece((EntityType)EntityHandler.PILLAR_PIECE.get(), this.level(), this, new Vec3(this.getX(), this.getY() + Math.floor(height) - 1.0, this.getZ()));
                    this.level().addFreshEntity((Entity)this.currentPiece);
                }
                if (!(this.getCaster() instanceof EntitySculptor)) {
                    List boulders = this.level().getEntitiesOfClass(EntityBoulderProjectile.class, this.getBoundingBox().deflate((double)0.1f));
                    for (EntityBoulderProjectile boulder : boulders) {
                        if (boulder.isTravelling() || boulder.getTier().ordinal() <= this.getTier().ordinal()) continue;
                        this.setTier(boulder.getTier());
                        boulder.explode();
                    }
                }
            } else if (this.isFalling()) {
                height = this.getHeight();
                this.setHeight(height -= 0.25f);
                if ((double)height <= 0.0) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            }
        }
        this.setBoundingBox(this.makeBoundingBox());
        if (this.isRising()) {
            AABB popUpBounds = this.getBoundingBox().deflate((double)0.1f).inflate(0.0, 1.0, 0.0);
            this.popUpEntities = this.level().getEntities((Entity)this, popUpBounds);
            for (Entity entity : this.popUpEntities) {
                if (!entity.isPickable() || entity instanceof EntityBoulderBase || entity instanceof EntityPillar || entity instanceof EntityPillarPiece) continue;
                double belowAmount = entity.getY() - (this.getY() + (double)this.getHeight());
                if (belowAmount < 0.0) {
                    entity.move(MoverType.PISTON, new Vec3(0.0, -belowAmount, 0.0));
                    continue;
                }
                entity.move(MoverType.PISTON, new Vec3(0.0, 0.1, 0.0));
            }
        }
        super.tick();
        if (!this.level().isClientSide() && (this.getCaster() == null || this.getCaster().isRemoved() || (double)this.getCaster().getHealth() <= 0.0)) {
            this.explode();
        }
    }

    protected AABB makeBoundingBox() {
        if (this.tickCount <= 1) {
            return super.makeBoundingBox();
        }
        float f = (float)SIZE_MAP.get((Object)this.getTier()).intValue() / 2.0f - 0.05f;
        return new AABB(this.getX() - (double)f, this.getY(), this.getZ() - (double)f, this.getX() + (double)f, this.getY() + (double)this.getHeight() - (double)0.05f, this.getZ() + (double)f);
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HEIGHT, (Object)Float.valueOf(0.0f));
        builder.define(RISING, (Object)true);
        builder.define(FALLING, (Object)false);
    }

    public float getHeight() {
        return ((Float)this.getEntityData().get(HEIGHT)).floatValue();
    }

    public void setHeight(float height) {
        this.getEntityData().set(HEIGHT, (Object)Float.valueOf(height));
    }

    public void stopRising() {
        this.getEntityData().set(RISING, (Object)false);
        this.setBoundingBox(this.makeBoundingBox());
        this.currentPiece = new EntityPillarPiece((EntityType)EntityHandler.PILLAR_PIECE.get(), this.level(), this, new Vec3(this.getX(), this.getY() + (double)this.getHeight() - 1.0, this.getZ()));
        this.level().addFreshEntity((Entity)this.currentPiece);
    }

    public boolean isRising() {
        return (Boolean)this.getEntityData().get(RISING);
    }

    public void startFalling() {
        this.getEntityData().set(RISING, (Object)false);
        this.getEntityData().set(FALLING, (Object)true);
    }

    public void startRising() {
        this.getEntityData().set(RISING, (Object)true);
        this.getEntityData().set(FALLING, (Object)false);
    }

    public boolean isFalling() {
        return (Boolean)this.getEntityData().get(FALLING);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("height", this.getHeight());
        compound.putBoolean("rising", this.isRising());
        compound.putBoolean("falling", this.isFalling());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHeight(compound.getFloat("height"));
        this.getEntityData().set(RISING, (Object)compound.getBoolean("rising"));
        this.getEntityData().set(FALLING, (Object)compound.getBoolean("falling"));
    }

    @Override
    public boolean doRemoveTimer() {
        return !(this.getCaster() instanceof EntitySculptor);
    }

    @Override
    public boolean isRumbling() {
        return !this.isRemoved() && (this.isFalling() || this.isRising());
    }

    @Override
    public boolean isFinishedRumbling() {
        return this.isRemoved();
    }

    @Override
    public float getRumblerX() {
        return (float)this.getX();
    }

    @Override
    public float getRumblerY() {
        return (float)this.getY();
    }

    @Override
    public float getRumblerZ() {
        return (float)this.getZ();
    }

    @Override
    protected void explode() {
        super.explode();
        int i = 0;
        while ((double)i < Math.min((double)((float)(this.getTier().ordinal() + 1) * this.getHeight()) * 0.25, 30.0)) {
            Vec3 particlePos = new Vec3((double)(this.random.nextFloat() * (float)this.getTier().ordinal()) + 0.1, 0.0, 0.0);
            particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
            particlePos = particlePos.add(new Vec3(0.0, (double)(this.getHeight() * this.random.nextFloat()), 0.0));
            EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), this.level(), 70, this.getBlock());
            fallingBlock.setPos(this.getX() + particlePos.x, this.getY() + 0.5 + particlePos.y, this.getZ() + particlePos.z);
            particlePos = particlePos.normalize();
            fallingBlock.setDeltaMovement((float)particlePos.x, 0.2f + this.random.nextFloat() * 0.6f, (float)particlePos.z);
            this.level().addFreshEntity((Entity)fallingBlock);
            ++i;
        }
    }

    @Override
    protected void spawnExplosionParticles() {
        float width = this.getTier().ordinal() + 1;
        int i = 0;
        while ((float)i < 10.0f * width * this.getHeight()) {
            Vec3 particlePos = new Vec3((double)this.random.nextFloat() * 0.7 * (double)width, 0.0, 0.0);
            particlePos = particlePos.yRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
            particlePos = particlePos.xRot((float)((double)(this.random.nextFloat() * 2.0f) * Math.PI));
            particlePos = particlePos.add(0.0, (double)(this.getHeight() * this.random.nextFloat()), 0.0);
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            boolean overrideLimiter = camera.getPosition().distanceToSqr(this.getX(), this.getY(), this.getZ()) < 4096.0;
            this.level().addAlwaysVisibleParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.getBlock()), overrideLimiter, this.getX() + particlePos.x, this.getY() + 0.5 + particlePos.y, this.getZ() + particlePos.z, particlePos.x, particlePos.y, particlePos.z);
            ++i;
        }
    }

    @Override
    protected float fallingBlockCountMultiplier() {
        return 0.0f;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    static {
        SIZE_MAP.put(EntityGeomancyBase.GeomancyTier.NONE, 1);
        SIZE_MAP.put(EntityGeomancyBase.GeomancyTier.SMALL, 2);
        SIZE_MAP.put(EntityGeomancyBase.GeomancyTier.MEDIUM, 3);
        SIZE_MAP.put(EntityGeomancyBase.GeomancyTier.LARGE, 4);
        SIZE_MAP.put(EntityGeomancyBase.GeomancyTier.HUGE, 5);
    }

    public static class EntityPillarSculptor
    extends EntityPillar {
        public EntityPillarSculptor(EntityType<? extends EntityPillarSculptor> type, Level worldIn) {
            super(type, worldIn);
        }

        public EntityPillarSculptor(EntityType<? extends EntityPillarSculptor> type, Level world, LivingEntity caster, BlockState blockState, BlockPos pos) {
            super((EntityType<? extends EntityPillar>)type, world, caster, blockState, pos);
            this.setDeathTime(300);
        }

        public double getDesiredHeight() {
            return EntitySculptor.TEST_HEIGHT;
        }

        @Override
        public void tick() {
            if (this.getCaster() instanceof EntitySculptor) {
                EntitySculptor sculptor = (EntitySculptor)this.getCaster();
                if (sculptor.getPillar() == null) {
                    sculptor.setPillar(this);
                }
                if (this.level().getBlockState(this.getCaster().blockPosition().above((int)(this.getCaster().getBbHeight() + 1.0f))).blocksMotion()) {
                    this.stopRising();
                }
                if (!(this.level().isClientSide() || sculptor.isFighting() || sculptor.isTesting())) {
                    this.startFalling();
                }
            }
            super.tick();
            if ((double)this.getHeight() >= this.getDesiredHeight() && this.isRising()) {
                this.stopRising();
            }
        }

        @Override
        public void stopRising() {
            super.stopRising();
            LivingEntity livingEntity = this.getCaster();
            if (livingEntity instanceof EntitySculptor) {
                EntitySculptor sculptor = (EntitySculptor)livingEntity;
                sculptor.setPos(this.position().add(0.0, (double)this.getHeight(), 0.0));
            }
        }
    }
}

