/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.bobmowzie.mowziesmobs.server.capability.PlayerData;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemWroughtAxe;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class EntityAxeAttack
extends EntityMagicEffect {
    private static final EntityDataAccessor<Boolean> VERTICAL = SynchedEntityData.defineId(EntityAxeAttack.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<ItemStack> AXE_STACK = SynchedEntityData.defineId(EntityAxeAttack.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static int SWING_DURATION_HOR = 24;
    public static int SWING_DURATION_VER = 30;
    private float quakeAngle = 0.0f;
    private AABB quakeBB = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public EntityAxeAttack(EntityType<? extends EntityAxeAttack> type, Level world) {
        super(type, world);
    }

    public EntityAxeAttack(EntityType<? extends EntityAxeAttack> type, Level world, LivingEntity caster, boolean vertical) {
        super(type, world, caster);
        this.setVertical(vertical);
        this.setAxeStack(caster.getMainHandItem());
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VERTICAL, (Object)false);
        builder.define(AXE_STACK, (Object)((ItemWroughtAxe)((Object)ItemHandler.WROUGHT_AXE.get())).getDefaultInstance());
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getCaster() != null) {
            if (!this.getCaster().isAlive()) {
                this.discard();
            }
            this.absMoveTo(this.getCaster().getX(), this.getCaster().getY() + (double)this.getCaster().getEyeHeight(), this.getCaster().getZ(), this.getCaster().getYRot(), this.getCaster().getXRot());
        }
        if (!this.level().isClientSide && this.tickCount == 7) {
            this.playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_WHOOSH.get(), 0.7f, 1.1f);
        }
        if (!this.level().isClientSide && this.getCaster() != null) {
            if (!this.getVertical() && this.tickCount == SWING_DURATION_HOR / 2 - 1) {
                this.dealDamage(7.0f * ((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.toolConfig.attackDamage.get()).floatValue() / 9.0f, 4.0f, 160.0f, 1.2f);
            } else if (this.getVertical() && this.tickCount == SWING_DURATION_VER / 2 - 1) {
                this.dealDamage(((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.toolConfig.attackDamage.get()).floatValue(), 4.5f, 40.0f, 0.8f);
                this.quakeAngle = this.getYRot();
                this.quakeBB = this.getBoundingBox().move(0.0, (double)(-this.getCaster().getEyeHeight()), 0.0);
                this.playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_AXE_LAND.get(), 0.3f, 0.5f);
                this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 2.0f, 0.9f + this.random.nextFloat() * 0.1f);
            } else if (this.getVertical() && this.tickCount == SWING_DURATION_VER / 2 + 1) {
                EntityCameraShake.cameraShake(this.level(), this.position(), 10.0f, 0.05f, 0, 10);
            }
        }
        if (this.getVertical() && this.getCaster() != null && this.tickCount >= SWING_DURATION_VER / 2) {
            int maxDistance = 16;
            double perpFacing = (double)this.quakeAngle * (Math.PI / 180);
            double facingAngle = perpFacing + 1.5707963267948966;
            int hitY = Mth.floor((double)(this.quakeBB.minY - 0.5));
            int distance = this.tickCount - 15;
            double spread = 1.099557410031076;
            int arcLen = Mth.ceil((double)((double)distance * spread));
            double minY = this.quakeBB.minY;
            double maxY = this.quakeBB.maxY;
            for (int i = 0; i < arcLen; ++i) {
                double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
                double vx = Math.cos(theta);
                double vz = Math.sin(theta);
                double px = this.getX() + vx * (double)distance;
                double pz = this.getZ() + vz * (double)distance;
                float factor = 1.0f - (float)distance / (float)maxDistance;
                AABB selection = new AABB(px - 1.5, minY, pz - 1.5, px + 1.5, maxY, pz + 1.5);
                List hit = this.level().getEntitiesOfClass(Entity.class, selection);
                for (Entity entity : hit) {
                    if (!entity.onGround() || entity == this || entity instanceof FallingBlockEntity || entity == this.getCaster()) continue;
                    float applyKnockbackResistance = 0.0f;
                    boolean hitEntity = false;
                    if (!this.raytraceCheckEntity(entity)) continue;
                    hitEntity = this.getCaster() instanceof Player ? entity.hurt(this.damageSources().playerAttack((Player)this.getCaster()), (factor * 5.0f + 1.0f) * (((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.toolConfig.attackDamage.get()).floatValue() / 9.0f)) : entity.hurt(this.damageSources().mobAttack(this.getCaster()), (factor * 5.0f + 1.0f) * (((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.toolConfig.attackDamage.get()).floatValue() / 9.0f));
                    if (entity instanceof LivingEntity) {
                        applyKnockbackResistance = (float)((LivingEntity)entity).getAttribute(Attributes.KNOCKBACK_RESISTANCE).getValue();
                    }
                    if (!hitEntity) continue;
                    double magnitude = -4.0;
                    double x = vx * (double)(1.0f - factor) * magnitude * (double)(1.0f - applyKnockbackResistance);
                    double y = 0.0;
                    if (entity.onGround()) {
                        y += 0.15 * (double)(1.0f - applyKnockbackResistance);
                    }
                    double z = vz * (double)(1.0f - factor) * magnitude * (double)(1.0f - applyKnockbackResistance);
                    entity.setDeltaMovement(entity.getDeltaMovement().add(x, y, z));
                    if (!(entity instanceof ServerPlayer)) continue;
                    ((ServerPlayer)entity).connection.send((Packet)new ClientboundSetEntityMotionPacket(entity));
                }
                if (!this.level().random.nextBoolean()) continue;
                int hitX = Mth.floor((double)px);
                int hitZ = Mth.floor((double)pz);
                BlockPos pos = new BlockPos(hitX, hitY, hitZ);
                BlockPos abovePos = new BlockPos((Vec3i)pos).above();
                BlockState block = this.level().getBlockState(pos);
                BlockState blockAbove = this.level().getBlockState(abovePos);
                if (block.isAir() || !block.isRedstoneConductor((BlockGetter)this.level(), pos) || block.hasBlockEntity() || blockAbove.blocksMotion()) continue;
                EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), this.level(), block, 0.3f);
                fallingBlock.setPos((double)hitX + 0.5, hitY + 1, (double)hitZ + 0.5);
                this.level().addFreshEntity((Entity)fallingBlock);
            }
        }
        if (this.tickCount > SWING_DURATION_HOR) {
            this.discard();
        }
    }

    private void dealDamage(float damage, float range, float arc, float applyKnockback) {
        boolean hit = false;
        List<Entity> entitiesHit = this.getEntitiesNearby(range, 2.0, range, range);
        for (Entity entityHit : entitiesHit) {
            if (entityHit instanceof ItemEntity) continue;
            float entityHitAngle = (float)((Math.atan2(entityHit.getZ() - this.getZ(), entityHit.getX() - this.getX()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.getYRot() % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.getZ() - this.getZ()) * (entityHit.getZ() - this.getZ()) + (entityHit.getX() - this.getX()) * (entityHit.getX() - this.getX())) - entityHit.getBbWidth() / 2.0f;
            if (!(entityHit != this.getCaster() && (!(entityHit instanceof Parrot) || entityHit.getVehicle() != this.getCaster()) && entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || !this.raytraceCheckEntity(entityHit)) continue;
            LivingEntity livingEntity = this.getCaster();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                PlayerData data = DataHandler.getData((Entity)player, DataHandler.PLAYER_DATA);
                data.setAxeCanAttack(true);
                this.attackTargetEntityWithCurrentItem(entityHit, player, damage / ((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.AXE_OF_A_THOUSAND_METALS.toolConfig.attackDamage.get()).floatValue(), applyKnockback);
                data.setAxeCanAttack(false);
            }
            hit = true;
        }
        if (hit) {
            this.playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_AXE_HIT.get(), 0.3f, 0.5f);
        }
    }

    public void setVertical(boolean vertical) {
        this.getEntityData().set(VERTICAL, (Object)vertical);
    }

    public boolean getVertical() {
        return (Boolean)this.getEntityData().get(VERTICAL);
    }

    private List<Entity> getEntitiesNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(distanceX, distanceY, distanceZ));
        ArrayList nearEntities = list.stream().filter(entityNeighbor -> entityNeighbor != null && (double)this.distanceTo((Entity)entityNeighbor) <= radius + (double)(entityNeighbor.getBbWidth() / 2.0f)).collect(Collectors.toCollection(ArrayList::new));
        return nearEntities;
    }

    public void setAxeStack(ItemStack axeStack) {
        this.getEntityData().set(AXE_STACK, (Object)axeStack);
    }

    public ItemStack getAxeStack() {
        return (ItemStack)this.getEntityData().get(AXE_STACK);
    }

    public void attackTargetEntityWithCurrentItem(Entity targetEntity, Player player, float damageMult, float knockbackMult) {
        Projectile projectile;
        if (!CommonHooks.onPlayerAttackTarget((Player)player, (Entity)targetEntity) || !targetEntity.isAttackable()) {
            return;
        }
        ItemStack oldStack = player.getMainHandItem();
        ItemStack newStack = this.getAxeStack();
        this.resetModifiers(player, oldStack, newStack);
        player.setItemInHand(InteractionHand.MAIN_HAND, newStack);
        if (targetEntity.skipAttackInteraction((Entity)player)) {
            this.resetModifiers(player, newStack, oldStack);
            player.setItemInHand(InteractionHand.MAIN_HAND, oldStack);
            return;
        }
        if (targetEntity.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && targetEntity instanceof Projectile && (projectile = (Projectile)targetEntity).deflect(ProjectileDeflection.AIM_DEFLECT, (Entity)this, (Entity)this, true)) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, this.getSoundSource());
            this.resetModifiers(player, newStack, oldStack);
            player.setItemInHand(InteractionHand.MAIN_HAND, oldStack);
            return;
        }
        DamageSource damageSource = this.damageSources().playerAttack(player);
        float attackDamage = (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE) * damageMult;
        float enchantedDamage = player.getEnchantedDamage(targetEntity, attackDamage, damageSource);
        if (attackDamage > 0.0f || enchantedDamage > 0.0f) {
            float f;
            boolean wasSprinting = false;
            if (player.isSprinting()) {
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_KNOCKBACK, player.getSoundSource(), 1.0f, 1.0f);
                wasSprinting = true;
            }
            attackDamage += newStack.getItem().getAttackDamageBonus(targetEntity, attackDamage, damageSource);
            float damage = attackDamage + enchantedDamage;
            if (targetEntity instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)targetEntity;
                f = livingTarget.getHealth();
            } else {
                f = 0.0f;
            }
            float targetHealth = f;
            Vec3 targetMovement = targetEntity.getDeltaMovement();
            boolean wasHurt = targetEntity.hurt(damageSource, damage);
            if (wasHurt) {
                float knockback = player.getKnockback(targetEntity, damageSource) + (float)(wasSprinting ? 1 : 0);
                if (knockback > 0.0f) {
                    if (targetEntity instanceof LivingEntity) {
                        LivingEntity livingTarget = (LivingEntity)targetEntity;
                        livingTarget.knockback((double)(knockback * 0.5f * knockbackMult), (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                    } else {
                        targetEntity.push((double)(-Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))) * knockback * 0.5f * knockbackMult), 0.1, (double)(Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180))) * knockback * 0.5f * knockbackMult));
                    }
                    player.setDeltaMovement(player.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                    player.setSprinting(false);
                }
                if (targetEntity instanceof ServerPlayer && targetEntity.hurtMarked) {
                    ((ServerPlayer)targetEntity).connection.send((Packet)new ClientboundSetEntityMotionPacket(targetEntity));
                    targetEntity.hurtMarked = false;
                    targetEntity.setDeltaMovement(targetMovement);
                }
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_STRONG, player.getSoundSource(), 1.0f, 1.0f);
                if (enchantedDamage > 0.0f) {
                    player.magicCrit(targetEntity);
                }
                player.setLastHurtMob(targetEntity);
                Entity entity = targetEntity;
                if (targetEntity instanceof PartEntity) {
                    PartEntity part = (PartEntity)targetEntity;
                    entity = part.getParent();
                }
                ItemStack copy = newStack.copy();
                boolean hurtEnemy = false;
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        hurtEnemy = newStack.hurtEnemy(livingEntity, player);
                    }
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)targetEntity, (DamageSource)damageSource);
                }
                if (!this.level().isClientSide() && !copy.isEmpty() && entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (hurtEnemy) {
                        newStack.postHurtEnemy(livingEntity, player);
                    }
                    if (newStack.isEmpty()) {
                        EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)InteractionHand.MAIN_HAND);
                        player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                    }
                }
                if (targetEntity instanceof LivingEntity) {
                    LivingEntity livingTarget = (LivingEntity)targetEntity;
                    float healthDifference = targetHealth - livingTarget.getHealth();
                    player.awardStat(Stats.DAMAGE_DEALT, Math.round(healthDifference * 10.0f));
                    Level level2 = this.level();
                    if (level2 instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level2;
                        if (healthDifference > 2.0f) {
                            int particleCount = (int)((double)healthDifference * 0.5);
                            serverLevel.sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, targetEntity.getX(), targetEntity.getY(0.5), targetEntity.getZ(), particleCount, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                }
                player.causeFoodExhaustion(0.1f);
            } else {
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, player.getSoundSource(), 1.0f, 1.0f);
            }
        }
        this.resetModifiers(player, newStack, oldStack);
        player.setItemInHand(InteractionHand.MAIN_HAND, oldStack);
    }

    private void resetModifiers(Player player, ItemStack removeFrom, ItemStack addFrom) {
        removeFrom.forEachModifier(EquipmentSlot.MAINHAND, (attribute, modifier) -> {
            AttributeInstance instance = player.getAttribute(attribute);
            if (instance != null) {
                instance.removeModifier(modifier);
            }
        });
        addFrom.forEachModifier(EquipmentSlot.MAINHAND, (attribute, modifier) -> {
            AttributeInstance instance = player.getAttribute(attribute);
            if (instance != null) {
                instance.addTransientModifier(modifier);
            }
        });
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setAxeStack(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)compound.getCompound("axe_stack")));
        this.setVertical(compound.getBoolean("vertical"));
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("axe_stack", this.getAxeStack().save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        compound.putBoolean("vertical", this.getVertical());
    }
}

