/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ai.animation;

import com.bobmowzie.mowziesmobs.server.ai.animation.SimpleAnimationAI;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class AnimationAttackAI<T extends MowzieEntity>
extends SimpleAnimationAI<T> {
    protected LivingEntity entityTarget = null;
    protected SoundEvent attackSound;
    protected float applyKnockbackMultiplier = 1.0f;
    protected float range;
    protected float damageMultiplier;
    protected int damageFrame;
    protected SoundEvent hitSound;

    public AnimationAttackAI(T entity, Animation animation, SoundEvent attackSound, SoundEvent hitSound, float applyKnockback, float range, float damageMultiplier, int damageFrame) {
        this(entity, animation, attackSound, hitSound, applyKnockback, range, damageMultiplier, damageFrame, false);
    }

    public AnimationAttackAI(T entity, Animation animation, SoundEvent attackSound, SoundEvent hitSound, float applyKnockbackMultiplier, float range, float damageMultiplier, int damageFrame, boolean hurtInterrupts) {
        super(entity, animation, false, hurtInterrupts);
        this.attackSound = attackSound;
        this.applyKnockbackMultiplier = applyKnockbackMultiplier;
        this.range = range;
        this.damageMultiplier = damageMultiplier;
        this.damageFrame = damageFrame;
        this.hitSound = hitSound;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    @Override
    public void start() {
        super.start();
        this.entityTarget = this.entity.getTarget();
    }

    public void tick() {
        super.tick();
        if (((IAnimatedEntity)((Object)this.entity)).getAnimationTick() < this.damageFrame && this.entityTarget != null) {
            this.entity.lookAt((Entity)this.entityTarget, 30.0f, 30.0f);
        }
        if (((IAnimatedEntity)((Object)this.entity)).getAnimationTick() == this.damageFrame) {
            if (this.entityTarget != null && this.entity.targetDistance <= this.range) {
                this.entity.doHurtTarget((Entity)this.entityTarget, this.damageMultiplier, this.applyKnockbackMultiplier);
                this.onAttack(this.entityTarget, this.damageMultiplier, this.applyKnockbackMultiplier);
                if (this.hitSound != null) {
                    this.entity.playSound(this.hitSound, 1.0f, 1.0f);
                }
            }
            if (this.attackSound != null) {
                this.entity.playSound(this.attackSound, 1.0f, 1.0f);
            }
        }
    }

    protected void onAttack(LivingEntity entityTarget, float damageMultiplier, float applyKnockbackMultiplier) {
    }
}

