/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities.mob;

import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.entity.MowzieGeckoEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib.animation.RawAnimation;

public class MeleeAttackAbility<T extends MowzieGeckoEntity>
extends Ability<T> {
    protected SoundEvent attackSound;
    protected float knockBackMultiplier = 0.0f;
    protected float range;
    protected float damageMultiplier;
    protected SoundEvent hitSound;
    protected boolean hurtInterrupts;
    protected RawAnimation[] animations;

    public MeleeAttackAbility(AbilityType<T, ? extends MeleeAttackAbility<T>> abilityType, T user, RawAnimation[] animations, SoundEvent attackSound, SoundEvent hitSound, float knockBackMultiplier, float range, float damageMultiplier, int startup, int recovery, boolean hurtInterrupts) {
        super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, startup), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, recovery)}, 0);
        this.attackSound = attackSound;
        this.hitSound = hitSound;
        this.knockBackMultiplier = knockBackMultiplier;
        this.damageMultiplier = damageMultiplier;
        this.range = range;
        this.hurtInterrupts = hurtInterrupts;
        this.animations = animations;
    }

    @Override
    public void tickUsing() {
        super.tickUsing();
        if (((MowzieGeckoEntity)this.getUser()).getTarget() != null) {
            ((MowzieGeckoEntity)this.getUser()).lookAt((Entity)((MowzieGeckoEntity)this.getUser()).getTarget(), 30.0f, 30.0f);
            ((MowzieGeckoEntity)this.getUser()).getLookControl().setLookAt((Entity)((MowzieGeckoEntity)this.getUser()).getTarget(), 30.0f, 30.0f);
        }
        ((MowzieGeckoEntity)this.getUser()).getNavigation().stop();
        ((MowzieGeckoEntity)this.getUser()).getMoveControl().strafe(0.0f, 0.0f);
        ((MowzieGeckoEntity)this.getUser()).setStrafing(false);
    }

    @Override
    public void start() {
        super.start();
        RawAnimation animation = this.animations[((MowzieGeckoEntity)this.getUser()).getRandom().nextInt(this.animations.length)];
        this.playAnimation(animation);
    }

    @Override
    protected void beginSection(AbilitySection section) {
        super.beginSection(section);
        if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
            LivingEntity entityTarget = ((MowzieGeckoEntity)this.getUser()).getTarget();
            if (entityTarget != null && ((MowzieGeckoEntity)this.getUser()).targetDistance <= this.range) {
                ((MowzieGeckoEntity)this.getUser()).doHurtTarget((Entity)entityTarget, this.damageMultiplier, this.knockBackMultiplier);
                this.onAttack(entityTarget, this.damageMultiplier, this.knockBackMultiplier);
                if (this.hitSound != null) {
                    ((MowzieGeckoEntity)this.getUser()).playSound(this.hitSound, 1.0f, 1.0f);
                }
            }
            if (this.attackSound != null) {
                ((MowzieGeckoEntity)this.getUser()).playSound(this.attackSound, 1.0f, 1.0f);
            }
        }
    }

    protected void onAttack(LivingEntity entityTarget, float damageMultiplier, float applyKnockbackMultiplier) {
    }

    @Override
    public boolean damageInterrupts() {
        return this.hurtInterrupts;
    }
}

